/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.trac.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.mylyn.commons.net.Policy;
import org.eclipse.mylyn.internal.trac.core.Messages;
import org.eclipse.mylyn.internal.trac.core.TracAttribute;
import org.eclipse.mylyn.internal.trac.core.TracAttributeMapper;
import org.eclipse.mylyn.internal.trac.core.TracCorePlugin;
import org.eclipse.mylyn.internal.trac.core.TracRepositoryConnector;
import org.eclipse.mylyn.internal.trac.core.client.ITracClient;
import org.eclipse.mylyn.internal.trac.core.client.InvalidTicketException;
import org.eclipse.mylyn.internal.trac.core.model.TracAction;
import org.eclipse.mylyn.internal.trac.core.model.TracAttachment;
import org.eclipse.mylyn.internal.trac.core.model.TracComment;
import org.eclipse.mylyn.internal.trac.core.model.TracTicket;
import org.eclipse.mylyn.internal.trac.core.model.TracTicketField;
import org.eclipse.mylyn.internal.trac.core.util.TracUtil;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.RepositoryResponse;
import org.eclipse.mylyn.tasks.core.RepositoryStatus;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskDataHandler;
import org.eclipse.mylyn.tasks.core.data.TaskAttachmentMapper;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMetaData;
import org.eclipse.mylyn.tasks.core.data.TaskCommentMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskMapper;
import org.eclipse.mylyn.tasks.core.data.TaskOperation;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TracTaskDataHandler
extends AbstractTaskDataHandler {
    private static final String TASK_DATA_VERSION = "2";
    public static final String ATTRIBUTE_BLOCKED_BY = "blockedby";
    public static final String ATTRIBUTE_BLOCKING = "blocking";
    private static final String CC_DELIMETER = ", ";
    private static final String TRAC_KEY = "tracKey";
    private final TracRepositoryConnector connector;

    public TracTaskDataHandler(TracRepositoryConnector connector) {
        this.connector = connector;
    }

    public TaskData getTaskData(TaskRepository repository, String taskId, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        try {
            monitor.beginTask("Task Download", -1);
            TaskData taskData = this.downloadTaskData(repository, TracRepositoryConnector.getTicketId(taskId), monitor);
            return taskData;
        }
        finally {
            monitor.done();
        }
    }

    public TaskData downloadTaskData(TaskRepository repository, int taskId, IProgressMonitor monitor) throws CoreException {
        TracTicket ticket;
        ITracClient client = this.connector.getClientManager().getTracClient(repository);
        try {
            client.updateAttributes(monitor, false);
            ticket = client.getTicket(taskId, monitor);
        }
        catch (OperationCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CoreException(TracCorePlugin.toStatus(e, repository));
        }
        return this.createTaskDataFromTicket(client, repository, ticket, monitor);
    }

    public TaskData createTaskDataFromTicket(ITracClient client, TaskRepository repository, TracTicket ticket, IProgressMonitor monitor) throws CoreException {
        TaskData taskData = new TaskData(this.getAttributeMapper(repository), "trac", repository.getRepositoryUrl(), String.valueOf(ticket.getId()));
        taskData.setVersion(TASK_DATA_VERSION);
        try {
            if (!TracRepositoryConnector.hasRichEditor(repository)) {
                TracTaskDataHandler.createDefaultAttributes(taskData, client, true);
                Set<TaskAttribute> changedAttributes = TracTaskDataHandler.updateTaskData(repository, taskData, ticket);
                ArrayList attributes = new ArrayList(taskData.getRoot().getAttributes().values());
                for (TaskAttribute attribute : attributes) {
                    if (changedAttributes.contains(attribute) || TracAttributeMapper.isInternalAttribute(attribute)) continue;
                    taskData.getRoot().removeAttribute(attribute.getId());
                }
                taskData.setPartial(true);
            } else {
                TracTaskDataHandler.createDefaultAttributes(taskData, client, true);
                TracTaskDataHandler.updateTaskData(repository, taskData, ticket);
            }
            return taskData;
        }
        catch (OperationCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CoreException(TracCorePlugin.toStatus(e, repository));
        }
    }

    public static Set<TaskAttribute> updateTaskData(TaskRepository repository, TaskData data, TracTicket ticket) {
        TracAction[] actions;
        TracAttachment[] attachments;
        TaskAttribute attribute;
        TaskAttachmentMapper mapper;
        TaskAttribute taskAttribute;
        HashSet<TaskAttribute> changedAttributes = new HashSet<TaskAttribute>();
        Date lastChanged = ticket.getLastChanged();
        if (lastChanged != null) {
            taskAttribute = data.getRoot().getAttribute(TracAttribute.CHANGE_TIME.getTracKey());
            taskAttribute.setValue(String.valueOf(TracUtil.toTracTime(lastChanged)));
            changedAttributes.add(taskAttribute);
        }
        if (ticket.getCreated() != null) {
            taskAttribute = data.getRoot().getAttribute(TracAttribute.TIME.getTracKey());
            taskAttribute.setValue(String.valueOf(TracUtil.toTracTime(ticket.getCreated())));
            changedAttributes.add(taskAttribute);
        }
        Map<String, String> valueByKey = ticket.getValues();
        for (String key : valueByKey.keySet()) {
            TaskAttribute taskAttribute2 = data.getRoot().getAttribute(key);
            if (taskAttribute2 == null) continue;
            if (TracTicket.Key.CC.getKey().equals(key)) {
                StringTokenizer t = new StringTokenizer(valueByKey.get(key), CC_DELIMETER);
                while (t.hasMoreTokens()) {
                    taskAttribute2.addValue(t.nextToken());
                }
            } else {
                taskAttribute2.setValue(valueByKey.get(key));
            }
            changedAttributes.add(taskAttribute2);
        }
        TracComment[] comments = ticket.getComments();
        if (comments != null) {
            int count = 1;
            int i = 0;
            while (i < comments.length) {
                if ("comment".equals(comments[i].getField()) && !"".equals(comments[i].getNewValue())) {
                    mapper = new TaskCommentMapper();
                    mapper.setAuthor(repository.createPerson(comments[i].getAuthor()));
                    mapper.setCreationDate(comments[i].getCreated());
                    mapper.setText(comments[i].getNewValue());
                    mapper.setNumber(Integer.valueOf(count));
                    attribute = data.getRoot().createAttribute("task.common.comment-" + count);
                    mapper.applyTo(attribute);
                    ++count;
                }
                ++i;
            }
        }
        if ((attachments = ticket.getAttachments()) != null) {
            int i = 0;
            while (i < attachments.length) {
                mapper = new TaskAttachmentMapper();
                mapper.setAuthor(repository.createPerson(attachments[i].getAuthor()));
                mapper.setDescription(attachments[i].getDescription());
                mapper.setFileName(attachments[i].getFilename());
                mapper.setLength(Long.valueOf(attachments[i].getSize()));
                if (attachments[i].getCreated() != null) {
                    if (lastChanged == null || attachments[i].getCreated().after(lastChanged)) {
                        lastChanged = attachments[i].getCreated();
                    }
                    mapper.setCreationDate(attachments[i].getCreated());
                }
                mapper.setUrl(String.valueOf(repository.getRepositoryUrl()) + "/attachment/ticket/" + ticket.getId() + "/" + TracUtil.encodeUrl(attachments[i].getFilename()));
                mapper.setAttachmentId(String.valueOf(i));
                attribute = data.getRoot().createAttribute("task.common.attachment-" + (i + 1));
                mapper.applyTo(attribute);
                ++i;
            }
        }
        if ((actions = ticket.getActions()) != null) {
            TracAction[] tracActionArray = actions;
            int n = actions.length;
            int n2 = 0;
            while (n2 < n) {
                TracAction action;
                TracTaskDataHandler.addOperation(repository, data, ticket, action, (action = tracActionArray[n2]) == actions[0]);
                ++n2;
            }
        }
        return changedAttributes;
    }

    private static void addOperation(TaskRepository repository, TaskData data, TracTicket ticket, TracAction action, boolean setAsDefault) {
        String label = action.getLabel();
        if (label == null) {
            String resolution;
            String status;
            label = "leave".equals(action.getId()) ? ((status = ticket.getValue(TracTicket.Key.STATUS)) != null ? ((resolution = ticket.getValue(TracTicket.Key.RESOLUTION)) != null ? NLS.bind((String)Messages.TracTaskDataHandler_Leave_as_Status_Resolution, (Object)status, (Object)resolution) : NLS.bind((String)Messages.TracTaskDataHandler_Leave_as_Status, (Object)status)) : Messages.TracTaskDataHandler_Leave) : ("accept".equals(action.getId()) ? Messages.TracTaskDataHandler_Accept : ("resolve".equals(action.getId()) ? Messages.TracTaskDataHandler_Resolve_as : ("reopen".equals(action.getId()) ? Messages.TracTaskDataHandler_Reopen : action.getId())));
        }
        if (label != null) {
            TaskAttribute attribute = data.getRoot().createAttribute("task.common.operation-" + action.getId());
            TaskOperation.applyTo((TaskAttribute)attribute, (String)action.getId(), (String)label);
            if (!action.getFields().isEmpty()) {
                TracTicketField field = action.getFields().get(0);
                TaskAttribute fieldAttribute = TracTaskDataHandler.createAttribute(data, field);
                fieldAttribute.getMetaData().setKind(null);
                attribute.getMetaData().putValue("task.meta.associated.attribute", fieldAttribute.getId());
            } else if ("resolve".equals(action)) {
                attribute.getMetaData().putValue("task.meta.associated.attribute", TracAttribute.RESOLUTION.getTracKey());
            }
            if (setAsDefault) {
                TaskAttribute operationAttribute = data.getRoot().createAttribute("task.common.operation");
                TaskOperation.applyTo((TaskAttribute)operationAttribute, (String)action.getId(), (String)label);
            }
        }
    }

    public static void createDefaultAttributes(TaskData data, ITracClient client, boolean existingTask) {
        data.setVersion(TASK_DATA_VERSION);
        TracTaskDataHandler.createAttribute(data, TracAttribute.SUMMARY);
        TracTaskDataHandler.createAttribute(data, TracAttribute.DESCRIPTION);
        if (existingTask) {
            TracTaskDataHandler.createAttribute(data, TracAttribute.TIME);
            TracTaskDataHandler.createAttribute(data, TracAttribute.CHANGE_TIME);
            TracTaskDataHandler.createAttribute(data, TracAttribute.STATUS, client.getTicketStatus());
            TracTaskDataHandler.createAttribute(data, TracAttribute.RESOLUTION, client.getTicketResolutions());
        }
        TracTaskDataHandler.createAttribute(data, TracAttribute.COMPONENT, client.getComponents());
        TracTaskDataHandler.createAttribute(data, TracAttribute.VERSION, client.getVersions(), true);
        TracTaskDataHandler.createAttribute(data, TracAttribute.PRIORITY, client.getPriorities());
        TracTaskDataHandler.createAttribute(data, TracAttribute.SEVERITY, client.getSeverities());
        TracTaskDataHandler.createAttribute(data, TracAttribute.MILESTONE, client.getMilestones(), true);
        TracTaskDataHandler.createAttribute(data, TracAttribute.TYPE, client.getTicketTypes());
        TracTaskDataHandler.createAttribute(data, TracAttribute.KEYWORDS);
        TracTicketField[] fields = client.getTicketFields();
        if (fields != null) {
            TracTicketField[] tracTicketFieldArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                TracTicketField field = tracTicketFieldArray[n2];
                if (field.isCustom()) {
                    TracTaskDataHandler.createAttribute(data, field);
                }
                ++n2;
            }
        }
        TracTaskDataHandler.createAttribute(data, TracAttribute.OWNER);
        if (existingTask) {
            TracTaskDataHandler.createAttribute(data, TracAttribute.REPORTER);
        }
        TracTaskDataHandler.createAttribute(data, TracAttribute.CC);
        if (existingTask) {
            data.getRoot().createAttribute("task.common.newcc").getMetaData().setType("shortText").setReadOnly(false);
            data.getRoot().createAttribute("task.common.removecc");
            data.getRoot().createAttribute("task.common.comment.new").getMetaData().setType("longRichText").setReadOnly(false);
        }
        data.getRoot().createAttribute("task.common.operation").getMetaData().setType("operation");
    }

    /*
     * Unable to fully structure code
     */
    private static TaskAttribute createAttribute(TaskData data, TracTicketField field) {
        block19: {
            attr = data.getRoot().createAttribute(field.getName());
            metaData = attr.getMetaData();
            metaData.defaults();
            metaData.setLabel(String.valueOf(field.getLabel()) + ":");
            metaData.setKind("task.common.kind.default");
            metaData.setReadOnly(false);
            metaData.putValue("tracKey", field.getName());
            if (field.getType() == TracTicketField.Type.CHECKBOX) {
                metaData.setType("boolean");
                attr.putOption("1", "1");
                attr.putOption("0", "0");
                if (field.getDefaultValue() != null) {
                    attr.setValue(field.getDefaultValue());
                }
            } else if (field.getType() == TracTicketField.Type.SELECT || field.getType() == TracTicketField.Type.RADIO) {
                metaData.setType("singleSelect");
                values = field.getOptions();
                if (values != null && values.length > 0) {
                    if (field.isOptional()) {
                        attr.putOption("", "");
                    }
                    var8_5 = values;
                    var7_6 = values.length;
                    var6_7 = 0;
                    while (var6_7 < var7_6) {
                        value = var8_5[var6_7];
                        attr.putOption(value, value);
                        ++var6_7;
                    }
                    if (field.getDefaultValue() != null) {
                        try {
                            index = Integer.parseInt(field.getDefaultValue());
                            if (index > 0 && index < values.length) {
                                attr.setValue(values[index]);
                            }
                            break block19;
                        }
                        catch (NumberFormatException v0) {
                            var8_5 = values;
                            var7_6 = values.length;
                            var6_7 = 0;
                            ** while (var6_7 < var7_6)
                        }
lbl-1000:
                        // 1 sources

                        {
                            value = var8_5[var6_7];
                            if (field.getDefaultValue().equals(value.toString())) {
                                attr.setValue(value);
                            } else {
                                ++var6_7;
                                continue;
                            }
lbl53:
                            // 1 sources

                        }
                    }
                }
            } else if (field.getType() == TracTicketField.Type.TEXTAREA) {
                metaData.setType("longText");
                if (field.getDefaultValue() != null) {
                    attr.setValue(field.getDefaultValue());
                }
            } else {
                metaData.setType("shortText");
                if (field.getDefaultValue() != null) {
                    attr.setValue(field.getDefaultValue());
                }
            }
        }
        return attr;
    }

    public static TaskAttribute createAttribute(TaskData data, TracAttribute tracAttribute) {
        TaskAttribute attr = data.getRoot().createAttribute(tracAttribute.getTracKey());
        TaskAttributeMetaData metaData = attr.getMetaData();
        metaData.setType(tracAttribute.getType());
        metaData.setKind(tracAttribute.getKind());
        metaData.setLabel(tracAttribute.toString());
        metaData.setReadOnly(tracAttribute.isReadOnly());
        metaData.putValue(TRAC_KEY, tracAttribute.getTracKey());
        return attr;
    }

    private static TaskAttribute createAttribute(TaskData data, TracAttribute tracAttribute, Object[] values, boolean allowEmpty) {
        TaskAttribute attr = TracTaskDataHandler.createAttribute(data, tracAttribute);
        if (values != null && values.length > 0) {
            if (allowEmpty) {
                attr.putOption("", "");
            }
            Object[] objectArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                Object value = objectArray[n2];
                attr.putOption(value.toString(), value.toString());
                ++n2;
            }
        } else {
            attr.getMetaData().setReadOnly(true);
        }
        return attr;
    }

    private static TaskAttribute createAttribute(TaskData data, TracAttribute tracAttribute, Object[] values) {
        return TracTaskDataHandler.createAttribute(data, tracAttribute, values, false);
    }

    public RepositoryResponse postTaskData(TaskRepository repository, TaskData taskData, Set<TaskAttribute> oldAttributes, IProgressMonitor monitor) throws CoreException {
        try {
            TracTicket ticket = TracTaskDataHandler.getTracTicket(repository, taskData);
            ITracClient server = this.connector.getClientManager().getTracClient(repository);
            if (taskData.isNew()) {
                int id = server.createTicket(ticket, monitor);
                return new RepositoryResponse(RepositoryResponse.ResponseKind.TASK_CREATED, String.valueOf(id));
            }
            String newComment = "";
            TaskAttribute newCommentAttribute = taskData.getRoot().getMappedAttribute("task.common.comment.new");
            if (newCommentAttribute != null) {
                newComment = newCommentAttribute.getValue();
            }
            server.updateTicket(ticket, newComment, monitor);
            return new RepositoryResponse(RepositoryResponse.ResponseKind.TASK_UPDATED, String.valueOf(ticket.getId()));
        }
        catch (OperationCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CoreException(TracCorePlugin.toStatus(e, repository));
        }
    }

    public boolean initializeTaskData(TaskRepository repository, TaskData data, ITaskMapping initializationData, IProgressMonitor monitor) throws CoreException {
        try {
            ITracClient client = this.connector.getClientManager().getTracClient(repository);
            client.updateAttributes(monitor, false);
            TracTaskDataHandler.createDefaultAttributes(data, client, false);
            return true;
        }
        catch (OperationCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CoreException(TracCorePlugin.toStatus(e, repository));
        }
    }

    public boolean initializeSubTaskData(TaskRepository repository, TaskData taskData, TaskData parentTaskData, IProgressMonitor monitor) throws CoreException {
        this.initializeTaskData(repository, taskData, null, monitor);
        TaskAttribute blockingAttribute = taskData.getRoot().getMappedAttribute(ATTRIBUTE_BLOCKING);
        if (blockingAttribute == null) {
            throw new CoreException((IStatus)new RepositoryStatus(repository, 4, "org.eclipse.mylyn.trac.core", 1, "The repository does not support subtasks"));
        }
        TaskMapper mapper = new TaskMapper(taskData);
        mapper.merge((ITaskMapping)new TaskMapper(parentTaskData));
        mapper.setDescription("");
        mapper.setSummary("");
        blockingAttribute.setValue(parentTaskData.getTaskId());
        TaskAttribute blockedByAttribute = taskData.getRoot().getMappedAttribute(ATTRIBUTE_BLOCKED_BY);
        if (blockedByAttribute != null) {
            blockedByAttribute.clearValues();
        }
        return true;
    }

    public boolean canInitializeSubTaskData(TaskRepository taskRepository, ITask task) {
        return Boolean.parseBoolean(task.getAttribute("SupportsSubtasks"));
    }

    public TaskAttributeMapper getAttributeMapper(TaskRepository repository) {
        ITracClient client = this.connector.getClientManager().getTracClient(repository);
        return new TracAttributeMapper(repository, client);
    }

    public boolean supportsSubtasks(TaskData taskData) {
        return taskData.getRoot().getAttribute(ATTRIBUTE_BLOCKED_BY) != null;
    }

    public static TracTicket getTracTicket(TaskRepository repository, TaskData data) throws InvalidTicketException, CoreException {
        TracTicket ticket = data.isNew() ? new TracTicket() : new TracTicket(TracRepositoryConnector.getTicketId(data.getTaskId()));
        Collection attributes = data.getRoot().getAttributes().values();
        for (TaskAttribute attribute : attributes) {
            if (TracAttributeMapper.isInternalAttribute(attribute) || attribute.getMetaData().isReadOnly()) continue;
            ticket.putValue(attribute.getId(), attribute.getValue());
        }
        StringBuilder sb = new StringBuilder();
        List<String> removeValues = TracRepositoryConnector.getAttributeValues(data, "task.common.removecc");
        List<String> values = TracRepositoryConnector.getAttributeValues(data, "task.common.user.cc");
        for (String user : values) {
            if (removeValues.contains(user)) continue;
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(user);
        }
        if (TracRepositoryConnector.getAttributeValue(data, "task.common.newcc").length() > 0) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(TracRepositoryConnector.getAttributeValue(data, "task.common.newcc"));
        }
        if (Boolean.TRUE.equals(TracRepositoryConnector.getAttributeValue(data, "task.common.addselfcc"))) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(repository.getUserName());
        }
        ticket.putBuiltinValue(TracTicket.Key.CC, sb.toString());
        ticket.putValue("owner", TracRepositoryConnector.getAttributeValue(data, "task.common.user.assigned"));
        TaskAttribute operationAttribute = data.getRoot().getMappedAttribute("task.common.operation");
        if (operationAttribute != null) {
            TaskOperation operation = TaskOperation.createFrom((TaskAttribute)operationAttribute);
            String action = operation.getOperationId();
            if (!"leave".equals(action)) {
                if ("accept".equals(action)) {
                    ticket.putValue("status", TracRepositoryConnector.TaskStatus.ASSIGNED.toStatusString());
                } else if ("resolve".equals(action)) {
                    ticket.putValue("status", TracRepositoryConnector.TaskStatus.CLOSED.toStatusString());
                    ticket.putValue("resolution", TracRepositoryConnector.getAttributeValue(data, "task.common.resolution"));
                } else if ("reopen".equals(action)) {
                    ticket.putValue("status", TracRepositoryConnector.TaskStatus.REOPENED.toStatusString());
                    ticket.putValue("resolution", "");
                } else if ("reassign".equals(action)) {
                    ticket.putValue("status", TracRepositoryConnector.TaskStatus.NEW.toStatusString());
                }
            }
            ticket.putValue("action", action);
        }
        return ticket;
    }

    public void migrateTaskData(TaskRepository taskRepository, TaskData taskData) {
        int version = 0;
        if (taskData.getVersion() != null) {
            try {
                version = Integer.parseInt(taskData.getVersion());
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (version < 1) {
            TaskAttribute root = taskData.getRoot();
            ArrayList attributes = new ArrayList(root.getAttributes().values());
            for (TaskAttribute attribute : attributes) {
                if ("operation".equals(attribute.getMetaData().getType()) && "reassign".equals(attribute.getValue())) {
                    root.removeAttribute(attribute.getId());
                    continue;
                }
                if ("task.common.operation".equals(attribute.getId())) {
                    attribute.getMetaData().setType("operation");
                    continue;
                }
                if ("task.common.newcc".equals(attribute.getId())) {
                    attribute.getMetaData().setType("shortText").setReadOnly(false);
                    continue;
                }
                TracAttribute tracAttribute = TracAttribute.getByTracKey(attribute.getId());
                if (tracAttribute == null) continue;
                attribute.getMetaData().setType(tracAttribute.getType());
                attribute.getMetaData().setKind(tracAttribute.getKind());
                attribute.getMetaData().setReadOnly(tracAttribute.isReadOnly());
            }
            if (root.getAttribute("task.common.removecc") == null) {
                root.createAttribute("task.common.removecc");
            }
            if (root.getAttribute("task.common.comment.new") == null) {
                root.createAttribute("task.common.comment.new").getMetaData().setType("longRichText").setReadOnly(false);
            }
        }
        if (version < 2) {
            ArrayList attributes = new ArrayList(taskData.getRoot().getAttributes().values());
            for (TaskAttribute attribute : attributes) {
                if (TracAttributeMapper.isInternalAttribute(attribute)) continue;
                TaskAttributeMetaData metaData = attribute.getMetaData();
                metaData.putValue(TRAC_KEY, attribute.getId());
                if (metaData.getType() != null) continue;
                metaData.setType("shortText");
            }
            taskData.setVersion(TASK_DATA_VERSION);
        }
    }
}

