/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.trac.core.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Date;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.mylyn.internal.trac.core.model.TracSearch;
import org.eclipse.mylyn.internal.trac.core.util.Messages;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.RepositoryStatus;

public class TracUtil {
    public static Date parseDate(String time) {
        if (time != null) {
            try {
                return TracUtil.parseDate(Long.valueOf(time));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return null;
    }

    public static Date parseDate(long seconds) {
        return new Date(seconds * 1000L);
    }

    public static long toTracTime(Date date) {
        return date.getTime() / 1000L;
    }

    private static String getQueryParameter(IRepositoryQuery query) {
        String url = query.getUrl();
        int i = url.indexOf("/query?format=tab");
        if (i == -1) {
            return null;
        }
        return url.substring(i + "/query?format=tab".length());
    }

    public static TracSearch toTracSearch(IRepositoryQuery query) {
        String url = TracUtil.getQueryParameter(query);
        if (url != null) {
            TracSearch search = new TracSearch();
            search.fromUrl(url);
            return search;
        }
        return null;
    }

    public static IStatus createPermissionDeniedError(String repositoryUrl, String pluginId) {
        return new RepositoryStatus(repositoryUrl, 4, "org.eclipse.mylyn.trac.core", 12, Messages.TracUtil_Permission_denied);
    }

    public static String encodeUrl(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string;
        }
    }

    public static String toString(Object object) {
        StringBuilder sb = new StringBuilder();
        TracUtil.toString(sb, object);
        return sb.toString();
    }

    public static void toString(StringBuilder sb, Object object) {
        if (object instanceof Object[]) {
            sb.append("[");
            Object[] entries = (Object[])object;
            boolean prependSeparator = false;
            Object[] objectArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                Object entry = objectArray[n2];
                if (prependSeparator) {
                    sb.append(", ");
                }
                TracUtil.toString(sb, entry);
                prependSeparator = true;
                ++n2;
            }
            sb.append("]");
        } else if (object instanceof Map) {
            sb.append("{");
            boolean prependSeparator = false;
            for (Map.Entry entry : ((Map)object).entrySet()) {
                if (prependSeparator) {
                    sb.append(", ");
                }
                TracUtil.toString(sb, entry.getKey());
                sb.append("=");
                TracUtil.toString(sb, entry.getValue());
                prependSeparator = true;
            }
            sb.append("}");
        } else {
            sb.append(object);
        }
    }
}

