/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.sandbox.ui;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.jdt.internal.ui.viewsupport.TreeHierarchyLayoutProblemsDecorator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.context.core.IInteractionRelation;
import org.eclipse.mylyn.internal.context.ui.ContextUiImages;
import org.eclipse.mylyn.internal.java.ui.JavaUiBridgePlugin;
import org.eclipse.mylyn.internal.sandbox.ui.DelegatingContextLabelProvider;
import org.eclipse.swt.graphics.Image;

public class JavaContextLabelProvider
extends AppearanceAwareLabelProvider {
    private static final String LABEL_ELEMENT_MISSING = "<missing element>";
    private static final ImageDescriptor EDGE_REF_JUNIT = JavaUiBridgePlugin.getImageDescriptor((String)"icons/elcl16/edge-ref-junit.gif");

    public JavaContextLabelProvider() {
        super(36421324767273L, 3);
    }

    public String getText(Object object) {
        if (object instanceof IInteractionElement) {
            IInteractionElement node = (IInteractionElement)object;
            if ("java".equals(node.getContentType())) {
                IJavaElement element = JavaCore.create((String)node.getHandleIdentifier());
                if (element == null) {
                    return LABEL_ELEMENT_MISSING;
                }
                return this.getTextForElement(element);
            }
        } else {
            if (object instanceof IInteractionRelation) {
                return this.getNameForRelationship(((IInteractionRelation)object).getRelationshipHandle());
            }
            if (object instanceof IJavaElement) {
                return this.getTextForElement((IJavaElement)object);
            }
        }
        return super.getText(object);
    }

    private String getTextForElement(IJavaElement element) {
        String parentName;
        if (DelegatingContextLabelProvider.isQualifyNamesMode() && element instanceof IMember && !(element instanceof IType) && (parentName = ((IMember)element).getParent().getElementName()) != null && parentName != "") {
            return String.valueOf(parentName) + '.' + super.getText((Object)element);
        }
        if (element.exists()) {
            return super.getText((Object)element);
        }
        return LABEL_ELEMENT_MISSING;
    }

    public Image getImage(Object object) {
        if (object instanceof IInteractionElement) {
            IInteractionElement node = (IInteractionElement)object;
            if (node.getContentType().equals("java")) {
                return super.getImage((Object)JavaCore.create((String)node.getHandleIdentifier()));
            }
        } else if (object instanceof IInteractionRelation) {
            ImageDescriptor descriptor = this.getIconForRelationship(((IInteractionRelation)object).getRelationshipHandle());
            if (descriptor != null) {
                return ContextUiImages.getImage((ImageDescriptor)descriptor);
            }
            return null;
        }
        return super.getImage(object);
    }

    private ImageDescriptor getIconForRelationship(String relationshipHandle) {
        if (relationshipHandle.equals("org.eclipse.mylyn.java.relation")) {
            return ContextUiImages.EDGE_REFERENCE;
        }
        if (relationshipHandle.equals("org.eclipse.mylyn.java.relation.references")) {
            return ContextUiImages.EDGE_REFERENCE;
        }
        if (relationshipHandle.equals("org.eclipse.mylyn.java.relation.implementors")) {
            return ContextUiImages.EDGE_INHERITANCE;
        }
        if (relationshipHandle.equals("org.eclipse.mylyn.java.relation.junitreferences")) {
            return EDGE_REF_JUNIT;
        }
        if (relationshipHandle.equals("org.eclipse.mylyn.java.relation.writeaccess")) {
            return ContextUiImages.EDGE_ACCESS_WRITE;
        }
        if (relationshipHandle.equals("org.eclipse.mylyn.java.relation.readaccess")) {
            return ContextUiImages.EDGE_ACCESS_READ;
        }
        return null;
    }

    private String getNameForRelationship(String relationshipHandle) {
        if (relationshipHandle.equals("org.eclipse.mylyn.java.relation")) {
            return "Java relationships";
        }
        if (relationshipHandle.equals("org.eclipse.mylyn.java.relation.references")) {
            return "referenced by";
        }
        if (relationshipHandle.equals("org.eclipse.mylyn.java.relation.implementors")) {
            return "implemented by";
        }
        if (relationshipHandle.equals("org.eclipse.mylyn.java.relation.junitreferences")) {
            return "tested by";
        }
        if (relationshipHandle.equals("org.eclipse.mylyn.java.relation.writeaccess")) {
            return "written by";
        }
        if (relationshipHandle.equals("org.eclipse.mylyn.java.relation.readaccess")) {
            return "read by";
        }
        if (relationshipHandle.equals("org.eclipse.mylyn.core.model.edges.containment")) {
            return "Containment";
        }
        return null;
    }

    public static AppearanceAwareLabelProvider createJavaUiLabelProvider() {
        AppearanceAwareLabelProvider javaUiLabelProvider = new AppearanceAwareLabelProvider(36421324767273L, 3);
        javaUiLabelProvider.addLabelDecorator((ILabelDecorator)new TreeHierarchyLayoutProblemsDecorator());
        return javaUiLabelProvider;
    }
}

