/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.web.tasks;

import java.util.ArrayList;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalListener;
import org.eclipse.jface.fieldassist.IContentProposalListener2;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.mylyn.internal.web.tasks.ParametersEditor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebContentProposalProvider
implements IContentProposalProvider {
    private final ParametersEditor parametersEditor;
    private final boolean includeTemplates;

    public WebContentProposalProvider(ParametersEditor parametersEditor, boolean includeTemplates) {
        this.parametersEditor = parametersEditor;
        this.includeTemplates = includeTemplates;
    }

    public IContentProposal[] getProposals(String contents, int position) {
        ArrayList<IContentProposal> proposals = new ArrayList<IContentProposal>();
        if (this.includeTemplates) {
            this.addProposal(proposals, "({Id}.+?)");
            this.addProposal(proposals, "({Description}.+?)");
            this.addProposal(proposals, "({Owner}.+?)");
            this.addProposal(proposals, "({Type}.+?)");
            this.addProposal(proposals, "({Status}.+?)");
            this.addProposal(proposals, "(.+?)");
            this.addProposal(proposals, ".+?");
        }
        this.addProposal(proposals, "${serverUrl}");
        this.addProposal(proposals, "${userId}");
        this.addProposal(proposals, "${password}");
        this.addProposal(proposals, "${loginToken}");
        for (String param : this.parametersEditor.getParameters().keySet()) {
            this.addProposal(proposals, "${" + param.substring("param_".length()) + "}");
        }
        this.addProposal(proposals, "${}");
        return proposals.toArray(new IContentProposal[proposals.size()]);
    }

    private boolean addProposal(ArrayList<IContentProposal> proposals, final String content) {
        return proposals.add(new IContentProposal(){

            public String getContent() {
                return content;
            }

            public int getCursorPosition() {
                return content.length();
            }

            public String getDescription() {
                return null;
            }

            public String getLabel() {
                return null;
            }
        });
    }

    public static ControlDecoration createDecoration(Text text, ParametersEditor parametersEditor, boolean includeTemplates) {
        FieldDecorationRegistry registry = FieldDecorationRegistry.getDefault();
        FieldDecoration fieldDecoration = registry.getFieldDecoration("DEC_CONTENT_PROPOSAL");
        ControlDecoration decoration = new ControlDecoration((Control)text, 16512);
        decoration.setImage(fieldDecoration.getImage());
        decoration.setDescriptionText(fieldDecoration.getDescription());
        decoration.setShowOnlyOnFocus(true);
        KeyStroke keystroke = null;
        try {
            keystroke = KeyStroke.getInstance((String)"Ctrl+Space");
        }
        catch (ParseException parseException) {}
        ContentProposalAdapter adapter = new ContentProposalAdapter((Control)text, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)new WebContentProposalProvider(parametersEditor, includeTemplates), keystroke, null);
        adapter.setPopupSize(new Point(200, 150));
        adapter.setPropagateKeys(true);
        adapter.setFilterStyle(3);
        WebContentProposalListener listener = new WebContentProposalListener(adapter);
        adapter.addContentProposalListener((IContentProposalListener)listener);
        adapter.addContentProposalListener((IContentProposalListener2)listener);
        adapter.setProposalAcceptanceStyle(3);
        return decoration;
    }

    static class WebContentProposalListener
    implements IContentProposalListener,
    IContentProposalListener2 {
        private final ContentProposalAdapter adapter;
        private int startCaretPosition;
        private int endCaretPosition;

        public WebContentProposalListener(ContentProposalAdapter adapter) {
            this.adapter = adapter;
        }

        public void proposalAccepted(IContentProposal proposal) {
            IControlContentAdapter contentAdapter = this.adapter.getControlContentAdapter();
            Control control = this.adapter.getControl();
            StringBuilder sb = new StringBuilder(contentAdapter.getControlContents(control));
            sb.insert(contentAdapter.getCursorPosition(control), proposal.getContent().substring(this.endCaretPosition - this.startCaretPosition));
            contentAdapter.setControlContents(control, sb.toString(), this.startCaretPosition + proposal.getCursorPosition());
        }

        public void proposalPopupOpened(ContentProposalAdapter adapter) {
            this.startCaretPosition = adapter.getControlContentAdapter().getCursorPosition(adapter.getControl());
        }

        public void proposalPopupClosed(ContentProposalAdapter adapter) {
            this.endCaretPosition = adapter.getControlContentAdapter().getCursorPosition(adapter.getControl());
        }
    }
}

