/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.xplanner.ui;

import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.net.Policy;
import org.eclipse.mylyn.internal.xplanner.core.service.XPlannerClient;
import org.eclipse.mylyn.internal.xplanner.ui.Messages;
import org.eclipse.mylyn.internal.xplanner.ui.XPlannerAttributeMapper;
import org.eclipse.mylyn.internal.xplanner.ui.XPlannerClientFacade;
import org.eclipse.mylyn.internal.xplanner.ui.XPlannerRepositoryUtils;
import org.eclipse.mylyn.internal.xplanner.ui.XPlannerTaskDataHandler;
import org.eclipse.mylyn.internal.xplanner.ui.XPlannerTaskListMigrator;
import org.eclipse.mylyn.internal.xplanner.ui.XPlannerUiPlugin;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.TaskRepositoryLocationFactory;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskDataHandler;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataCollector;
import org.eclipse.mylyn.tasks.core.data.TaskMapper;
import org.eclipse.mylyn.tasks.core.data.TaskRelation;
import org.eclipse.mylyn.tasks.core.sync.ISynchronizationSession;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.xplanner.soap.UserStoryData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPlannerRepositoryConnector
extends AbstractRepositoryConnector {
    private final XPlannerTaskDataHandler taskDataHandler;
    public static final String NEW_TASK_DESC = Messages.XPlannerRepositoryConnector_NEW_TASK_DESCRIPTION;
    private final TaskRepositoryLocationFactory taskRepositoryLocationFactory = new TaskRepositoryLocationFactory();

    public XPlannerRepositoryConnector() {
        this.taskDataHandler = new XPlannerTaskDataHandler();
    }

    public String getLabel() {
        return XPlannerUiPlugin.XPLANNER_CLIENT_LABEL;
    }

    public String getConnectorKind() {
        return "xplanner";
    }

    public AbstractTaskDataHandler getTaskDataHandler() {
        return this.taskDataHandler;
    }

    public boolean canCreateTaskFromKey(TaskRepository repository) {
        return true;
    }

    public IStatus performQuery(TaskRepository repository, IRepositoryQuery repositoryQuery, TaskDataCollector resultCollector, ISynchronizationSession event, IProgressMonitor monitor) {
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        monitor.beginTask(Messages.XPlannerRepositoryConnector_RUNNING_QUERY, -1);
        try {
            XPlannerRepositoryUtils.validateRepository(repository);
            XPlannerClient client = XPlannerClientFacade.getDefault().getXPlannerClient(repository);
            if (XPlannerTaskListMigrator.isMyCurrentTasks(repositoryQuery)) {
                IStatus iStatus = this.queryMyCurrentTasks(repositoryQuery, client, repository, resultCollector);
                return iStatus;
            }
            IStatus iStatus = this.queryTasks(repositoryQuery, client, repository, resultCollector);
            return iStatus;
        }
        catch (Exception e) {
            String reason = e.getLocalizedMessage();
            if (reason == null || reason.length() == 0) {
                reason = e.getClass().getName();
            }
            Status status = new Status(4, "org.eclipse.mylyn.xplanner.ui", MessageFormat.format(Messages.XPlannerRepositoryConnector_PerformQueryFailure, reason), (Throwable)e);
            return status;
        }
        finally {
            monitor.done();
        }
    }

    public boolean canCreateNewTask(TaskRepository repository) {
        return true;
    }

    private IStatus queryMyCurrentTasks(IRepositoryQuery repositoryQuery, XPlannerClient client, TaskRepository repository, TaskDataCollector resultCollector) throws RemoteException {
        ArrayList<org.xplanner.soap.TaskData> xplannerTasks = new ArrayList<org.xplanner.soap.TaskData>();
        int currentPersonId = client.getCurrentPersonId();
        xplannerTasks.addAll(Arrays.asList(client.getCurrentTasksForPerson(currentPersonId)));
        xplannerTasks.addAll(Arrays.asList(client.getPlannedTasksForPerson(currentPersonId)));
        return this.getTaskQueryHits(xplannerTasks, repository, repositoryQuery, resultCollector);
    }

    private IStatus queryTasks(IRepositoryQuery repositoryQuery, XPlannerClient client, TaskRepository repository, TaskDataCollector resultCollector) throws RemoteException {
        List<Integer> contentIds = XPlannerTaskListMigrator.getContentIds(repositoryQuery);
        ArrayList<org.xplanner.soap.TaskData> xplannerTasks = new ArrayList<org.xplanner.soap.TaskData>();
        XPlannerTaskListMigrator.ContentIdType contentIdType = XPlannerTaskListMigrator.getContentIdType(repositoryQuery);
        for (Integer contentId : contentIds) {
            this.addTasks(contentId, contentIdType, xplannerTasks, repositoryQuery, client);
        }
        return this.getTaskQueryHits(xplannerTasks, repository, repositoryQuery, resultCollector);
    }

    private void addTasks(int contentId, XPlannerTaskListMigrator.ContentIdType contentIdType, List<org.xplanner.soap.TaskData> xplannerTasks, IRepositoryQuery repositoryQuery, XPlannerClient client) throws RemoteException {
        if (contentId == -1) {
            return;
        }
        if (contentIdType == XPlannerTaskListMigrator.ContentIdType.PROJECT) {
            UserStoryData[] userStories;
            UserStoryData[] userStoryDataArray = userStories = client.getUserStoriesForProject(contentId);
            int n = userStories.length;
            int n2 = 0;
            while (n2 < n) {
                UserStoryData userStory = userStoryDataArray[n2];
                this.addUserStoryTasks(repositoryQuery, userStory.getId(), xplannerTasks, client);
                ++n2;
            }
        } else if (contentIdType == XPlannerTaskListMigrator.ContentIdType.ITERATION) {
            UserStoryData[] userStories;
            UserStoryData[] userStoryDataArray = userStories = client.getUserStories(contentId);
            int n = userStories.length;
            int n3 = 0;
            while (n3 < n) {
                UserStoryData userStory = userStoryDataArray[n3];
                this.addUserStoryTasks(repositoryQuery, userStory.getId(), xplannerTasks, client);
                ++n3;
            }
        } else if (contentIdType == XPlannerTaskListMigrator.ContentIdType.USER_STORY) {
            this.addUserStoryTasks(repositoryQuery, contentId, xplannerTasks, client);
        }
    }

    private void addUserStoryTasks(IRepositoryQuery repositoryQuery, int userStoryId, List<org.xplanner.soap.TaskData> xplannerTasks, XPlannerClient client) throws RemoteException {
        int personId = XPlannerTaskListMigrator.getPersonId(repositoryQuery);
        if (personId != -1) {
            xplannerTasks.addAll(Arrays.asList(client.getUserStoryTasksForPerson(personId, userStoryId)));
        } else {
            xplannerTasks.addAll(Arrays.asList(client.getTasks(userStoryId)));
        }
    }

    private IStatus getTaskQueryHits(List<org.xplanner.soap.TaskData> tasks, TaskRepository repository, IRepositoryQuery repositoryQuery, TaskDataCollector resultCollector) {
        for (org.xplanner.soap.TaskData data : tasks) {
            try {
                TaskData repositoryTaskData = XPlannerRepositoryUtils.createRepositoryTaskData(repository, String.valueOf(data.getId()));
                repositoryTaskData.setPartial(true);
                XPlannerRepositoryUtils.setAttributeValue(repositoryTaskData, "task.common.summary", data.getName());
                resultCollector.accept(repositoryTaskData);
            }
            catch (CoreException e) {
                XPlannerUiPlugin.log(e, "", false);
            }
        }
        return Status.OK_STATUS;
    }

    public TaskData getTaskData(TaskRepository repository, String taskId, IProgressMonitor monitor) throws CoreException {
        return XPlannerRepositoryUtils.createRepositoryTaskData(repository, taskId);
    }

    public void updateTaskFromTaskData(TaskRepository repository, ITask task, TaskData repositoryTaskData) {
        TaskMapper mapper = this.getTaskMapping(repositoryTaskData);
        mapper.applyTo(task);
        String url = String.valueOf(repository.getRepositoryUrl()) + "/do/view/task?oid=" + repositoryTaskData.getTaskId();
        task.setUrl(url);
        if (!repositoryTaskData.isPartial()) {
            task.setAttribute("LastUpdate", XPlannerRepositoryUtils.getAttributeValue(repositoryTaskData, "task.common.date.modified"));
        }
    }

    public TaskMapper getTaskMapping(final TaskData repositoryTaskData) {
        return new TaskMapper(repositoryTaskData){

            public String getSummary() {
                return XPlannerRepositoryUtils.getAttributeValue(repositoryTaskData, "task.common.summary");
            }

            public String getOwner() {
                return XPlannerRepositoryUtils.getAttributeValue(repositoryTaskData, "task.common.user.assigned");
            }

            public String getTaskKind() {
                String taskValue = XPlannerRepositoryUtils.getAttributeValue(repositoryTaskData, "task.common.kind");
                if (taskValue == null || taskValue.length() == 0 || taskValue.equals("task")) {
                    taskValue = XPlannerAttributeMapper.XPlannerTaskKind.TASK.toString();
                }
                return taskValue;
            }

            public Date getCompletionDate() {
                Date completionDate = null;
                if (XPlannerRepositoryUtils.isCompleted(repositoryTaskData)) {
                    try {
                        String lastModificationDateValue = XPlannerRepositoryUtils.getAttributeValue(repositoryTaskData, "task.common.date.completed");
                        if (lastModificationDateValue != null) {
                            SimpleDateFormat timeDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                            completionDate = timeDateFormat.parse(lastModificationDateValue);
                        }
                    }
                    catch (ParseException parseException) {
                        StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.xplanner.ui", Messages.XPlannerRepositoryConnector_COULD_NOT_CONVERT_TASK_DATE));
                    }
                }
                return completionDate;
            }

            public void setCompletionDate(Date dateCompleted) {
            }

            public void setProduct(String product) {
            }

            public Date getModificationDate() {
                Date modificationDate = null;
                try {
                    String modificationDateValue = XPlannerRepositoryUtils.getAttributeValue(repositoryTaskData, "task.common.date.modified");
                    if (modificationDateValue != null) {
                        SimpleDateFormat timeDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        modificationDate = timeDateFormat.parse(modificationDateValue);
                    }
                }
                catch (ParseException parseException) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.xplanner.ui", Messages.XPlannerRepositoryConnector_COULD_NOT_CONVERT_TASK_DATE));
                }
                return modificationDate;
            }
        };
    }

    public String getRepositoryUrlFromTaskUrl(String url) {
        if (url == null) {
            return null;
        }
        int index = url.indexOf("/do/view/");
        if (index != -1) {
            return url.substring(0, index);
        }
        return null;
    }

    public String toString() {
        return this.getLabel();
    }

    public void updateRepositoryConfiguration(TaskRepository repository, IProgressMonitor monitor) throws CoreException {
        XPlannerClientFacade.getDefault().refreshClientSettings(repository);
    }

    public String getTaskUrl(String repositoryUrl, String taskId) {
        String taskUrl = null;
        TaskRepository repository = TasksUi.getRepositoryManager().getRepository("xplanner", repositoryUrl);
        try {
            XPlannerClient client = XPlannerClientFacade.getDefault().getXPlannerClient(repository);
            if (client != null) {
                org.xplanner.soap.TaskData taskData = client.getTask(Integer.valueOf(taskId).intValue());
                if (taskData != null) {
                    if (taskData.getId() > 0) {
                        taskUrl = String.valueOf(repositoryUrl) + "/do/view/task?oid=" + taskData.getId();
                    }
                } else {
                    UserStoryData userStory = client.getUserStory(Integer.valueOf(taskId).intValue());
                    if (userStory != null) {
                        taskUrl = String.valueOf(repositoryUrl) + "/do/view/userstory?oid=" + userStory.getId();
                    }
                }
            }
        }
        catch (Exception e) {
            XPlannerUiPlugin.log(e, "", false);
        }
        return taskUrl;
    }

    public String getTaskIdFromTaskUrl(String url) {
        String taskId = null;
        if (url == null) {
            return null;
        }
        int index = url.indexOf("?oid=");
        if (index != -1) {
            taskId = url.substring(index + "?oid=".length());
        }
        return taskId;
    }

    public Set<ITask> getChangedSinceLastSync(TaskRepository repository, Set<ITask> tasks) throws CoreException {
        XPlannerClient client = XPlannerClientFacade.getDefault().getXPlannerClient(repository);
        if (client == null) {
            return Collections.emptySet();
        }
        HashSet<ITask> changedTasks = new HashSet<ITask>();
        SimpleDateFormat timeDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            XPlannerRepositoryUtils.validateRepository(repository);
            for (ITask task : tasks) {
                org.xplanner.soap.TaskData taskData;
                if (!task.getConnectorKind().equals("xplanner") || (taskData = client.getTask(Integer.valueOf(task.getTaskId()).intValue())) == null) continue;
                Date lastUpdateTime = taskData.getLastUpdateTime().getTime();
                String lastSynchStamp = repository.getSynchronizationTimeStamp();
                Date lastSynchTime = null;
                if (lastSynchStamp != null && lastSynchStamp.length() > 0) {
                    lastSynchTime = timeDateFormat.parse(lastSynchStamp);
                }
                if (lastSynchTime != null && !lastUpdateTime.after(lastSynchTime)) continue;
                changedTasks.add(task);
            }
        }
        catch (CoreException ce) {
            throw ce;
        }
        catch (Exception e) {
            StatusHandler.fail((IStatus)new Status(4, "org.eclipse.mylyn.xplanner.ui", e.getMessage()));
        }
        return changedTasks;
    }

    public void preSynchronization(ISynchronizationSession session, IProgressMonitor monitor) throws CoreException {
        boolean changed = false;
        TaskRepository repository = session.getTaskRepository();
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        try {
            monitor.beginTask(Messages.XPlannerRepositoryConnector_GETTING_CHANGED_TASKS, -1);
            if (repository.getSynchronizationTimeStamp() == null) {
                for (ITask task : session.getTasks()) {
                    session.markStale(task);
                }
                changed = true;
            } else {
                Set<ITask> changedTasks = this.getChangedSinceLastSync(repository, session.getTasks());
                for (ITask changedTask : changedTasks) {
                    session.markStale(changedTask);
                }
                changed = changedTasks.size() > 0;
            }
        }
        finally {
            monitor.done();
        }
        session.setNeedsPerformQueries(changed);
    }

    public void postSynchronization(ISynchronizationSession event, IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask("", 1);
            if (event.isFullSynchronization() && event.getStatus() == null) {
                event.getTaskRepository().setSynchronizationTimeStamp(this.getSynchronizationTimestamp(event));
            }
        }
        finally {
            monitor.done();
        }
    }

    private String getSynchronizationTimestamp(ISynchronizationSession event) throws CoreException {
        SimpleDateFormat timeDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date mostRecent = null;
        String mostRecentTimeStamp = event.getTaskRepository().getSynchronizationTimeStamp();
        if (mostRecentTimeStamp != null) {
            try {
                mostRecent = timeDateFormat.parse(mostRecentTimeStamp);
            }
            catch (ParseException parseException) {}
        }
        for (ITask task : event.getChangedTasks()) {
            Date taskModifiedDate = task.getModificationDate();
            if (taskModifiedDate == null || mostRecent != null && !taskModifiedDate.after(mostRecent)) continue;
            mostRecent = taskModifiedDate;
            mostRecentTimeStamp = timeDateFormat.format(mostRecent);
        }
        return mostRecentTimeStamp;
    }

    public TaskRepositoryLocationFactory getTaskRepositoryLocationFactory() {
        return this.taskRepositoryLocationFactory;
    }

    public boolean hasTaskChanged(TaskRepository taskRepository, ITask task, TaskData repositoryTaskData) {
        TaskMapper scheme = this.getTaskMapping(repositoryTaskData);
        if (repositoryTaskData.isPartial()) {
            Date repositoryDate = scheme.getModificationDate();
            Date localDate = task.getModificationDate();
            return repositoryDate == null || !repositoryDate.equals(localDate);
        }
        Date repositoryDate = scheme.getModificationDate();
        Date localDate = null;
        String updateDateString = task.getAttribute("LastUpdate");
        if (updateDateString != null) {
            try {
                SimpleDateFormat timeDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                localDate = timeDateFormat.parse(updateDateString);
            }
            catch (ParseException parseException) {}
        }
        return repositoryDate == null || !repositoryDate.equals(localDate);
    }

    public Collection<TaskRelation> getTaskRelations(TaskData repositoryTaskData) {
        ArrayList<TaskRelation> relations = new ArrayList<TaskRelation>();
        TaskAttribute attribute = repositoryTaskData.getRoot().getAttribute(XPlannerAttributeMapper.Attribute.SUBTASK_IDS.getCommonAttributeKey());
        if (attribute != null) {
            for (String taskId : attribute.getValues()) {
                relations.add(TaskRelation.subtask((String)taskId));
            }
        }
        return relations;
    }
}

