/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.xplanner.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.mylyn.internal.xplanner.ui.XPlannerAttributeMapper;
import org.eclipse.mylyn.internal.xplanner.ui.XPlannerImages;
import org.eclipse.mylyn.internal.xplanner.ui.XPlannerUiPlugin;
import org.eclipse.mylyn.internal.xplanner.ui.wizard.EditXPlannerQueryWizard;
import org.eclipse.mylyn.internal.xplanner.ui.wizard.Messages;
import org.eclipse.mylyn.internal.xplanner.ui.wizard.NewXPlannerQueryWizard;
import org.eclipse.mylyn.internal.xplanner.ui.wizard.NewXPlannerTaskWizard;
import org.eclipse.mylyn.internal.xplanner.ui.wizard.XPlannerCustomQueryPage;
import org.eclipse.mylyn.internal.xplanner.ui.wizard.XPlannerRepositorySettingsPage;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.LegendElement;
import org.eclipse.mylyn.tasks.ui.TaskHyperlink;
import org.eclipse.mylyn.tasks.ui.wizards.ITaskRepositoryPage;
import org.eclipse.mylyn.tasks.ui.wizards.ITaskSearchPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPlannerRepositoryUi
extends AbstractRepositoryConnectorUi {
    private static final String regexp = "(task|story):(\\d+)";
    private static final Pattern PATTERN = Pattern.compile("(task|story):(\\d+)", 2);
    private static final int DOMAIN_ID_GROUP = 2;

    public ITaskRepositoryPage getSettingsPage(TaskRepository taskRepository) {
        return new XPlannerRepositorySettingsPage(taskRepository);
    }

    public ImageDescriptor getTaskKindOverlay(ITask task) {
        XPlannerAttributeMapper.XPlannerTaskKind kind = XPlannerAttributeMapper.XPlannerTaskKind.fromString(task.getTaskKind());
        ImageDescriptor overlayImage = kind.equals((Object)XPlannerAttributeMapper.XPlannerTaskKind.TASK) ? XPlannerImages.OVERLAY_TASK : (kind.equals((Object)XPlannerAttributeMapper.XPlannerTaskKind.USER_STORY) ? XPlannerImages.OVERLAY_USER_STORY : super.getTaskKindOverlay(task));
        return overlayImage;
    }

    public ITaskSearchPage getSearchPage(TaskRepository repository, IStructuredSelection selection) {
        try {
            return new XPlannerCustomQueryPage(repository, null);
        }
        catch (RuntimeException e) {
            XPlannerUiPlugin.log(e.getCause(), Messages.XPlannerQueryWizardUtils_COULD_NOT_CREATE_QUERY_PAGE_MESSAGE, true);
            return null;
        }
    }

    public IWizard getQueryWizard(TaskRepository repository, IRepositoryQuery query) {
        Object queryWizard = null;
        queryWizard = query != null ? new EditXPlannerQueryWizard(repository, query) : new NewXPlannerQueryWizard(repository);
        return queryWizard;
    }

    public IWizard getNewTaskWizard(TaskRepository taskRepository, ITaskMapping taskSelection) {
        return new NewXPlannerTaskWizard(taskRepository, taskSelection);
    }

    public String getConnectorKind() {
        return "xplanner";
    }

    public boolean hasSearchPage() {
        return true;
    }

    public String getTaskKindLabel(ITask repositoryTask) {
        return repositoryTask == null ? super.getTaskKindLabel(repositoryTask) : repositoryTask.getTaskKind();
    }

    public List<LegendElement> getLegendElements() {
        ArrayList<LegendElement> legendElements = new ArrayList<LegendElement>();
        legendElements.add(LegendElement.createTask((String)Messages.XPlannerRepositoryUi_TASK, (ImageDescriptor)XPlannerImages.OVERLAY_TASK));
        legendElements.add(LegendElement.createTask((String)Messages.XPlannerRepositoryUi_USER_STORY, (ImageDescriptor)XPlannerImages.OVERLAY_USER_STORY));
        return legendElements;
    }

    public IHyperlink[] findHyperlinks(TaskRepository repository, String text, int index, int textOffset) {
        ArrayList<IHyperlink> hyperlinksFound = null;
        Matcher m = PATTERN.matcher(text);
        while (m.find()) {
            IHyperlink link;
            if (index != -1 && (index < m.start() || index > m.end()) || (link = this.extractHyperlink(repository, textOffset, m)) == null) continue;
            if (hyperlinksFound == null) {
                hyperlinksFound = new ArrayList<IHyperlink>();
            }
            hyperlinksFound.add(link);
        }
        return hyperlinksFound != null ? hyperlinksFound.toArray(new IHyperlink[0]) : null;
    }

    private IHyperlink extractHyperlink(TaskRepository repository, int regionOffset, Matcher m) {
        int start = m.start();
        int end = m.end();
        if (end == -1) {
            end = m.group().length();
        }
        try {
            String domainId = m.group(2).trim();
            Region sregion = new Region(start += regionOffset, (end += regionOffset) - start);
            return new TaskHyperlink((IRegion)sregion, repository, domainId);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }
}

