/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import java.util.Collections;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.DateRange;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityUtil;
import org.eclipse.mylyn.internal.tasks.ui.ScheduleTaskMenuContributor;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.actions.Messages;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;

public class TaskEditorScheduleAction
extends Action
implements IMenuCreator {
    private final ITask task;
    private MenuManager menuManager;
    private final ScheduleTaskMenuContributor scheduleMenuContributor = new ScheduleTaskMenuContributor();

    public TaskEditorScheduleAction(ITask task) {
        this.task = task;
        this.setImageDescriptor(CommonImages.SCHEDULE_DAY);
        this.setMenuCreator(this);
        this.setToolTipText(Messages.TaskEditorScheduleAction_Private_Scheduling);
    }

    public void run() {
        TasksUiPlugin.getTaskActivityManager().setScheduledFor((AbstractTask)this.task, (DateRange)TaskActivityUtil.getCurrentWeek().getToday());
    }

    public Menu getMenu(Control parent) {
        if (this.menuManager != null) {
            this.menuManager.dispose();
        }
        this.menuManager = this.scheduleMenuContributor.getSubMenuManager(Collections.singletonList(this.task));
        this.menuManager.createContextMenu(parent);
        return this.menuManager.getMenu();
    }

    public Menu getMenu(Menu parent) {
        if (this.menuManager != null) {
            return this.menuManager.getMenu();
        }
        return null;
    }

    public void dispose() {
        if (this.menuManager != null) {
            this.menuManager.dispose();
        }
    }
}

