/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.bindings.keys.KeyLookupFactory;
import org.eclipse.mylyn.internal.tasks.ui.workingsets.TaskWorkingSetUpdater;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IWorkingSet;

public class ToggleWorkingSetAction
extends Action {
    private final IWorkingSet workingSet;

    public ToggleWorkingSetAction(IWorkingSet set) {
        super(set.getLabel(), 2);
        this.setImageDescriptor(set.getImageDescriptor());
        this.workingSet = set;
        this.setChecked(TaskWorkingSetUpdater.isWorkingSetEnabled(set));
    }

    public void run() {
        this.runWithEvent(null);
    }

    public void runWithEvent(Event event) {
        HashSet<IWorkingSet> newList = new HashSet<IWorkingSet>((Collection)Arrays.asList(TaskWorkingSetUpdater.getEnabledSets()));
        boolean modified = false;
        if (event != null) {
            boolean bl = modified = (event.stateMask & KeyLookupFactory.getDefault().formalModifierLookup("M1")) != 0;
        }
        if (!modified) {
            HashSet<IWorkingSet> tempList = new HashSet<IWorkingSet>();
            for (IWorkingSet workingSet : newList) {
                if (workingSet == null || workingSet.getId() == null || !workingSet.getId().equalsIgnoreCase(TaskWorkingSetUpdater.ID_TASK_WORKING_SET)) continue;
                tempList.add(workingSet);
            }
            newList.removeAll(tempList);
            if (this.isChecked()) {
                newList.add(this.workingSet);
            } else if (!TaskWorkingSetUpdater.isOnlyTaskWorkingSetEnabled(this.workingSet)) {
                newList.add(this.workingSet);
            }
        } else if (this.isChecked()) {
            newList.add(this.workingSet);
        } else {
            newList.remove(this.workingSet);
        }
        TaskWorkingSetUpdater.applyWorkingSetsToAllWindows(newList);
    }
}

