/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.AbstractTaskHyperlinkDetector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskHyperlinkDetector
extends AbstractTaskHyperlinkDetector {
    @Override
    protected List<IHyperlink> detectHyperlinks(ITextViewer textViewer, final String content, final int index, final int contentOffset) {
        ArrayList result = null;
        for (final TaskRepository repository : this.getTaskRepositories(textViewer)) {
            final AbstractRepositoryConnectorUi connectorUi = this.getConnectorUi(repository);
            if (connectorUi == null) continue;
            final IHyperlink[][] links = new IHyperlink[1][];
            SafeRunnable.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    links[0] = connectorUi.findHyperlinks(repository, content, index, contentOffset);
                }
            });
            if (links[0] == null || links[0].length <= 0) continue;
            if (result == null) {
                result = new ArrayList();
            }
            result.addAll(Arrays.asList(links[0]));
        }
        return result;
    }

    protected AbstractRepositoryConnectorUi getConnectorUi(TaskRepository repository) {
        return TasksUiPlugin.getConnectorUi(repository.getConnectorKind());
    }
}

