/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.provisional.tasks.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.mylyn.internal.provisional.tasks.ui.wizards.Messages;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.wizards.AbstractRepositoryQueryPage;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public abstract class AbstractRepositoryQueryPage2
extends AbstractRepositoryQueryPage {
    private Text titleText;
    private Button updateButton;
    private boolean firstTime = true;
    private final AbstractRepositoryConnector connector = TasksUi.getRepositoryConnector(this.getTaskRepository().getConnectorKind());
    private boolean needsRepositoryConfiguration = true;

    public AbstractRepositoryQueryPage2(String pageName, TaskRepository repository, IRepositoryQuery query) {
        super(pageName, repository, query);
        this.setTitle(Messages.AbstractRepositoryQueryPage2_Enter_query_parameters);
        this.setDescription(Messages.AbstractRepositoryQueryPage2_If_attributes_are_blank_or_stale_press_the_Update_button);
    }

    public void setNeedsRepositoryConfiguration(boolean needsRepositoryConfiguration) {
        this.needsRepositoryConfiguration = needsRepositoryConfiguration;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)composite);
        GridLayout layout = new GridLayout(2, false);
        if (this.inSearchContainer()) {
            layout.marginWidth = 0;
            layout.marginHeight = 0;
        }
        composite.setLayout((Layout)layout);
        this.createTitleGroup(composite);
        Composite innerComposite = new Composite(composite, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).span(2, 1).applyTo((Control)innerComposite);
        innerComposite.setLayout((Layout)new FillLayout());
        this.createPageContent(innerComposite);
        if (this.needsRepositoryConfiguration) {
            this.createUpdateButton(composite);
        }
        if (this.getQuery() != null) {
            this.titleText.setText(this.getQuery().getSummary());
            this.restoreState(this.getQuery());
        }
        Dialog.applyDialogFont((Control)composite);
        this.setControl((Control)composite);
    }

    protected abstract void createPageContent(Composite var1);

    private void createTitleGroup(Composite control) {
        if (this.inSearchContainer()) {
            return;
        }
        Label titleLabel = new Label(control, 0);
        titleLabel.setText(Messages.AbstractRepositoryQueryPage2__Title_);
        this.titleText = new Text(control, 2048);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)this.titleText);
        this.titleText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                AbstractRepositoryQueryPage2.this.getContainer().updateButtons();
            }
        });
    }

    private Control createUpdateButton(Composite control) {
        Composite composite = new Composite(control, 0);
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).span(2, 1).applyTo((Control)composite);
        this.updateButton = new Button(composite, 8);
        this.updateButton.setText(Messages.AbstractRepositoryQueryPage2__Refresh_From_Repository);
        this.updateButton.setLayoutData((Object)new GridData());
        this.updateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AbstractRepositoryQueryPage2.this.getTaskRepository() != null) {
                    AbstractRepositoryQueryPage2.this.updateAttributesFromRepository(true);
                } else {
                    MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)Messages.AbstractRepositoryQueryPage2_Update_Attributes_Failed, (String)Messages.AbstractRepositoryQueryPage2_No_repository_available_please_add_one_using_the_Task_Repositories_view);
                }
            }
        });
        return composite;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this.getSearchContainer() != null) {
            this.getSearchContainer().setPerformActionEnabled(true);
        }
        if (visible && this.firstTime) {
            this.firstTime = false;
            if (!this.hasRepositoryConfiguration() && this.needsRepositoryConfiguration) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        if (AbstractRepositoryQueryPage2.this.getControl() != null && !AbstractRepositoryQueryPage2.this.getControl().isDisposed()) {
                            AbstractRepositoryQueryPage2.this.initializePage();
                        }
                    }
                });
            } else {
                this.initializePage();
            }
        }
    }

    private void initializePage() {
        boolean restored;
        if (this.needsRepositoryConfiguration) {
            this.updateAttributesFromRepository(false);
        }
        boolean bl = restored = this.getQuery() != null;
        if (this.inSearchContainer()) {
            restored |= this.restoreState(null);
        }
    }

    protected abstract boolean hasRepositoryConfiguration();

    protected AbstractRepositoryConnector getConnector() {
        return this.connector;
    }

    private void updateAttributesFromRepository(boolean force) {
        if (!this.hasRepositoryConfiguration() || force) {
            this.setErrorMessage(null);
            try {
                IRunnableWithProgress runnable = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            AbstractRepositoryQueryPage2.this.connector.updateRepositoryConfiguration(AbstractRepositoryQueryPage2.this.getTaskRepository(), monitor);
                        }
                        catch (CoreException e) {
                            throw new InvocationTargetException(e);
                        }
                        catch (OperationCanceledException operationCanceledException) {
                            throw new InterruptedException();
                        }
                    }
                };
                if (this.getContainer() != null) {
                    this.getContainer().run(true, true, runnable);
                } else if (this.getSearchContainer() != null) {
                    this.getSearchContainer().getRunnableContext().run(true, true, runnable);
                } else {
                    IProgressService service = PlatformUI.getWorkbench().getProgressService();
                    service.busyCursorWhile(runnable);
                }
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof CoreException) {
                    this.setErrorMessage(((CoreException)e.getCause()).getStatus().getMessage());
                } else {
                    this.setErrorMessage(e.getCause().getMessage());
                }
                return;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
        this.doRefresh();
    }

    protected abstract void doRefresh();

    public boolean isPageComplete() {
        if (this.titleText != null && this.titleText.getText().length() > 0) {
            return true;
        }
        this.setMessage(Messages.AbstractRepositoryQueryPage2_Enter_a_title);
        return false;
    }

    public boolean performSearch() {
        if (this.inSearchContainer()) {
            this.saveState();
        }
        return super.performSearch();
    }

    protected abstract boolean restoreState(IRepositoryQuery var1);

    public String getQueryTitle() {
        return this.titleText != null ? this.titleText.getText() : null;
    }

    public void setQueryTitle(String text) {
        if (this.titleText != null) {
            this.titleText.setText(text);
        }
    }
}

