/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonThemes;
import org.eclipse.mylyn.internal.provisional.commons.ui.DelayedRefreshJob;
import org.eclipse.mylyn.internal.provisional.commons.ui.SubstringPatternFilter;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.ITaskListChangeListener;
import org.eclipse.mylyn.internal.tasks.core.ITasksCoreConstants;
import org.eclipse.mylyn.internal.tasks.core.TaskContainerDelta;
import org.eclipse.mylyn.internal.tasks.ui.AbstractTaskListFilter;
import org.eclipse.mylyn.internal.tasks.ui.TaskArchiveFilter;
import org.eclipse.mylyn.internal.tasks.ui.TaskCompletionFilter;
import org.eclipse.mylyn.internal.tasks.ui.TaskPriorityFilter;
import org.eclipse.mylyn.internal.tasks.ui.TaskWorkingSetFilter;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.actions.CollapseAllAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.ExpandAllAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.FilterCompletedTasksAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.GroupSubTasksAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.LinkWithEditorAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.NewTaskAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.OpenTasksUiPreferencesAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.PresentationDropDownSelectionAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.SynchronizeAutomaticallyAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.TaskListSortAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.TaskListViewActionGroup;
import org.eclipse.mylyn.internal.tasks.ui.commands.CollapseAllHandler;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskListChangeAdapter;
import org.eclipse.mylyn.internal.tasks.ui.util.PlatformUtil;
import org.eclipse.mylyn.internal.tasks.ui.util.SortCriterion;
import org.eclipse.mylyn.internal.tasks.ui.util.TaskDragSourceListener;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.internal.tasks.ui.util.TreeWalker;
import org.eclipse.mylyn.internal.tasks.ui.views.AbstractTaskListContentProvider;
import org.eclipse.mylyn.internal.tasks.ui.views.AbstractTaskListPresentation;
import org.eclipse.mylyn.internal.tasks.ui.views.CustomTaskListDecorationDrawer;
import org.eclipse.mylyn.internal.tasks.ui.views.Messages;
import org.eclipse.mylyn.internal.tasks.ui.views.PriorityDropDownAction;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListCellModifier;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListDropAdapter;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListFilteredTree;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListSorter;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListToolTip;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskTableLabelProvider;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskActivationListener;
import org.eclipse.mylyn.tasks.core.ITaskActivityListener;
import org.eclipse.mylyn.tasks.core.ITaskContainer;
import org.eclipse.mylyn.tasks.core.TaskActivationAdapter;
import org.eclipse.mylyn.tasks.core.TaskActivityAdapter;
import org.eclipse.mylyn.tasks.ui.TaskElementLabelProvider;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditorInput;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.RTFTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.DrillDownAdapter;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.themes.IThemeManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskListView
extends ViewPart
implements IPropertyChangeListener,
IShowInTarget {
    public static final int SWT_NO_SCROLL = 16;
    private static final String ID_SEPARATOR_FILTERS = "filters";
    private static final String ID_SEPARATOR_TASKS = "tasks";
    private static final String ID_SEPARATOR_CONTEXT = "context";
    @Deprecated
    public static final String ID = "org.eclipse.mylyn.tasks.ui.views.tasks";
    public static final String LABEL_VIEW = Messages.TaskListView_Task_List;
    @Deprecated
    private static final String MEMENTO_KEY_SORT_DIRECTION = "sortDirection";
    @Deprecated
    private static final String MEMENTO_KEY_SORTER = "sorter";
    @Deprecated
    private static final String MEMENTO_KEY_SORTER2 = "sorter2";
    @Deprecated
    private static final String MEMENTO_KEY_SORT_INDEX = "sortIndex";
    @Deprecated
    private static final String MEMENTO_SORT_INDEX = "org.eclipse.mylyn.tasklist.ui.views.tasklist.sortIndex";
    private static final String MEMENTO_SORTER = "sorter";
    private static final String MEMENTO_LINK_WITH_EDITOR = "linkWithEditor";
    private static final String MEMENTO_PRESENTATION = "presentation";
    private static final String LABEL_NO_TASKS = "no task active";
    private static final int SIZE_MAX_SELECTION_HISTORY = 10;
    static final String[] PRIORITY_LEVELS = new String[]{ITask.PriorityLevel.P1.toString(), ITask.PriorityLevel.P2.toString(), ITask.PriorityLevel.P3.toString(), ITask.PriorityLevel.P4.toString(), ITask.PriorityLevel.P5.toString()};
    public static final String[] PRIORITY_LEVEL_DESCRIPTIONS = new String[]{ITask.PriorityLevel.P1.getDescription(), ITask.PriorityLevel.P2.getDescription(), ITask.PriorityLevel.P3.getDescription(), ITask.PriorityLevel.P4.getDescription(), ITask.PriorityLevel.P5.getDescription()};
    private static List<AbstractTaskListPresentation> presentationsPrimary = new ArrayList<AbstractTaskListPresentation>();
    private static List<AbstractTaskListPresentation> presentationsSecondary = new ArrayList<AbstractTaskListPresentation>();
    private boolean focusedMode;
    private boolean linkWithEditor;
    private final TaskListCellModifier taskListCellModifier = new TaskListCellModifier(this);
    private IThemeManager themeManager;
    private TaskListFilteredTree filteredTree;
    private DrillDownAdapter drillDownAdapter;
    private AbstractTaskContainer drilledIntoCategory;
    private CollapseAllAction collapseAll;
    private ExpandAllAction expandAll;
    private FilterCompletedTasksAction filterCompleteTask;
    private GroupSubTasksAction filterSubTasksAction;
    private SynchronizeAutomaticallyAction synchronizeAutomatically;
    private OpenTasksUiPreferencesAction openPreferencesAction;
    private PriorityDropDownAction filterOnPriorityAction;
    private TaskListSortAction sortDialogAction;
    private NewTaskAction newTaskAction;
    private LinkWithEditorAction linkWithEditorAction;
    private final PresentationDropDownSelectionAction presentationDropDownSelectionAction = new PresentationDropDownSelectionAction(this);
    private final TaskPriorityFilter filterPriority = new TaskPriorityFilter();
    private final TaskCompletionFilter filterComplete = new TaskCompletionFilter();
    private final TaskArchiveFilter filterArchive = new TaskArchiveFilter();
    private TaskWorkingSetFilter filterWorkingSet;
    private final Set<AbstractTaskListFilter> filters = new HashSet<AbstractTaskListFilter>();
    protected String[] columnNames = new String[]{Messages.TaskListView_Summary};
    protected int[] columnWidths = new int[]{200};
    private TreeColumn[] columns;
    private IMemento taskListMemento;
    private AbstractTaskListPresentation currentPresentation;
    private TaskTableLabelProvider taskListTableLabelProvider;
    private TaskListSorter tableSorter;
    private Color categoryGradientStart;
    private Color categoryGradientEnd;
    private CustomTaskListDecorationDrawer customDrawer;
    private TaskListViewActionGroup actionGroup;
    private final IPageListener PAGE_LISTENER = new IPageListener(){

        public void pageActivated(IWorkbenchPage page) {
            TaskListView.this.filteredTree.indicateActiveTaskWorkingSet();
        }

        public void pageClosed(IWorkbenchPage page) {
        }

        public void pageOpened(IWorkbenchPage page) {
        }
    };
    private final LinkedHashMap<String, IStructuredSelection> lastSelectionByTaskHandle = new LinkedHashMap(10);
    protected boolean isPaused = false;
    boolean synchronizationOverlaid = false;
    private final Listener CATEGORY_GRADIENT_DRAWER = new Listener(){

        public void handleEvent(Event event) {
            if (event.item.getData() instanceof ITaskContainer && !(event.item.getData() instanceof ITask)) {
                Scrollable scrollable = (Scrollable)event.widget;
                GC gc = event.gc;
                Rectangle area = scrollable.getClientArea();
                Rectangle rect = event.getBounds();
                this.expandRegion(event, scrollable, gc, area);
                Color oldForeground = gc.getForeground();
                Color oldBackground = gc.getBackground();
                gc.setForeground(TaskListView.this.categoryGradientEnd);
                gc.drawLine(0, rect.y, area.width, rect.y);
                gc.setForeground(TaskListView.this.categoryGradientStart);
                gc.setBackground(TaskListView.this.categoryGradientEnd);
                gc.fillGradientRectangle(0, rect.y + 1, area.width, rect.height, true);
                gc.setForeground(TaskListView.this.categoryGradientEnd);
                gc.drawLine(0, rect.y + rect.height - 1, area.width, rect.y + rect.height - 1);
                gc.setForeground(oldForeground);
                gc.setBackground(oldBackground);
                event.detail &= 0xFFFFFFF7;
            }
        }

        private void expandRegion(Event event, Scrollable scrollable, GC gc, Rectangle area) {
            int width;
            int columnCount = scrollable instanceof Table ? ((Table)scrollable).getColumnCount() : ((Tree)scrollable).getColumnCount();
            if ((event.index == columnCount - 1 || columnCount == 0) && (width = area.x + area.width - event.x) > 0) {
                Region region = new Region();
                gc.getClipping(region);
                region.add(event.x, event.y, width, event.height);
                gc.setClipping(region);
                region.dispose();
            }
        }
    };
    private boolean gradientListenerAdded = false;
    private final ITaskActivityListener TASK_ACTIVITY_LISTENER = new TaskActivityAdapter(){

        public void activityReset() {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    TaskListView.this.refreshJob.refresh();
                }
            });
        }
    };
    private final ITaskActivationListener TASK_ACTIVATION_LISTENER = new TaskActivationAdapter(){

        public void taskActivated(final ITask task) {
            if (task != null) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        TaskListView.this.updateDescription();
                        this.refresh(task);
                        TaskListView.this.selectedAndFocusTask(task);
                        TaskListView.this.filteredTree.indicateActiveTask(task);
                    }
                });
            }
        }

        public void taskDeactivated(final ITask task) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    this.refresh(task);
                    TaskListView.this.updateDescription();
                    TaskListView.this.filteredTree.indicateNoActiveTask();
                }
            });
        }

        private void refresh(ITask task) {
            if (TaskListView.this.isScheduledPresentation()) {
                TaskListView.this.refreshJob.refresh();
            } else {
                TaskListView.this.refreshJob.refreshElement((Object)task);
            }
        }
    };
    private final ITaskListChangeListener TASKLIST_CHANGE_LISTENER = new TaskListChangeAdapter(){

        @Override
        public void containersChanged(final Set<TaskContainerDelta> deltas) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    for (TaskContainerDelta taskContainerDelta : deltas) {
                        if (TaskListView.this.isScheduledPresentation()) {
                            TaskListView.this.refreshJob.refresh();
                            continue;
                        }
                        switch (taskContainerDelta.getKind()) {
                            case ROOT: {
                                TaskListView.this.refreshJob.refresh();
                                break;
                            }
                            case ADDED: 
                            case REMOVED: {
                                if (taskContainerDelta.getElement() != null) {
                                    TaskListView.this.refreshJob.refreshElement((Object)taskContainerDelta.getElement());
                                }
                                if (taskContainerDelta.getParent() != null) {
                                    TaskListView.this.refreshJob.refreshElement((Object)taskContainerDelta.getParent());
                                    break;
                                }
                                TaskListView.this.refreshJob.refresh();
                                break;
                            }
                            case CONTENT: {
                                TaskListView.this.refreshJob.refreshElement((Object)taskContainerDelta.getElement());
                            }
                        }
                    }
                }
            });
        }
    };
    private final IPropertyChangeListener THEME_CHANGE_LISTENER = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("CHANGE_CURRENT_THEME") || CommonThemes.isCommonTheme((String)event.getProperty())) {
                TaskListView.this.configureGradientColors();
                TaskListView.this.taskListTableLabelProvider.setCategoryBackgroundColor(TaskListView.this.themeManager.getCurrentTheme().getColorRegistry().get("org.eclipse.mylyn.tasks.ui.colors.category.gradient.end"));
                TaskListView.this.getViewer().refresh();
            }
        }
    };
    private TaskListToolTip taskListToolTip;
    private final IPartListener editorListener = new IPartListener(){

        private void jumpToEditor(IWorkbenchPart part) {
            if (!TaskListView.this.linkWithEditor || !(part instanceof IEditorPart)) {
                return;
            }
            TaskListView.this.jumpToEditorTask((IEditorPart)part);
        }

        public void partActivated(IWorkbenchPart part) {
            if (part == TaskListView.this) {
                TaskListView.this.updateDescription();
            } else {
                this.jumpToEditor(part);
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
            if (part == TaskListView.this) {
                IViewReference reference = TaskListView.this.getSite().getPage().findViewReference(TaskListView.ID);
                if (reference != null && reference.isFastView()) {
                    TaskListView.this.updateDescription();
                }
                TaskListView.this.taskListToolTip.hide();
            }
        }

        public void partOpened(IWorkbenchPart part) {
        }
    };
    boolean isInRenameAction = false;
    private DelayedRefreshJob refreshJob;
    private boolean itemNotFoundExceptionLogged;

    private void configureGradientColors() {
        this.categoryGradientStart = this.themeManager.getCurrentTheme().getColorRegistry().get("org.eclipse.mylyn.tasks.ui.colors.category.gradient.start");
        this.categoryGradientEnd = this.themeManager.getCurrentTheme().getColorRegistry().get("org.eclipse.mylyn.tasks.ui.colors.category.gradient.end");
        boolean customized = true;
        if (this.categoryGradientStart != null && this.categoryGradientStart.getRed() == 240 && this.categoryGradientStart.getGreen() == 240 && this.categoryGradientStart.getBlue() == 240 && this.categoryGradientEnd != null && this.categoryGradientEnd.getRed() == 220 && this.categoryGradientEnd.getGreen() == 220 && this.categoryGradientEnd.getBlue() == 220) {
            customized = false;
        }
        if (!this.gradientListenerAdded && this.categoryGradientStart != null && !this.categoryGradientStart.equals((Object)this.categoryGradientEnd)) {
            this.getViewer().getTree().addListener(40, this.CATEGORY_GRADIENT_DRAWER);
            this.gradientListenerAdded = true;
            if (!customized) {
                Color parentBackground = this.getViewer().getTree().getParent().getBackground();
                double GRADIENT_TOP = 1.05;
                double GRADIENT_BOTTOM = 0.995;
                int red = Math.min(255, (int)((double)parentBackground.getRed() * GRADIENT_TOP));
                int green = Math.min(255, (int)((double)parentBackground.getGreen() * GRADIENT_TOP));
                int blue = Math.min(255, (int)((double)parentBackground.getBlue() * GRADIENT_TOP));
                try {
                    this.categoryGradientStart = new Color((Device)Display.getDefault(), red, green, blue);
                }
                catch (Exception e) {
                    this.categoryGradientStart = this.getViewer().getTree().getParent().getBackground();
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not set color: " + red + ", " + green + ", " + blue, (Throwable)e));
                }
                red = Math.max(0, (int)((double)parentBackground.getRed() / GRADIENT_BOTTOM));
                green = Math.max(0, (int)((double)parentBackground.getGreen() / GRADIENT_BOTTOM));
                blue = Math.max(0, (int)((double)parentBackground.getBlue() / GRADIENT_BOTTOM));
                if (red > 255) {
                    red = 255;
                }
                try {
                    this.categoryGradientEnd = new Color((Device)Display.getDefault(), red, green, blue);
                }
                catch (Exception e) {
                    this.categoryGradientStart = this.getViewer().getTree().getParent().getBackground();
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not set color: " + red + ", " + green + ", " + blue, (Throwable)e));
                }
            }
        } else if (this.categoryGradientStart != null && this.categoryGradientStart.equals((Object)this.categoryGradientEnd)) {
            this.getViewer().getTree().removeListener(40, this.CATEGORY_GRADIENT_DRAWER);
            this.gradientListenerAdded = false;
        }
    }

    public static TaskListView getFromActivePerspective() {
        IViewPart view;
        IWorkbenchPage activePage;
        IWorkbenchWindow activeWorkbenchWindow;
        if (PlatformUI.isWorkbenchRunning() && (activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null && (activePage = activeWorkbenchWindow.getActivePage()) != null && (view = activePage.findView(ID)) instanceof TaskListView) {
            return (TaskListView)view;
        }
        return null;
    }

    public void dispose() {
        IThemeManager themeManager;
        super.dispose();
        TasksUiInternal.getTaskList().removeChangeListener(this.TASKLIST_CHANGE_LISTENER);
        TasksUiPlugin.getTaskActivityManager().removeActivityListener(this.TASK_ACTIVITY_LISTENER);
        TasksUiPlugin.getTaskActivityManager().removeActivationListener(this.TASK_ACTIVATION_LISTENER);
        PlatformUI.getWorkbench().getWorkingSetManager().removePropertyChangeListener((IPropertyChangeListener)this);
        if (PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null) {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().removePageListener(this.PAGE_LISTENER);
        }
        if ((themeManager = this.getSite().getWorkbenchWindow().getWorkbench().getThemeManager()) != null) {
            themeManager.removePropertyChangeListener(this.THEME_CHANGE_LISTENER);
        }
        if (this.editorListener != null) {
            this.getSite().getPage().removePartListener(this.editorListener);
        }
        this.customDrawer.dispose();
        this.categoryGradientStart.dispose();
        this.categoryGradientEnd.dispose();
    }

    private void updateDescription() {
        ITask task = TasksUi.getTaskActivityManager().getActiveTask();
        if (this.getSite() == null || this.getSite().getPage() == null) {
            return;
        }
        IViewReference reference = this.getSite().getPage().findViewReference(ID);
        boolean shouldSetDescription = false;
        if (reference != null && reference.isFastView() && !this.getSite().getPage().isPartVisible((IWorkbenchPart)this)) {
            shouldSetDescription = true;
        }
        if (task != null) {
            this.setTitleToolTip(String.valueOf(LABEL_VIEW) + " (" + task.getSummary() + ")");
            if (shouldSetDescription) {
                this.setContentDescription(task.getSummary());
            } else {
                this.setContentDescription("");
            }
        } else {
            this.setTitleToolTip(LABEL_VIEW);
            if (shouldSetDescription) {
                this.setContentDescription(LABEL_NO_TASKS);
            } else {
                this.setContentDescription("");
            }
        }
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        this.init(site);
        this.taskListMemento = memento;
    }

    public void saveState(IMemento memento) {
        if (this.tableSorter != null) {
            IMemento child = memento.createChild("sorter");
            this.tableSorter.saveState(child);
        }
        memento.putString(MEMENTO_LINK_WITH_EDITOR, Boolean.toString(this.linkWithEditor));
        memento.putString(MEMENTO_PRESENTATION, this.currentPresentation.getId());
    }

    private void restoreState() {
        if (this.taskListMemento != null) {
            if (this.tableSorter != null) {
                IMemento sorterMemento = this.taskListMemento.getChild("sorter");
                if (sorterMemento != null) {
                    this.tableSorter.restoreState(sorterMemento);
                } else {
                    sorterMemento = this.taskListMemento.getChild(MEMENTO_SORT_INDEX);
                    if (sorterMemento != null) {
                        this.migrateSorterState(this.tableSorter, sorterMemento);
                    }
                }
            }
            this.applyPresentation(this.taskListMemento.getString(MEMENTO_PRESENTATION));
        }
        this.filterWorkingSet = new TaskWorkingSetFilter();
        this.filterWorkingSet.updateWorkingSet(this.getSite().getPage().getAggregateWorkingSet());
        this.filteredTree.setWorkingSetFilter(this.filterWorkingSet);
        this.addFilter(this.filterWorkingSet);
        this.addFilter(this.filterPriority);
        if (TasksUiPlugin.getDefault().getPreferenceStore().contains("org.eclipse.mylyn.tasks.ui.filters.complete")) {
            this.addFilter(this.filterComplete);
        }
        this.addFilter(this.filterArchive);
        boolean linkValue = true;
        if (this.taskListMemento != null && this.taskListMemento.getString(MEMENTO_LINK_WITH_EDITOR) != null) {
            linkValue = Boolean.parseBoolean(this.taskListMemento.getString(MEMENTO_LINK_WITH_EDITOR));
        }
        this.setLinkWithEditor(linkValue);
        this.getViewer().refresh();
    }

    public void migrateSorterState(TaskListSorter tableSorter, IMemento sorterMemento) {
        int restoredSortIndex = 0;
        if (sorterMemento != null) {
            IMemento m2;
            int sortDirection = -1;
            IMemento m = sorterMemento.getChild("sorter");
            if (m != null) {
                Integer sortDirInt;
                Integer sortIndexInt = m.getInteger(MEMENTO_KEY_SORT_INDEX);
                if (sortIndexInt != null) {
                    restoredSortIndex = sortIndexInt;
                }
                if ((sortDirInt = m.getInteger(MEMENTO_KEY_SORT_DIRECTION)) != null) {
                    sortDirection = sortDirInt;
                    tableSorter.getComparator().getSortCriterion(0).setDirection(sortDirection);
                    switch (restoredSortIndex) {
                        case 1: {
                            tableSorter.getComparator().getSortCriterion(0).setKey(SortCriterion.SortKey.SUMMARY);
                            break;
                        }
                        case 2: {
                            tableSorter.getComparator().getSortCriterion(0).setKey(SortCriterion.SortKey.DATE_CREATED);
                            break;
                        }
                        case 3: {
                            tableSorter.getComparator().getSortCriterion(0).setKey(SortCriterion.SortKey.TASK_ID);
                            break;
                        }
                        default: {
                            tableSorter.getComparator().getSortCriterion(0).setKey(SortCriterion.SortKey.PRIORITY);
                        }
                    }
                }
            }
            if ((m2 = sorterMemento.getChild(MEMENTO_KEY_SORTER2)) != null) {
                Integer sortDirInt;
                Integer sortIndexInt = m2.getInteger(MEMENTO_KEY_SORT_INDEX);
                if (sortIndexInt != null) {
                    restoredSortIndex = sortIndexInt;
                }
                if ((sortDirInt = m2.getInteger(MEMENTO_KEY_SORT_DIRECTION)) != null) {
                    sortDirection = sortDirInt;
                    tableSorter.getComparator().getSortCriterion(1).setDirection(sortDirection);
                    switch (restoredSortIndex) {
                        case 1: {
                            tableSorter.getComparator().getSortCriterion(1).setKey(SortCriterion.SortKey.SUMMARY);
                            break;
                        }
                        case 2: {
                            tableSorter.getComparator().getSortCriterion(1).setKey(SortCriterion.SortKey.DATE_CREATED);
                            break;
                        }
                        case 3: {
                            tableSorter.getComparator().getSortCriterion(1).setKey(SortCriterion.SortKey.TASK_ID);
                            break;
                        }
                        default: {
                            tableSorter.getComparator().getSortCriterion(1).setKey(SortCriterion.SortKey.PRIORITY);
                        }
                    }
                }
            }
        }
    }

    public void createPartControl(Composite parent) {
        IWorkbenchSiteProgressService progress = (IWorkbenchSiteProgressService)this.getSite().getAdapter(IWorkbenchSiteProgressService.class);
        if (progress != null) {
            progress.showBusyForFamily(ITasksCoreConstants.JOB_FAMILY_SYNCHRONIZATION);
        }
        this.themeManager = this.getSite().getWorkbenchWindow().getWorkbench().getThemeManager();
        this.themeManager.addPropertyChangeListener(this.THEME_CHANGE_LISTENER);
        this.filteredTree = new TaskListFilteredTree(parent, 98834, (PatternFilter)new SubstringPatternFilter(), this.getViewSite().getWorkbenchWindow());
        this.getViewer().getTree().setToolTipText("");
        this.getSite().registerContextMenu("org.eclipse.mylyn.tasks.ui.menus.activeTask", this.filteredTree.getActiveTaskMenuManager(), (ISelectionProvider)this.filteredTree.getActiveTaskSelectionProvider());
        this.filteredTree.getFilterControl().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TaskListView.this.updateFilterEnablement();
            }
        });
        this.getViewer().getTree().setHeaderVisible(false);
        this.getViewer().setUseHashlookup(true);
        this.refreshJob = new TaskListRefreshJob(this.getViewer(), "Task List Refresh");
        this.configureColumns(this.columnNames, this.columnWidths);
        IThemeManager themeManager = this.getSite().getWorkbenchWindow().getWorkbench().getThemeManager();
        Color categoryBackground = themeManager.getCurrentTheme().getColorRegistry().get("org.eclipse.mylyn.tasks.ui.colors.category.gradient.end");
        this.taskListTableLabelProvider = new TaskTableLabelProvider((ILabelProvider)new TaskElementLabelProvider(true), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator(), categoryBackground);
        this.getViewer().setLabelProvider((IBaseLabelProvider)this.taskListTableLabelProvider);
        CellEditor[] editors = new CellEditor[this.columnNames.length];
        TextCellEditor textEditor = new TextCellEditor((Composite)this.getViewer().getTree());
        ((Text)textEditor.getControl()).setOrientation(0x2000000);
        editors[0] = textEditor;
        this.getViewer().setCellEditors(editors);
        this.getViewer().setCellModifier((ICellModifier)this.taskListCellModifier);
        this.tableSorter = new TaskListSorter();
        this.getViewer().setSorter((ViewerSorter)this.tableSorter);
        this.applyPresentation("org.eclipse.mylyn.tasks.ui.categorized");
        this.drillDownAdapter = new DrillDownAdapter(this.getViewer());
        this.getViewer().setInput((Object)this.getViewSite());
        final int activationImageOffset = PlatformUtil.getTreeImageOffset();
        this.customDrawer = new CustomTaskListDecorationDrawer(this, activationImageOffset);
        this.getViewer().getTree().addListener(40, (Listener)this.customDrawer);
        this.getViewer().getTree().addListener(42, (Listener)this.customDrawer);
        this.getViewer().getTree().addMouseListener(new MouseListener(){

            public void mouseDown(MouseEvent e) {
                Object selectedObject;
                TreeItem selectedNode = ((Tree)e.widget).getItem(new Point(e.x + 70, e.y));
                if (selectedNode instanceof TreeItem && (selectedObject = selectedNode.getData()) instanceof ITask && e.x > activationImageOffset && e.x < activationImageOffset + 13) {
                    TaskListView.this.taskListCellModifier.toggleTaskActivation(selectedNode);
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        this.getViewer().getTree().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x100000B && e.stateMask == 0) {
                    if (TaskListView.this.actionGroup.getRenameAction().isEnabled()) {
                        TaskListView.this.actionGroup.getRenameAction().run();
                    }
                } else if ((e.keyCode & 0x1000000) == 0) {
                    if (e.keyCode == 27) {
                        TaskListView.this.taskListToolTip.hide();
                    } else if (e.keyCode == 102 && e.stateMask == SWT.MOD1) {
                        TaskListView.this.filteredTree.getFilterControl().setFocus();
                    } else if (e.stateMask == 0 && (Character.isLetter((char)e.keyCode) || Character.isDigit((char)e.keyCode))) {
                        String string = new Character((char)e.keyCode).toString();
                        TaskListView.this.filteredTree.getFilterControl().setText(string);
                        TaskListView.this.filteredTree.getFilterControl().setSelection(1, 1);
                        TaskListView.this.filteredTree.getFilterControl().setFocus();
                    }
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.getViewer().addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(final TreeExpansionEvent event) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        TaskListView.this.getViewer().refresh(event.getElement());
                    }
                });
            }

            public void treeExpanded(final TreeExpansionEvent event) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        TaskListView.this.getViewer().refresh(event.getElement());
                    }
                });
            }
        });
        this.taskListToolTip = new TaskListToolTip(this.getViewer().getControl());
        this.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TaskListView.this.updateToolTip(true);
            }
        });
        this.getViewer().getTree().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                TaskListView.this.taskListToolTip.hide();
            }
        });
        this.makeActions();
        this.hookGlobalActions();
        this.hookContextMenu();
        this.hookOpenAction();
        this.contributeToActionBars();
        this.initHandlers();
        this.configureGradientColors();
        this.initDragAndDrop(parent);
        this.expandToActiveTasks();
        this.restoreState();
        this.updateDescription();
        IContextService contextSupport = (IContextService)this.getSite().getService(IContextService.class);
        if (contextSupport != null) {
            contextSupport.activateContext(ID);
        }
        this.getSite().setSelectionProvider((ISelectionProvider)this.getViewer());
        this.getSite().getPage().addPartListener(this.editorListener);
        this.updatePresentationSelectorImage();
        PlatformUI.getWorkbench().getWorkingSetManager().addPropertyChangeListener((IPropertyChangeListener)this);
        TasksUiPlugin.getTaskActivityManager().addActivityListener(this.TASK_ACTIVITY_LISTENER);
        TasksUiPlugin.getTaskActivityManager().addActivationListener(this.TASK_ACTIVATION_LISTENER);
        TasksUiInternal.getTaskList().addChangeListener(this.TASKLIST_CHANGE_LISTENER);
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().addPageListener(this.PAGE_LISTENER);
    }

    private void initHandlers() {
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        handlerService.activateHandler("org.eclipse.ui.navigate.collapseAll", (IHandler)new CollapseAllHandler((AbstractTreeViewer)this.getViewer()));
    }

    private void hookGlobalActions() {
        IActionBars bars = this.getViewSite().getActionBars();
        bars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.actionGroup.getDeleteAction());
        bars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.actionGroup.getCopyDetailsAction());
    }

    private void applyPresentation(String id) {
        if (id != null) {
            for (AbstractTaskListPresentation presentation : presentationsPrimary) {
                if (!id.equals(presentation.getId())) continue;
                this.applyPresentation(presentation);
                return;
            }
            for (AbstractTaskListPresentation presentation : presentationsSecondary) {
                if (!id.equals(presentation.getId())) continue;
                this.applyPresentation(presentation);
                return;
            }
        }
    }

    public void applyPresentation(AbstractTaskListPresentation presentation) {
        try {
            this.getViewer().getControl().setRedraw(false);
            if (!this.filteredTree.getFilterString().equals("")) {
                this.filteredTree.getFilterControl().setText("");
            }
            AbstractTaskListContentProvider contentProvider = presentation.getContentProvider(this);
            this.getViewer().setContentProvider((IContentProvider)contentProvider);
            this.refresh(true);
            this.currentPresentation = presentation;
            this.updatePresentationSelectorImage();
        }
        finally {
            this.getViewer().getControl().setRedraw(true);
        }
    }

    private void updatePresentationSelectorImage() {
        if (this.presentationDropDownSelectionAction != null && this.currentPresentation != null) {
            this.presentationDropDownSelectionAction.setImageDescriptor(this.currentPresentation.getImageDescriptor());
        }
    }

    public AbstractTaskListPresentation getCurrentPresentation() {
        return this.currentPresentation;
    }

    private void configureColumns(String[] columnNames, final int[] columnWidths) {
        TreeColumnLayout layout = (TreeColumnLayout)this.getViewer().getTree().getParent().getLayout();
        this.getViewer().setColumnProperties(columnNames);
        this.columns = new TreeColumn[columnNames.length];
        int i = 0;
        while (i < columnNames.length) {
            this.columns[i] = new TreeColumn(this.getViewer().getTree(), 0);
            this.columns[i].setText(columnNames[i]);
            if (i == 0) {
                layout.setColumnData((Widget)this.columns[i], (ColumnLayoutData)new ColumnWeightData(100));
            } else {
                layout.setColumnData((Widget)this.columns[i], (ColumnLayoutData)new ColumnPixelData(columnWidths[i]));
            }
            this.columns[i].addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SortCriterion criterion = TaskListView.this.tableSorter.getComparator().getSortCriterion(0);
                    criterion.setDirection(criterion.getDirection() * -1);
                    TaskListView.this.getViewer().refresh(false);
                }
            });
            this.columns[i].addControlListener(new ControlListener(){

                public void controlResized(ControlEvent e) {
                    int j = 0;
                    while (j < columnWidths.length) {
                        if (TaskListView.this.columns[j].equals(e.getSource())) {
                            columnWidths[j] = TaskListView.this.columns[j].getWidth();
                        }
                        ++j;
                    }
                }

                public void controlMoved(ControlEvent e) {
                }
            });
            ++i;
        }
    }

    private void initDragAndDrop(Composite parent) {
        Transfer[] dragTypes = new Transfer[]{LocalSelectionTransfer.getTransfer(), FileTransfer.getInstance()};
        Transfer[] dropTypes = new Transfer[]{LocalSelectionTransfer.getTransfer(), FileTransfer.getInstance(), TextTransfer.getInstance(), RTFTransfer.getInstance(), PlatformUtil.getUrlTransfer()};
        this.getViewer().addDragSupport(7, dragTypes, (DragSourceListener)new TaskDragSourceListener((ISelectionProvider)this.getViewer()));
        this.getViewer().addDropSupport(23, dropTypes, (DropTargetListener)new TaskListDropAdapter((Viewer)this.getViewer()));
    }

    void expandToActiveTasks() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        workbench.getDisplay().asyncExec(new Runnable(){

            public void run() {
                ITask task = TasksUi.getTaskActivityManager().getActiveTask();
                if (task != null) {
                    TaskListView.this.getViewer().expandToLevel((Object)task, 0);
                }
            }
        });
    }

    private void hookContextMenu() {
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                TaskListView.this.actionGroup.fillContextMenu(manager);
            }
        });
        Menu menu = menuManager.createContextMenu(this.getViewer().getControl());
        this.getViewer().getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.getViewer());
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        this.updateDrillDownActions();
        manager.add((IAction)this.actionGroup.getGoUpAction());
        manager.add((IAction)this.collapseAll);
        manager.add((IAction)this.expandAll);
        manager.add((IContributionItem)new Separator(ID_SEPARATOR_FILTERS));
        manager.add((IAction)this.sortDialogAction);
        manager.add((IAction)this.filterOnPriorityAction);
        manager.add((IAction)this.filterCompleteTask);
        manager.add((IAction)this.filterSubTasksAction);
        manager.add((IContributionItem)new Separator(ID_SEPARATOR_TASKS));
        manager.add((IAction)this.synchronizeAutomatically);
        manager.add((IContributionItem)new Separator("additions"));
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                TaskListView.this.filterOnPriorityAction.updateCheckedState();
            }
        });
        manager.add((IAction)this.linkWithEditorAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.openPreferencesAction);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.newTaskAction);
        manager.add((IAction)this.presentationDropDownSelectionAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.filterCompleteTask);
        manager.add((IAction)this.collapseAll);
        manager.add((IContributionItem)new GroupMarker(ID_SEPARATOR_CONTEXT));
        manager.add((IContributionItem)new Separator("additions"));
    }

    public List<IRepositoryElement> getSelectedTaskContainers() {
        ArrayList<IRepositoryElement> selectedElements = new ArrayList<IRepositoryElement>();
        for (Object object : (IStructuredSelection)this.getViewer().getSelection()) {
            if (!(object instanceof ITaskContainer)) continue;
            selectedElements.add((IRepositoryElement)object);
        }
        return selectedElements;
    }

    private void makeActions() {
        this.actionGroup = new TaskListViewActionGroup(this, this.drillDownAdapter);
        this.actionGroup.getOpenAction().setViewer((AbstractTreeViewer)this.getViewer());
        this.collapseAll = new CollapseAllAction(this);
        this.expandAll = new ExpandAllAction(this);
        this.filterCompleteTask = new FilterCompletedTasksAction(this);
        this.filterSubTasksAction = new GroupSubTasksAction(this);
        this.synchronizeAutomatically = new SynchronizeAutomaticallyAction();
        this.openPreferencesAction = new OpenTasksUiPreferencesAction();
        this.sortDialogAction = new TaskListSortAction(this.getSite(), this);
        this.filterOnPriorityAction = new PriorityDropDownAction(this);
        this.linkWithEditorAction = new LinkWithEditorAction(this);
        this.newTaskAction = new NewTaskAction();
        this.filteredTree.getViewer().addSelectionChangedListener((ISelectionChangedListener)this.newTaskAction);
    }

    private void hookOpenAction() {
        this.getViewer().addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                TaskListView.this.actionGroup.getOpenAction().run();
            }
        });
        this.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                AbstractTask selectedTask;
                if (TasksUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.tasks.ui.activate.when.opened") && (selectedTask = TaskListView.getFromActivePerspective().getSelectedTask()) != null) {
                    TaskListView.this.actionGroup.getActivateAction().run((ITask)selectedTask);
                }
            }
        });
    }

    public void setFocus() {
        this.filteredTree.getViewer().getControl().setFocus();
    }

    public void refresh(boolean expandIfFocused) {
        if (expandIfFocused && this.isFocusedMode() && this.isAutoExpandMode()) {
            try {
                this.getViewer().getControl().setRedraw(false);
                this.refreshJob.refreshNow();
                this.getViewer().expandAll();
            }
            finally {
                this.getViewer().getControl().setRedraw(true);
            }
        } else {
            this.refreshJob.refreshNow();
        }
    }

    public void refresh() {
        this.refreshJob.refreshNow();
    }

    public TaskListToolTip getToolTip() {
        return this.taskListToolTip;
    }

    public TreeViewer getViewer() {
        return this.filteredTree.getViewer();
    }

    public TaskCompletionFilter getCompleteFilter() {
        return this.filterComplete;
    }

    public TaskPriorityFilter getPriorityFilter() {
        return this.filterPriority;
    }

    public void addFilter(AbstractTaskListFilter filter) {
        if (!this.filters.contains(filter)) {
            this.filters.add(filter);
        }
    }

    public void clearFilters() {
        this.filters.clear();
        this.filters.add(this.filterArchive);
        this.filters.add(this.filterWorkingSet);
    }

    public void removeFilter(AbstractTaskListFilter filter) {
        this.filters.remove(filter);
    }

    public void updateDrillDownActions() {
        this.actionGroup.updateDrillDownActions();
    }

    public void setInRenameAction(boolean b) {
        this.isInRenameAction = b;
    }

    public void goIntoCategory() {
        StructuredSelection structuredSelection;
        Object element;
        ISelection selection = this.getViewer().getSelection();
        if (selection instanceof StructuredSelection && (element = (structuredSelection = (StructuredSelection)selection).getFirstElement()) instanceof ITaskContainer) {
            this.drilledIntoCategory = (AbstractTaskContainer)element;
            this.drillDownAdapter.goInto();
            IActionBars bars = this.getViewSite().getActionBars();
            bars.getToolBarManager().remove(this.actionGroup.getGoUpAction().getId());
            bars.getToolBarManager().add((IAction)this.actionGroup.getGoUpAction());
            bars.updateActionBars();
            this.updateDrillDownActions();
        }
    }

    public void goUpToRoot() {
        this.drilledIntoCategory = null;
        this.drillDownAdapter.goBack();
        IActionBars bars = this.getViewSite().getActionBars();
        bars.getToolBarManager().remove("org.eclipse.mylyn.tasklist.actions.view.go.up");
        bars.updateActionBars();
        this.updateDrillDownActions();
    }

    public AbstractTask getSelectedTask() {
        StructuredSelection structuredSelection;
        Object element;
        ISelection selection = this.getViewer().getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        if (selection instanceof StructuredSelection && (element = (structuredSelection = (StructuredSelection)selection).getFirstElement()) instanceof ITask) {
            return (AbstractTask)structuredSelection.getFirstElement();
        }
        return null;
    }

    public static AbstractTask getSelectedTask(ISelection selection) {
        if (selection instanceof StructuredSelection) {
            StructuredSelection structuredSelection = (StructuredSelection)selection;
            if (structuredSelection.size() != 1) {
                return null;
            }
            Object element = structuredSelection.getFirstElement();
            if (element instanceof ITask) {
                return (AbstractTask)structuredSelection.getFirstElement();
            }
        }
        return null;
    }

    public void indicatePaused(boolean paused) {
        this.isPaused = paused;
        IStatusLineManager statusLineManager = this.getViewSite().getActionBars().getStatusLineManager();
        if (this.isPaused) {
            statusLineManager.setMessage(CommonImages.getImage((ImageDescriptor)TasksUiImages.TASKS_VIEW), Messages.TaskListView_Mylyn_context_capture_paused);
            this.setPartName(String.valueOf(Messages.TaskListView__paused_) + LABEL_VIEW);
        } else {
            statusLineManager.setMessage("");
            this.setPartName(LABEL_VIEW);
        }
    }

    public AbstractTaskContainer getDrilledIntoCategory() {
        return this.drilledIntoCategory;
    }

    public TaskListFilteredTree getFilteredTree() {
        return this.filteredTree;
    }

    public void selectedAndFocusTask(ITask task) {
        block3: {
            if (task == null || this.getViewer().getControl().isDisposed()) {
                return;
            }
            this.saveSelection();
            IStructuredSelection selection = this.restoreSelection((IRepositoryElement)task);
            try {
                this.getViewer().setSelection((ISelection)selection, true);
            }
            catch (SWTError e) {
                if (this.itemNotFoundExceptionLogged) break block3;
                this.itemNotFoundExceptionLogged = true;
                StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.tasks.ui", "Could not link Task List with editor", (Throwable)e));
            }
        }
    }

    private void saveSelection() {
        IStructuredSelection selection = (IStructuredSelection)this.getViewer().getSelection();
        if (!selection.isEmpty() && selection.getFirstElement() instanceof ITaskContainer) {
            String handle = ((IRepositoryElement)selection.getFirstElement()).getHandleIdentifier();
            this.lastSelectionByTaskHandle.remove(handle);
            this.lastSelectionByTaskHandle.put(handle, selection);
            if (this.lastSelectionByTaskHandle.size() > 10) {
                Iterator<String> it = this.lastSelectionByTaskHandle.keySet().iterator();
                it.next();
                it.remove();
            }
        }
    }

    private IStructuredSelection restoreSelection(IRepositoryElement task) {
        IStructuredSelection selection = this.lastSelectionByTaskHandle.get(task.getHandleIdentifier());
        if (selection != null) {
            return selection;
        }
        return new StructuredSelection((Object)task);
    }

    public Image[] getPirorityImages() {
        Image[] images = new Image[ITask.PriorityLevel.values().length];
        int i = 0;
        while (i < ITask.PriorityLevel.values().length) {
            images[i] = TasksUiImages.getImageForPriority(ITask.PriorityLevel.values()[i]);
            ++i;
        }
        return images;
    }

    public Set<AbstractTaskListFilter> getFilters() {
        return this.filters;
    }

    public static String getCurrentPriorityLevel() {
        if (TasksUiPlugin.getDefault().getPreferenceStore().contains("org.eclipse.mylyn.tasks.ui.filters.priority")) {
            return TasksUiPlugin.getDefault().getPreferenceStore().getString("org.eclipse.mylyn.tasks.ui.filters.priority");
        }
        return ITask.PriorityLevel.P5.toString();
    }

    public TaskArchiveFilter getArchiveFilter() {
        return this.filterArchive;
    }

    private void updateFilterEnablement() {
        String filterText;
        boolean enabled;
        boolean bl = enabled = !this.isFocusedMode();
        if (enabled && (filterText = this.filteredTree.getFilterString()) != null && filterText.length() > 0) {
            enabled = false;
        }
        this.sortDialogAction.setEnabled(enabled);
        this.filterOnPriorityAction.setEnabled(enabled);
        this.filterCompleteTask.setEnabled(enabled);
    }

    public boolean isScheduledPresentation() {
        return this.currentPresentation != null && "org.eclipse.mylyn.tasks.ui.scheduled".equals(this.currentPresentation.getId());
    }

    public boolean isFocusedMode() {
        return this.focusedMode;
    }

    private boolean isAutoExpandMode() {
        return TasksUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.tasks.ui.auto.expand");
    }

    public void setFocusedMode(boolean focusedMode) {
        if (this.focusedMode == focusedMode) {
            return;
        }
        this.focusedMode = focusedMode;
        IToolBarManager manager = this.getViewSite().getActionBars().getToolBarManager();
        if (focusedMode && this.isAutoExpandMode()) {
            manager.remove("org.eclipse.mylyn.tasklist.actions.filter.completed");
            manager.remove("org.eclipse.mylyn.tasklist.actions.collapse.all");
        } else if (manager.find("org.eclipse.mylyn.tasklist.actions.collapse.all") == null) {
            manager.prependToGroup(ID_SEPARATOR_CONTEXT, (IAction)this.collapseAll);
            manager.prependToGroup(ID_SEPARATOR_CONTEXT, (IAction)this.filterCompleteTask);
        }
        manager.update(false);
        this.updateFilterEnablement();
    }

    public void setSynchronizationOverlaid(boolean synchronizationOverlaid) {
        this.synchronizationOverlaid = synchronizationOverlaid;
        this.getViewer().refresh();
    }

    public void displayPrioritiesAbove(String priority) {
        this.filterPriority.displayPrioritiesAbove(priority);
        this.getViewer().refresh();
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if ("workingSetContentChange".equals(property) || "workingSetRemove".equals(property)) {
            if (this.getSite() != null && this.getSite().getPage() != null && this.filterWorkingSet.updateWorkingSet(this.getSite().getPage().getAggregateWorkingSet())) {
                try {
                    this.getViewer().getControl().setRedraw(false);
                    if (this.drilledIntoCategory != null) {
                        this.goUpToRoot();
                    }
                    this.getViewer().refresh();
                    if (this.isFocusedMode() && this.isAutoExpandMode()) {
                        this.getViewer().expandAll();
                    }
                }
                finally {
                    this.getViewer().getControl().setRedraw(true);
                }
            }
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    TaskListView.this.filteredTree.indicateActiveTaskWorkingSet();
                }
            });
        }
    }

    public void setLinkWithEditor(boolean linkWithEditor) {
        IEditorPart activeEditor;
        this.linkWithEditor = linkWithEditor;
        this.linkWithEditorAction.setChecked(linkWithEditor);
        if (linkWithEditor && (activeEditor = this.getSite().getPage().getActiveEditor()) != null) {
            this.jumpToEditorTask(activeEditor);
        }
    }

    private void jumpToEditorTask(IEditorPart editor) {
        IEditorInput input = editor.getEditorInput();
        if (input instanceof TaskEditorInput) {
            ITask task = ((TaskEditorInput)input).getTask();
            AbstractTask selected = this.getSelectedTask();
            if (selected == null || !selected.equals(task)) {
                this.selectedAndFocusTask(task);
            }
        }
    }

    private void updateToolTip(boolean force) {
        if (this.taskListToolTip != null && this.taskListToolTip.isVisible()) {
            if (!force && this.taskListToolTip.isTriggeredByMouse()) {
                return;
            }
            TreeItem[] selection = this.getViewer().getTree().getSelection();
            if (selection != null && selection.length > 0) {
                Rectangle bounds = selection[0].getBounds();
                this.taskListToolTip.show(new Point(bounds.x + 1, bounds.y + 1));
            }
        }
    }

    public static List<AbstractTaskListPresentation> getPresentations() {
        ArrayList<AbstractTaskListPresentation> presentations = new ArrayList<AbstractTaskListPresentation>();
        presentations.addAll(presentationsPrimary);
        presentations.addAll(presentationsSecondary);
        return presentations;
    }

    public static void addPresentation(AbstractTaskListPresentation presentation) {
        if (presentation.isPrimary()) {
            presentationsPrimary.add(presentation);
        } else {
            presentationsSecondary.add(presentation);
        }
    }

    public TaskListSorter getSorter() {
        return this.tableSorter;
    }

    public boolean show(ShowInContext context) {
        ISelection selection = context.getSelection();
        if (selection instanceof IStructuredSelection) {
            this.getViewer().setSelection(selection, true);
            return true;
        }
        return false;
    }

    private final class TaskListRefreshJob
    extends DelayedRefreshJob {
        private TaskListRefreshJob(TreeViewer treeViewer, String name) {
            super((StructuredViewer)treeViewer, name);
        }

        protected void doRefresh(Object[] items) {
            TreePath selection = this.preserveSelection();
            if (items == null) {
                this.viewer.refresh(true);
            } else if (items.length > 0) {
                try {
                    if (TaskListView.this.isFocusedMode()) {
                        Object item2;
                        HashSet<Object> children = new HashSet<Object>(Arrays.asList(items));
                        HashSet parents = new HashSet();
                        Object[] objectArray = items;
                        int n = items.length;
                        int n2 = 0;
                        while (n2 < n) {
                            item2 = objectArray[n2];
                            if (item2 instanceof AbstractTask) {
                                parents.addAll(((AbstractTask)item2).getParentContainers());
                            }
                            ++n2;
                        }
                        children.removeAll(parents);
                        for (AbstractTaskContainer parent : parents) {
                            this.viewer.refresh((Object)parent, false);
                            this.viewer.update((Object)parent, null);
                        }
                        for (Object item2 : children) {
                            this.viewer.refresh(item2, true);
                        }
                        objectArray = items;
                        n = items.length;
                        int n3 = 0;
                        while (n3 < n) {
                            item2 = objectArray[n3];
                            this.updateExpansionState(item2);
                            ++n3;
                        }
                    } else {
                        HashSet parents = new HashSet();
                        Object[] objectArray = items;
                        int n = items.length;
                        int n4 = 0;
                        while (n4 < n) {
                            Object item = objectArray[n4];
                            if (item instanceof AbstractTask) {
                                parents.addAll(((AbstractTask)item).getParentContainers());
                            }
                            this.viewer.refresh(item, true);
                            this.updateExpansionState(item);
                            ++n4;
                        }
                        for (AbstractTaskContainer parent : parents) {
                            this.viewer.update((Object)parent, null);
                        }
                    }
                }
                catch (SWTException e) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Failed to refresh viewer: " + this.viewer, (Throwable)e));
                }
            }
            TaskListView.this.updateToolTip(false);
            this.restoreSelection(selection);
        }

        private TreePath preserveSelection() {
            TreeViewer treeViewer;
            TreeItem[] selection;
            if (this.viewer instanceof TreeViewer && (selection = (treeViewer = (TreeViewer)this.viewer).getTree().getSelection()).length > 0) {
                TreeWalker treeWalker = new TreeWalker(treeViewer);
                return treeWalker.walk(new TreeWalker.TreeVisitor(){

                    public boolean visit(Object object) {
                        return true;
                    }
                }, selection[selection.length - 1]);
            }
            return null;
        }

        private void restoreSelection(TreePath treePath) {
            ISelection newSelection;
            if (treePath != null && ((newSelection = this.viewer.getSelection()) == null || newSelection.isEmpty())) {
                this.viewer.setSelection((ISelection)new TreeSelection(treePath), true);
            }
        }

        protected void updateExpansionState(Object item) {
            if (TaskListView.this.isFocusedMode() && TaskListView.this.isAutoExpandMode()) {
                TaskListView.this.getViewer().expandToLevel(item, 3);
            }
        }
    }
}

