/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.ui.editor.syntax;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.mylyn.internal.wikitext.ui.WikiTextUiPlugin;
import org.eclipse.mylyn.internal.wikitext.ui.editor.syntax.Messages;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.LinkAttributes;
import org.eclipse.mylyn.wikitext.core.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.core.parser.builder.NoOpDocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class MarkupHyperlinkDetector
implements IHyperlinkDetector {
    private MarkupLanguage markupLanguage;
    private IFile file;

    public void setMarkupLanguage(MarkupLanguage markupLanguage) {
        this.markupLanguage = markupLanguage;
    }

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        String content;
        int contentOffset;
        if (this.markupLanguage == null || this.file == null) {
            return null;
        }
        IDocument document = textViewer.getDocument();
        if (document == null || document.getLength() == 0) {
            return null;
        }
        try {
            if (region.getLength() == 0) {
                int regionLength;
                IRegion lineInfo = document.getLineInformationOfOffset(region.getOffset());
                int lineLength = lineInfo.getLength();
                int lineOffset = lineInfo.getOffset();
                int lineEnd = lineOffset + lineLength;
                int regionEnd = region.getOffset() + region.getLength();
                if (lineOffset < region.getOffset()) {
                    regionLength = Math.max(regionEnd, lineEnd) - lineOffset;
                    contentOffset = lineOffset;
                    content = document.get(lineOffset, regionLength);
                } else {
                    regionLength = Math.max(regionEnd, lineEnd) - region.getOffset();
                    contentOffset = region.getOffset();
                    content = document.get(contentOffset, regionLength);
                }
            } else {
                content = document.get(region.getOffset(), region.getLength());
                contentOffset = region.getOffset();
            }
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        MarkupParser markupParser = new MarkupParser(this.markupLanguage);
        final ArrayList links = new ArrayList();
        markupParser.setBuilder((DocumentBuilder)new NoOpDocumentBuilder(){

            public void link(Attributes attributes, String hrefOrHashName, String text) {
                if (hrefOrHashName != null && !hrefOrHashName.startsWith("#")) {
                    IRegion region = this.createRegion();
                    links.add(new HyperlinkDescriptor(hrefOrHashName, region));
                }
            }

            private IRegion createRegion() {
                int offset = this.getLocator().getLineCharacterOffset();
                int length = this.getLocator().getLineSegmentEndOffset() - offset;
                return new Region(offset, length);
            }

            public void beginSpan(DocumentBuilder.SpanType type, Attributes attributes) {
                LinkAttributes linkAttributes;
                if (type == DocumentBuilder.SpanType.LINK && attributes instanceof LinkAttributes && (linkAttributes = (LinkAttributes)attributes).getHref() != null && !linkAttributes.getHref().startsWith("#")) {
                    IRegion region = this.createRegion();
                    links.add(new HyperlinkDescriptor(linkAttributes.getHref(), region));
                }
            }
        });
        markupParser.parse(content);
        if (!links.isEmpty()) {
            ArrayList<EditFileHyperlink> hyperlinks = new ArrayList<EditFileHyperlink>(links.size());
            for (HyperlinkDescriptor descriptor : links) {
                if (descriptor.href.indexOf(58) != -1 || descriptor.href.length() <= 1 || descriptor.href.charAt(0) == '/') continue;
                Region hyperlinkRegion = new Region(descriptor.region.getOffset() + contentOffset, descriptor.region.getLength());
                if (region.getLength() > 0 ? !this.isInRegion(region, (IRegion)hyperlinkRegion) : hyperlinkRegion.getOffset() > region.getOffset() || hyperlinkRegion.getOffset() + hyperlinkRegion.getLength() < region.getOffset()) continue;
                try {
                    IResource[] members;
                    IContainer parent;
                    IPath containerPath = this.file.getParent().getFullPath();
                    IPath absolutePath = containerPath.append(descriptor.href);
                    IFile targetFile = ResourcesPlugin.getWorkspace().getRoot().getFile(absolutePath);
                    if (targetFile == null) continue;
                    if (targetFile.exists()) {
                        hyperlinks.add(new EditFileHyperlink(targetFile, (IRegion)hyperlinkRegion));
                    }
                    if (!(parent = targetFile.getParent()).exists()) continue;
                    String nameNoExtension = targetFile.getName();
                    if (nameNoExtension.indexOf(46) != -1) {
                        nameNoExtension = nameNoExtension.substring(0, nameNoExtension.lastIndexOf(46) + 1);
                    }
                    IResource[] iResourceArray = members = parent.members();
                    int n = members.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResource resource = iResourceArray[n2];
                        if (resource.getType() == 1 && resource.getName().startsWith(nameNoExtension) && !resource.equals((Object)targetFile)) {
                            hyperlinks.add(new EditFileHyperlink((IFile)resource, (IRegion)hyperlinkRegion));
                        }
                        ++n2;
                    }
                }
                catch (Throwable throwable) {}
            }
            if (!hyperlinks.isEmpty()) {
                return hyperlinks.toArray(new IHyperlink[hyperlinks.size()]);
            }
        }
        return null;
    }

    private boolean isInRegion(IRegion detectInRegion, IRegion hyperlinkRegion) {
        return detectInRegion.getOffset() >= hyperlinkRegion.getOffset() && detectInRegion.getOffset() <= hyperlinkRegion.getOffset() + hyperlinkRegion.getLength();
    }

    public void setFile(IFile file) {
        this.file = file;
    }

    private static class EditFileHyperlink
    implements IHyperlink {
        private final IFile file;
        private final IRegion region;

        protected EditFileHyperlink(IFile file, IRegion region) {
            this.file = file;
            this.region = region;
        }

        public IRegion getHyperlinkRegion() {
            return this.region;
        }

        public String getTypeLabel() {
            return null;
        }

        public String getHyperlinkText() {
            return NLS.bind((String)Messages.MarkupHyperlinkDetector_openFileInEditor, (Object)this.file.getName());
        }

        public void open() {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            IWorkbenchPage activePage = window.getActivePage();
            try {
                IDE.openEditor((IWorkbenchPage)activePage, (IFile)this.file);
            }
            catch (PartInitException e) {
                WikiTextUiPlugin.getDefault().log(e);
                MessageDialog.openError((Shell)window.getShell(), (String)Messages.MarkupHyperlinkDetector_unexpectedError, (String)NLS.bind((String)Messages.MarkupHyperlinkDetector_openException, (Object)this.file.getName(), (Object)e.getMessage()));
            }
        }
    }

    private static class HyperlinkDescriptor {
        String href;
        IRegion region;

        protected HyperlinkDescriptor(String href, IRegion region) {
            this.href = href;
            this.region = region;
        }
    }
}

