/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.animation.client.Animation;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.EventTarget;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.logical.shared.HasCloseHandlers;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.i18n.client.LocaleInfo;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.EventPreview;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.HasAnimation;
import com.google.gwt.user.client.ui.KeyboardListenerCollection;
import com.google.gwt.user.client.ui.ListenerWrapper;
import com.google.gwt.user.client.ui.PopupListener;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.SourcesPopupEvents;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.user.client.ui.impl.PopupImpl;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PopupPanel
extends SimplePanel
implements SourcesPopupEvents,
EventPreview,
HasAnimation,
HasCloseHandlers<PopupPanel> {
    private static final int ANIMATION_DURATION = 200;
    private static final String DEFAULT_STYLENAME = "gwt-PopupPanel";
    private static final PopupImpl impl = (PopupImpl)GWT.create(PopupImpl.class);
    private ResizeHandler glassResizer = new ResizeHandler(){

        public void onResize(ResizeEvent event) {
            Style style = PopupPanel.this.glass.getStyle();
            int winWidth = Window.getClientWidth();
            int winHeight = Window.getClientHeight();
            style.setDisplay(Style.Display.NONE);
            style.setWidth(0.0, Style.Unit.PX);
            style.setHeight(0.0, Style.Unit.PX);
            int width = Document.get().getScrollWidth();
            int height = Document.get().getScrollHeight();
            style.setWidth(Math.max(width, winWidth), Style.Unit.PX);
            style.setHeight(Math.max(height, winHeight), Style.Unit.PX);
            style.setDisplay(Style.Display.BLOCK);
        }
    };
    private AnimationType animType = AnimationType.CENTER;
    private boolean autoHide;
    private boolean previewAllNativeEvents;
    private boolean modal;
    private boolean showing;
    private boolean autoHideOnHistoryEvents;
    private List<com.google.gwt.dom.client.Element> autoHidePartners;
    private String desiredHeight;
    private String desiredWidth;
    private com.google.gwt.dom.client.Element glass;
    private String glassStyleName = "gwt-PopupPanelGlass";
    private boolean isGlassEnabled;
    private boolean isAnimationEnabled = false;
    private int leftPosition = -1;
    private HandlerRegistration nativePreviewHandlerRegistration;
    private HandlerRegistration historyHandlerRegistration;
    private ResizeAnimation resizeAnimation = new ResizeAnimation(this);
    private int topPosition = -1;

    public PopupPanel() {
        super.getContainerElement().appendChild(impl.createElement());
        this.setPopupPosition(0, 0);
        this.setStyleName(DEFAULT_STYLENAME);
        PopupPanel.setStyleName(this.getContainerElement(), "popupContent");
    }

    public PopupPanel(boolean autoHide) {
        this();
        this.autoHide = autoHide;
        this.autoHideOnHistoryEvents = autoHide;
    }

    public PopupPanel(boolean autoHide, boolean modal) {
        this(autoHide);
        this.modal = modal;
    }

    public void addAutoHidePartner(com.google.gwt.dom.client.Element partner) {
        assert (partner != null) : "partner cannot be null";
        if (this.autoHidePartners == null) {
            this.autoHidePartners = new ArrayList<com.google.gwt.dom.client.Element>();
        }
        this.autoHidePartners.add(partner);
    }

    @Override
    public HandlerRegistration addCloseHandler(CloseHandler<PopupPanel> handler) {
        return this.addHandler(handler, CloseEvent.getType());
    }

    @Override
    @Deprecated
    public void addPopupListener(PopupListener listener) {
        ListenerWrapper.WrappedPopupListener.add(this, listener);
    }

    public void center() {
        boolean initiallyShowing = this.showing;
        boolean initiallyAnimated = this.isAnimationEnabled;
        if (!initiallyShowing) {
            this.setVisible(false);
            this.setAnimationEnabled(false);
            this.show();
        }
        int left = Window.getClientWidth() - this.getOffsetWidth() >> 1;
        int top = Window.getClientHeight() - this.getOffsetHeight() >> 1;
        this.setPopupPosition(Math.max(Window.getScrollLeft() + left, 0), Math.max(Window.getScrollTop() + top, 0));
        if (!initiallyShowing) {
            this.setAnimationEnabled(initiallyAnimated);
            if (initiallyAnimated) {
                impl.setClip(this.getElement(), "rect(0px, 0px, 0px, 0px)");
                this.setVisible(true);
                this.resizeAnimation.run(200);
            } else {
                this.setVisible(true);
            }
        }
    }

    public String getGlassStyleName() {
        return this.glassStyleName;
    }

    @Override
    public int getOffsetHeight() {
        return super.getOffsetHeight();
    }

    @Override
    public int getOffsetWidth() {
        return super.getOffsetWidth();
    }

    public int getPopupLeft() {
        return DOM.getAbsoluteLeft(this.getElement());
    }

    public int getPopupTop() {
        return DOM.getAbsoluteTop(this.getElement());
    }

    @Override
    public String getTitle() {
        return DOM.getElementProperty(this.getContainerElement(), "title");
    }

    public void hide() {
        this.hide(false);
    }

    public void hide(boolean autoClosed) {
        if (!this.isShowing()) {
            return;
        }
        this.setState(false, true);
        CloseEvent.fire(this, this, autoClosed);
    }

    @Override
    public boolean isAnimationEnabled() {
        return this.isAnimationEnabled;
    }

    public boolean isAutoHideEnabled() {
        return this.autoHide;
    }

    public boolean isAutoHideOnHistoryEventsEnabled() {
        return this.autoHideOnHistoryEvents;
    }

    public boolean isGlassEnabled() {
        return this.isGlassEnabled;
    }

    public boolean isModal() {
        return this.modal;
    }

    public boolean isPreviewingAllNativeEvents() {
        return this.previewAllNativeEvents;
    }

    public boolean isShowing() {
        return this.showing;
    }

    @Override
    public boolean isVisible() {
        return !"hidden".equals(this.getElement().getStyle().getProperty("visibility"));
    }

    @Override
    @Deprecated
    public boolean onEventPreview(Event event) {
        return true;
    }

    @Deprecated
    public boolean onKeyDownPreview(char key, int modifiers) {
        return true;
    }

    @Deprecated
    public boolean onKeyPressPreview(char key, int modifiers) {
        return true;
    }

    @Deprecated
    public boolean onKeyUpPreview(char key, int modifiers) {
        return true;
    }

    public void removeAutoHidePartner(com.google.gwt.dom.client.Element partner) {
        assert (partner != null) : "partner cannot be null";
        if (this.autoHidePartners != null) {
            this.autoHidePartners.remove(partner);
        }
    }

    @Override
    @Deprecated
    public void removePopupListener(PopupListener listener) {
        ListenerWrapper.WrappedPopupListener.remove(this, listener);
    }

    @Override
    public void setAnimationEnabled(boolean enable) {
        this.isAnimationEnabled = enable;
    }

    public void setAutoHideEnabled(boolean autoHide) {
        this.autoHide = autoHide;
    }

    public void setAutoHideOnHistoryEventsEnabled(boolean enabled) {
        this.autoHideOnHistoryEvents = enabled;
    }

    public void setGlassEnabled(boolean enabled) {
        this.isGlassEnabled = enabled;
        if (enabled && this.glass == null) {
            this.glass = Document.get().createDivElement();
            this.glass.setClassName(this.glassStyleName);
            this.glass.getStyle().setPosition(Style.Position.ABSOLUTE);
            this.glass.getStyle().setLeft(0.0, Style.Unit.PX);
            this.glass.getStyle().setTop(0.0, Style.Unit.PX);
        }
    }

    public void setGlassStyleName(String glassStyleName) {
        this.glassStyleName = glassStyleName;
        if (this.glass != null) {
            this.glass.setClassName(glassStyleName);
        }
    }

    @Override
    public void setHeight(String height) {
        this.desiredHeight = height;
        this.maybeUpdateSize();
        if (height.length() == 0) {
            this.desiredHeight = null;
        }
    }

    public void setModal(boolean modal) {
        this.modal = modal;
    }

    public void setPopupPosition(int left, int top) {
        this.leftPosition = left;
        this.topPosition = top;
        Element elem = this.getElement();
        elem.getStyle().setPropertyPx("left", left -= Document.get().getBodyOffsetLeft());
        elem.getStyle().setPropertyPx("top", top -= Document.get().getBodyOffsetTop());
    }

    public void setPopupPositionAndShow(PositionCallback callback) {
        this.setVisible(false);
        this.show();
        callback.setPosition(this.getOffsetWidth(), this.getOffsetHeight());
        this.setVisible(true);
    }

    public void setPreviewingAllNativeEvents(boolean previewAllNativeEvents) {
        this.previewAllNativeEvents = previewAllNativeEvents;
    }

    @Override
    public void setTitle(String title) {
        Element containerElement = this.getContainerElement();
        if (title == null || title.length() == 0) {
            containerElement.removeAttribute("title");
        } else {
            containerElement.setAttribute("title", title);
        }
    }

    @Override
    public void setVisible(boolean visible) {
        DOM.setStyleAttribute(this.getElement(), "visibility", visible ? "visible" : "hidden");
        impl.setVisible(this.getElement(), visible);
        if (this.glass != null) {
            impl.setVisible(this.glass, visible);
        }
    }

    @Override
    public void setWidget(Widget w) {
        super.setWidget(w);
        this.maybeUpdateSize();
    }

    @Override
    public void setWidth(String width) {
        this.desiredWidth = width;
        this.maybeUpdateSize();
        if (width.length() == 0) {
            this.desiredWidth = null;
        }
    }

    public void show() {
        if (this.showing) {
            return;
        }
        this.setState(true, true);
    }

    public final void showRelativeTo(final UIObject target) {
        this.setPopupPositionAndShow(new PositionCallback(){

            public void setPosition(int offsetWidth, int offsetHeight) {
                PopupPanel.this.position(target, offsetWidth, offsetHeight);
            }
        });
    }

    @Override
    protected Element getContainerElement() {
        return (Element)impl.getContainerElement(this.getPopupImplElement()).cast();
    }

    protected com.google.gwt.dom.client.Element getGlassElement() {
        return this.glass;
    }

    @Override
    protected Element getStyleElement() {
        return (Element)impl.getStyleElement(this.getPopupImplElement()).cast();
    }

    protected void onPreviewNativeEvent(Event.NativePreviewEvent event) {
        if (event.isFirstHandler() && !this.onEventPreview(Event.as(event.getNativeEvent()))) {
            event.cancel();
        }
    }

    @Override
    protected void onUnload() {
        if (this.isShowing()) {
            this.setState(false, false);
        }
    }

    void maybeUpdateSize() {
        Widget w = super.getWidget();
        if (w != null) {
            if (this.desiredHeight != null) {
                w.setHeight(this.desiredHeight);
            }
            if (this.desiredWidth != null) {
                w.setWidth(this.desiredWidth);
            }
        }
    }

    void setAnimation(ResizeAnimation animation) {
        this.resizeAnimation = animation;
    }

    void setAnimationType(AnimationType type) {
        this.animType = type;
    }

    private native void blur(com.google.gwt.dom.client.Element var1);

    private boolean eventTargetsPartner(NativeEvent event) {
        if (this.autoHidePartners == null) {
            return false;
        }
        EventTarget target = event.getEventTarget();
        if (com.google.gwt.dom.client.Element.is(target)) {
            for (com.google.gwt.dom.client.Element elem : this.autoHidePartners) {
                if (!elem.isOrHasChild(com.google.gwt.dom.client.Element.as(target))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean eventTargetsPopup(NativeEvent event) {
        EventTarget target = event.getEventTarget();
        if (com.google.gwt.dom.client.Element.is(target)) {
            return this.getElement().isOrHasChild(com.google.gwt.dom.client.Element.as(target));
        }
        return false;
    }

    private Element getPopupImplElement() {
        return DOM.getFirstChild(super.getContainerElement());
    }

    private void position(UIObject relativeObject, int offsetWidth, int offsetHeight) {
        int left;
        int textBoxOffsetWidth = relativeObject.getOffsetWidth();
        int offsetWidthDiff = offsetWidth - textBoxOffsetWidth;
        if (LocaleInfo.getCurrentLocale().isRTL()) {
            int textBoxAbsoluteLeft = relativeObject.getAbsoluteLeft();
            left = textBoxAbsoluteLeft - offsetWidthDiff;
            if (offsetWidthDiff > 0) {
                int windowRight = Window.getClientWidth() + Window.getScrollLeft();
                int windowLeft = Window.getScrollLeft();
                int textBoxLeftValForRightEdge = textBoxAbsoluteLeft + textBoxOffsetWidth;
                int distanceToWindowRight = windowRight - textBoxLeftValForRightEdge;
                int distanceFromWindowLeft = textBoxLeftValForRightEdge - windowLeft;
                if (distanceFromWindowLeft < offsetWidth && distanceToWindowRight >= offsetWidthDiff) {
                    left = textBoxAbsoluteLeft;
                }
            }
        } else {
            left = relativeObject.getAbsoluteLeft();
            if (offsetWidthDiff > 0) {
                int windowRight = Window.getClientWidth() + Window.getScrollLeft();
                int windowLeft = Window.getScrollLeft();
                int distanceToWindowRight = windowRight - left;
                int distanceFromWindowLeft = left - windowLeft;
                if (distanceToWindowRight < offsetWidth && distanceFromWindowLeft >= offsetWidthDiff) {
                    left -= offsetWidthDiff;
                }
            }
        }
        int top = relativeObject.getAbsoluteTop();
        int windowTop = Window.getScrollTop();
        int windowBottom = Window.getScrollTop() + Window.getClientHeight();
        int distanceFromWindowTop = top - windowTop;
        int distanceToWindowBottom = windowBottom - (top + relativeObject.getOffsetHeight());
        top = distanceToWindowBottom < offsetHeight && distanceFromWindowTop >= offsetHeight ? (top -= offsetHeight) : (top += relativeObject.getOffsetHeight());
        this.setPopupPosition(left, top);
    }

    private void previewNativeEvent(Event.NativePreviewEvent event) {
        boolean eventTargetsPopupOrPartner;
        if (event.isCanceled() || !this.previewAllNativeEvents && event.isConsumed()) {
            if (this.modal) {
                event.cancel();
            }
            return;
        }
        this.onPreviewNativeEvent(event);
        if (event.isCanceled()) {
            return;
        }
        Event nativeEvent = Event.as(event.getNativeEvent());
        boolean bl = eventTargetsPopupOrPartner = this.eventTargetsPopup(nativeEvent) || this.eventTargetsPartner(nativeEvent);
        if (eventTargetsPopupOrPartner) {
            event.consume();
        }
        if (this.modal) {
            event.cancel();
        }
        int type = nativeEvent.getTypeInt();
        switch (type) {
            case 128: {
                if (!this.onKeyDownPreview((char)nativeEvent.getKeyCode(), KeyboardListenerCollection.getKeyboardModifiers(nativeEvent))) {
                    event.cancel();
                }
                return;
            }
            case 512: {
                if (!this.onKeyUpPreview((char)nativeEvent.getKeyCode(), KeyboardListenerCollection.getKeyboardModifiers(nativeEvent))) {
                    event.cancel();
                }
                return;
            }
            case 256: {
                if (!this.onKeyPressPreview((char)nativeEvent.getKeyCode(), KeyboardListenerCollection.getKeyboardModifiers(nativeEvent))) {
                    event.cancel();
                }
                return;
            }
            case 4: {
                if (DOM.getCaptureElement() != null) {
                    event.consume();
                    return;
                }
                if (eventTargetsPopupOrPartner || !this.autoHide) break;
                this.hide(true);
                return;
            }
            case 1: 
            case 2: 
            case 8: 
            case 64: {
                if (DOM.getCaptureElement() == null) break;
                event.consume();
                return;
            }
            case 2048: {
                com.google.gwt.dom.client.Element target = nativeEvent.getTarget();
                if (!this.modal || eventTargetsPopupOrPartner || target == null) break;
                this.blur(target);
                event.cancel();
                return;
            }
        }
    }

    private void setState(boolean showing, boolean maybeAnimate) {
        if (maybeAnimate) {
            this.resizeAnimation.setState(showing);
        } else {
            this.resizeAnimation.cancel();
        }
        this.showing = showing;
        if (showing) {
            this.nativePreviewHandlerRegistration = Event.addNativePreviewHandler(new Event.NativePreviewHandler(){

                public void onPreviewNativeEvent(Event.NativePreviewEvent event) {
                    PopupPanel.this.previewNativeEvent(event);
                }
            });
            this.historyHandlerRegistration = History.addValueChangeHandler(new ValueChangeHandler<String>(){

                @Override
                public void onValueChange(ValueChangeEvent<String> event) {
                    if (PopupPanel.this.autoHideOnHistoryEvents) {
                        PopupPanel.this.hide();
                    }
                }
            });
        } else {
            if (this.nativePreviewHandlerRegistration != null) {
                this.nativePreviewHandlerRegistration.removeHandler();
                this.nativePreviewHandlerRegistration = null;
            }
            if (this.historyHandlerRegistration != null) {
                this.historyHandlerRegistration.removeHandler();
                this.historyHandlerRegistration = null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum AnimationType {
        CENTER,
        ONE_WAY_CORNER,
        ROLL_DOWN;

    }

    public static interface PositionCallback {
        public void setPosition(int var1, int var2);
    }

    static class ResizeAnimation
    extends Animation {
        private PopupPanel curPanel = null;
        private int offsetHeight;
        private int offsetWidth = -1;
        private boolean showing;
        private boolean glassShowing;
        private HandlerRegistration resizeRegistration;

        public ResizeAnimation(PopupPanel panel) {
            this.curPanel = panel;
        }

        public void setState(boolean showing) {
            this.cancel();
            boolean animate = this.curPanel.isAnimationEnabled;
            if (this.curPanel.animType != AnimationType.CENTER && !showing) {
                animate = false;
            }
            this.showing = showing;
            if (animate) {
                if (showing) {
                    this.maybeShowGlass();
                    DOM.setStyleAttribute(this.curPanel.getElement(), "position", "absolute");
                    if (this.curPanel.topPosition != -1) {
                        this.curPanel.setPopupPosition(this.curPanel.leftPosition, this.curPanel.topPosition);
                    }
                    impl.setClip(this.curPanel.getElement(), this.getRectString(0, 0, 0, 0));
                    RootPanel.get().add(this.curPanel);
                    impl.onShow(this.curPanel.getElement());
                }
                DeferredCommand.addCommand(new Command(){

                    public void execute() {
                        ResizeAnimation.this.run(200);
                    }
                });
            } else {
                this.onInstantaneousRun();
            }
        }

        protected void onComplete() {
            if (!this.showing) {
                this.maybeShowGlass();
                RootPanel.get().remove(this.curPanel);
                impl.onHide(this.curPanel.getElement());
            }
            impl.setClip(this.curPanel.getElement(), "rect(auto, auto, auto, auto)");
            DOM.setStyleAttribute(this.curPanel.getElement(), "overflow", "visible");
        }

        protected void onStart() {
            this.offsetHeight = this.curPanel.getOffsetHeight();
            this.offsetWidth = this.curPanel.getOffsetWidth();
            DOM.setStyleAttribute(this.curPanel.getElement(), "overflow", "hidden");
            super.onStart();
        }

        protected void onUpdate(double progress) {
            if (!this.showing) {
                progress = 1.0 - progress;
            }
            int top = 0;
            int left = 0;
            int right = 0;
            int bottom = 0;
            int height = (int)(progress * (double)this.offsetHeight);
            int width = (int)(progress * (double)this.offsetWidth);
            switch (this.curPanel.animType) {
                case ROLL_DOWN: {
                    right = this.offsetWidth;
                    bottom = height;
                    break;
                }
                case CENTER: {
                    top = this.offsetHeight - height >> 1;
                    left = this.offsetWidth - width >> 1;
                    right = left + width;
                    bottom = top + height;
                    break;
                }
                case ONE_WAY_CORNER: {
                    if (LocaleInfo.getCurrentLocale().isRTL()) {
                        left = this.offsetWidth - width;
                    }
                    right = left + width;
                    bottom = top + height;
                }
            }
            impl.setClip(this.curPanel.getElement(), this.getRectString(top, right, bottom, left));
        }

        private String getRectString(int top, int right, int bottom, int left) {
            return "rect(" + top + "px, " + right + "px, " + bottom + "px, " + left + "px)";
        }

        private void maybeShowGlass() {
            if (this.showing) {
                if (this.curPanel.isGlassEnabled) {
                    Document.get().getBody().appendChild(this.curPanel.glass);
                    impl.onShow(this.curPanel.glass);
                    this.resizeRegistration = Window.addResizeHandler(this.curPanel.glassResizer);
                    this.curPanel.glassResizer.onResize(null);
                    this.glassShowing = true;
                }
            } else if (this.glassShowing) {
                Document.get().getBody().removeChild(this.curPanel.glass);
                impl.onHide(this.curPanel.glass);
                this.resizeRegistration.removeHandler();
                this.resizeRegistration = null;
                this.glassShowing = false;
            }
        }

        private void onInstantaneousRun() {
            this.maybeShowGlass();
            if (this.showing) {
                DOM.setStyleAttribute(this.curPanel.getElement(), "position", "absolute");
                if (this.curPanel.topPosition != -1) {
                    this.curPanel.setPopupPosition(this.curPanel.leftPosition, this.curPanel.topPosition);
                }
                RootPanel.get().add(this.curPanel);
                impl.onShow(this.curPanel.getElement());
            } else {
                RootPanel.get().remove(this.curPanel);
                impl.onHide(this.curPanel.getElement());
            }
            DOM.setStyleAttribute(this.curPanel.getElement(), "overflow", "visible");
        }
    }
}

