/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.rpc.impl;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.JsArray;
import com.google.gwt.core.client.JsArrayString;
import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.client.rpc.SerializationStreamReader;
import com.google.gwt.user.client.rpc.SerializationStreamWriter;
import com.google.gwt.user.client.rpc.impl.Serializer;
import java.util.IdentityHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SerializerBase
implements Serializer {
    private static final Map<JsArrayString, Map<Class<?>, String>> hostedSignatureMaps = GWT.isScript() ? null : new IdentityHashMap();

    protected static final void registerMethods(MethodMap methodMap, String signature, JsArray<JavaScriptObject> methods) {
        assert (signature != null) : "signature";
        assert (methodMap.get(signature) == null) : "Duplicate signature " + signature;
        methodMap.put(signature, methods);
    }

    protected static final void registerSignature(JsArrayString signatureMap, Class<?> clazz, String signature) {
        assert (clazz != null) : "clazz";
        assert (signature != null) : "signature";
        if (GWT.isScript()) {
            assert (signatureMap.get(clazz.hashCode()) == null) : "Duplicate signature " + signature;
            signatureMap.set(clazz.hashCode(), signature);
        } else {
            Map<Class<?>, String> subMap = SerializerBase.getSubMap(signatureMap);
            assert (!subMap.containsKey(clazz));
            subMap.put(clazz, signature);
        }
    }

    private static Map<Class<?>, String> getSubMap(JsArrayString signatureMap) {
        assert (!GWT.isScript()) : "Should only use this in hosted mode";
        Map<Class<?>, String> subMap = hostedSignatureMaps.get(signatureMap);
        if (subMap == null) {
            subMap = new IdentityHashMap();
            hostedSignatureMaps.put(signatureMap, subMap);
        }
        return subMap;
    }

    @Override
    public final void deserialize(SerializationStreamReader stream, Object instance, String typeSignature) throws SerializationException {
        this.check(typeSignature, 2);
        this.getMethodMap().deserialize(stream, instance, typeSignature);
    }

    @Override
    public final String getSerializationSignature(Class<?> clazz) {
        assert (clazz != null) : "clazz";
        if (GWT.isScript()) {
            return this.getSignatureMap().get(clazz.hashCode());
        }
        return SerializerBase.getSubMap(this.getSignatureMap()).get(clazz);
    }

    @Override
    public final Object instantiate(SerializationStreamReader stream, String typeSignature) throws SerializationException {
        this.check(typeSignature, 1);
        return this.getMethodMap().instantiate(stream, typeSignature);
    }

    @Override
    public final void serialize(SerializationStreamWriter stream, Object instance, String typeSignature) throws SerializationException {
        this.check(typeSignature, 3);
        this.getMethodMap().serialize(stream, instance, typeSignature);
    }

    protected abstract MethodMap getMethodMap();

    protected abstract JsArrayString getSignatureMap();

    private void check(String typeSignature, int length) throws SerializationException {
        if (this.getMethodMap().get(typeSignature) == null) {
            throw new SerializationException(typeSignature);
        }
        assert (this.getMethodMap().get(typeSignature).length() >= length) : "Not enough methods, expecting " + length + " saw " + this.getMethodMap().get(typeSignature).length();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class MethodMap
    extends JavaScriptObject {
        protected MethodMap() {
        }

        native void deserialize(SerializationStreamReader var1, Object var2, String var3) throws SerializationException;

        native JsArray<JavaScriptObject> get(String var1);

        native Object instantiate(SerializationStreamReader var1, String var2) throws SerializationException;

        native void put(String var1, JsArray<JavaScriptObject> var2);

        native void serialize(SerializationStreamWriter var1, Object var2, String var3) throws SerializationException;
    }
}

