/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.reviews.ui.compare;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import org.eclipse.compare.internal.MergeSourceViewer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationBarHoverManager;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.LineRange;
import org.eclipse.jface.text.source.OverviewRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.reviews.ui.actions.AddLineCommentToFileAction;
import org.eclipse.mylyn.internal.reviews.ui.annotations.CommentAnnotation;
import org.eclipse.mylyn.internal.reviews.ui.annotations.CommentAnnotationHover;
import org.eclipse.mylyn.internal.reviews.ui.annotations.CommentInformationControlCreator;
import org.eclipse.mylyn.internal.reviews.ui.annotations.IReviewCompareSourceViewer;
import org.eclipse.mylyn.internal.reviews.ui.annotations.ReviewAnnotationModel;
import org.eclipse.mylyn.internal.reviews.ui.compare.CompareUtil;
import org.eclipse.mylyn.internal.reviews.ui.editors.ruler.CommentAnnotationRulerColumn;
import org.eclipse.mylyn.reviews.core.model.IComment;
import org.eclipse.mylyn.reviews.core.model.ILineLocation;
import org.eclipse.mylyn.reviews.core.model.ILocation;
import org.eclipse.swt.custom.LineBackgroundEvent;
import org.eclipse.swt.custom.LineBackgroundListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.internal.texteditor.AnnotationColumn;
import org.eclipse.ui.internal.texteditor.PropertyEventDispatcher;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.AnnotationPreferenceLookup;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;

class ReviewCompareInputListener
implements ITextInputListener,
IReviewCompareSourceViewer {
    private AddLineCommentToFileAction addLineCommentAction;
    private final ReviewAnnotationModel annotationModel;
    private String initialText;
    private final MergeSourceViewer mergeSourceViewer;
    private final SourceViewer sourceViewer;

    ReviewCompareInputListener(MergeSourceViewer mergeSourceViewer, ReviewAnnotationModel annotationModel) {
        this.sourceViewer = CompareUtil.getSourceViewer(mergeSourceViewer);
        this.mergeSourceViewer = mergeSourceViewer;
        this.annotationModel = annotationModel;
    }

    @Override
    public void focusOnLines(ILocation range) {
        if (range instanceof ILineLocation) {
            IDocument document;
            ILineLocation lineLocation = (ILineLocation)range;
            int startLine = lineLocation.getRangeMin() - 1;
            int endLine = lineLocation.getRangeMax() - 1;
            if (this.sourceViewer != null && (document = this.sourceViewer.getDocument()) != null) {
                try {
                    int offset = document.getLineOffset(startLine);
                    int length = document.getLineOffset(endLine) - offset;
                    StyledText widget = this.sourceViewer.getTextWidget();
                    try {
                        widget.setRedraw(false);
                        this.sourceViewer.setSelection((ISelection)new TextSelection(offset, length), true);
                    }
                    finally {
                        widget.setRedraw(true);
                    }
                }
                catch (BadLocationException e) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.reviews.ui", e.getMessage(), (Throwable)e));
                }
            }
        }
    }

    public void forceCustomAnnotationHover() throws NoSuchFieldException, IllegalAccessException {
        Class<SourceViewer> sourceViewerClazz = SourceViewer.class;
        this.sourceViewer.setAnnotationHover((IAnnotationHover)new CommentAnnotationHover(null));
        try {
            Field hoverControlCreator = TextViewer.class.getDeclaredField("fHoverControlCreator");
            hoverControlCreator.setAccessible(true);
            hoverControlCreator.set(this.sourceViewer, new CommentInformationControlCreator());
        }
        catch (Throwable throwable) {}
        try {
            Method ensureMethod = sourceViewerClazz.getDeclaredMethod("ensureAnnotationHoverManagerInstalled", new Class[0]);
            ensureMethod.setAccessible(true);
            ensureMethod.invoke((Object)this.sourceViewer, new Object[0]);
        }
        catch (Throwable throwable) {}
        Field hoverManager = SourceViewer.class.getDeclaredField("fVerticalRulerHoveringController");
        hoverManager.setAccessible(true);
        AnnotationBarHoverManager manager = (AnnotationBarHoverManager)hoverManager.get(this.sourceViewer);
        if (manager != null) {
            Field annotationHover = AnnotationBarHoverManager.class.getDeclaredField("fAnnotationHover");
            annotationHover.setAccessible(true);
            IAnnotationHover hover = (IAnnotationHover)annotationHover.get(manager);
            annotationHover.set(manager, new CommentAnnotationHover(hover));
        }
        this.sourceViewer.showAnnotations(true);
        this.sourceViewer.showAnnotationsOverview(true);
    }

    @Override
    public ReviewAnnotationModel getAnnotationModel() {
        return this.annotationModel;
    }

    @Override
    public LineRange getSelection() {
        if (this.sourceViewer != null) {
            TextSelection selection = (TextSelection)this.sourceViewer.getSelection();
            return new LineRange(selection.getStartLine() + 1, selection.getEndLine() - selection.getStartLine());
        }
        return null;
    }

    public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
    }

    public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
        if (oldInput != null) {
            this.annotationModel.disconnect(oldInput);
        }
        if (newInput != null && this.sourceViewer != null) {
            IAnnotationModel originalAnnotationModel = this.sourceViewer.getAnnotationModel();
            try {
                Class<SourceViewer> sourceViewerClazz = SourceViewer.class;
                Field declaredField2 = sourceViewerClazz.getDeclaredField("fVisualAnnotationModel");
                declaredField2.setAccessible(true);
                Method declaredMethod = sourceViewerClazz.getDeclaredMethod("createVisualAnnotationModel", IAnnotationModel.class);
                declaredMethod.setAccessible(true);
                originalAnnotationModel = (IAnnotationModel)declaredMethod.invoke((Object)this.sourceViewer, this.annotationModel);
                declaredField2.set(this.sourceViewer, originalAnnotationModel);
                originalAnnotationModel.connect(newInput);
                this.sourceViewer.showAnnotations(true);
                this.createVerticalRuler(newInput, sourceViewerClazz);
                this.createOverviewRuler(newInput, sourceViewerClazz);
                this.createHighlighting(sourceViewerClazz);
            }
            catch (Throwable t) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.reviews.ui", "Error attaching annotation model", t));
            }
        }
    }

    public boolean isListenerFor(MergeSourceViewer viewer, ReviewAnnotationModel annotationModel) {
        return this.mergeSourceViewer == viewer && this.annotationModel == annotationModel;
    }

    @Override
    public void registerContextMenu() {
        this.addLineCommentAction = new AddLineCommentToFileAction(this);
        if (this.sourceViewer != null) {
            this.sourceViewer.addSelectionChangedListener((ISelectionChangedListener)this.addLineCommentAction);
        }
        this.mergeSourceViewer.addTextAction((IAction)this.addLineCommentAction);
    }

    private void createHighlighting(Class<SourceViewer> sourceViewerClazz) throws IllegalArgumentException, IllegalAccessException, SecurityException, NoSuchFieldException {
        StyledText styledText = this.sourceViewer.getTextWidget();
        styledText.addLineBackgroundListener((LineBackgroundListener)new ColoringLineBackgroundListener(styledText));
    }

    private void createOverviewRuler(IDocument newInput, Class<SourceViewer> sourceViewerClazz) throws SecurityException, NoSuchMethodException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        this.sourceViewer.setOverviewRulerAnnotationHover((IAnnotationHover)new CommentAnnotationHover(null));
        OverviewRuler ruler = new OverviewRuler((IAnnotationAccess)new DefaultMarkerAnnotationAccess(), 15, EditorsPlugin.getDefault().getSharedTextColors());
        Field compositeField = sourceViewerClazz.getDeclaredField("fComposite");
        compositeField.setAccessible(true);
        ruler.createControl((Composite)compositeField.get(this.sourceViewer), (ITextViewer)this.sourceViewer);
        ruler.setModel((IAnnotationModel)this.annotationModel);
        DefaultMarkerAnnotationAccess annotationAccess = new DefaultMarkerAnnotationAccess();
        final SourceViewerDecorationSupport support = new SourceViewerDecorationSupport((ISourceViewer)this.sourceViewer, (IOverviewRuler)ruler, (IAnnotationAccess)annotationAccess, EditorsUI.getSharedTextColors());
        Iterator e = new MarkerAnnotationPreferences().getAnnotationPreferences().iterator();
        while (e.hasNext()) {
            support.setAnnotationPreference((AnnotationPreference)e.next());
        }
        support.install(EditorsUI.getPreferenceStore());
        this.sourceViewer.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                support.dispose();
            }
        });
        Field overViewRulerField = sourceViewerClazz.getDeclaredField("fOverviewRuler");
        overViewRulerField.setAccessible(true);
        if (overViewRulerField.get(this.sourceViewer) == null) {
            overViewRulerField.set(this.sourceViewer, ruler);
        }
        Method declareMethod = sourceViewerClazz.getDeclaredMethod("ensureOverviewHoverManagerInstalled", new Class[0]);
        declareMethod.setAccessible(true);
        declareMethod.invoke((Object)this.sourceViewer, new Object[0]);
        Field hoverManager = sourceViewerClazz.getDeclaredField("fOverviewRulerHoveringController");
        hoverManager.setAccessible(true);
        AnnotationBarHoverManager manager = (AnnotationBarHoverManager)hoverManager.get(this.sourceViewer);
        if (manager != null) {
            Field annotationHover = AnnotationBarHoverManager.class.getDeclaredField("fAnnotationHover");
            annotationHover.setAccessible(true);
            IAnnotationHover cfr_ignored_0 = (IAnnotationHover)annotationHover.get(manager);
            annotationHover.set(manager, new CommentAnnotationHover(null));
        }
        this.sourceViewer.showAnnotations(true);
        this.sourceViewer.showAnnotationsOverview(true);
        declareMethod = sourceViewerClazz.getDeclaredMethod("showAnnotationsOverview", Boolean.TYPE);
        declareMethod.setAccessible(true);
    }

    private void createVerticalRuler(IDocument newInput, Class<SourceViewer> sourceViewerClazz) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, NoSuchFieldException {
        this.forceCustomAnnotationHover();
        Method declaredMethod2 = sourceViewerClazz.getDeclaredMethod("getVerticalRuler", new Class[0]);
        declaredMethod2.setAccessible(true);
        CompositeRuler ruler = (CompositeRuler)declaredMethod2.invoke((Object)this.sourceViewer, new Object[0]);
        boolean hasDecorator = false;
        Iterator iter = ruler.getDecoratorIterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof AnnotationColumn)) continue;
            hasDecorator = true;
        }
        if (!hasDecorator) {
            AnnotationColumn annotationColumn = new AnnotationColumn();
            annotationColumn.createControl(ruler, ruler.getControl().getParent());
            ruler.addDecorator(0, (IVerticalRulerColumn)annotationColumn);
        }
    }

    private final class ColoringLineBackgroundListener
    implements LineBackgroundListener {
        private Color colorCommented;
        private PropertyEventDispatcher fDispatcher;
        private final StyledText styledText;

        private ColoringLineBackgroundListener(StyledText styledText) {
            this.styledText = styledText;
            this.initialize();
        }

        public void lineGetBackground(LineBackgroundEvent event) {
            int lineNr = this.styledText.getLineAtOffset(event.lineOffset) + 1;
            Iterator<Annotation> it = ReviewCompareInputListener.this.annotationModel.getAnnotationIterator();
            while (it.hasNext()) {
                AnnotationPreference pref;
                ILocation location;
                IComment comment;
                Annotation annotation = it.next();
                if (!(annotation instanceof CommentAnnotation) || (comment = ((CommentAnnotation)annotation).getComment()).getLocations().size() != 1 || !((location = (ILocation)comment.getLocations().get(0)) instanceof ILineLocation)) continue;
                ILineLocation lineLocation = (ILineLocation)location;
                int startLine = lineLocation.getRangeMin();
                int endLine = lineLocation.getRangeMax();
                if (lineNr < startLine || lineNr > endLine || !(pref = new AnnotationPreferenceLookup().getAnnotationPreference(annotation)).getHighlightPreferenceValue()) continue;
                event.lineBackground = this.colorCommented;
            }
        }

        private int getDocumentOffset(LineBackgroundEvent event) {
            if (event.widget instanceof StyledText) {
                String currentText = ((StyledText)event.widget).getText();
                if (ReviewCompareInputListener.this.initialText == null) {
                    ReviewCompareInputListener.this.initialText = currentText;
                    return 0;
                }
                if (currentText.equals(ReviewCompareInputListener.this.initialText)) {
                    return 0;
                }
                if (ReviewCompareInputListener.this.initialText.contains(currentText)) {
                    int charoffset = ReviewCompareInputListener.this.initialText.indexOf(currentText);
                    int lineOffset = 0;
                    String delimiter = ((StyledText)event.widget).getLineDelimiter();
                    String[] stringArray = ReviewCompareInputListener.this.initialText.split(delimiter);
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String line = stringArray[n2];
                        if (charoffset <= 0) break;
                        charoffset -= line.length() + delimiter.length();
                        ++lineOffset;
                        ++n2;
                    }
                    return lineOffset;
                }
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.reviews.ui", "Could not find text offset for annotation highlighting - current text not contained in initial text."));
            }
            return 0;
        }

        private void initialize() {
            final IPreferenceStore store = EditorsUI.getPreferenceStore();
            if (store == null) {
                return;
            }
            AnnotationPreferenceLookup lookup = EditorsUI.getAnnotationPreferenceLookup();
            final AnnotationPreference commentedPref = lookup.getAnnotationPreference("org.eclipse.mylyn.reviews.ui.comment.Annotation");
            this.updateCommentedColor(commentedPref, store);
            this.fDispatcher = new PropertyEventDispatcher(store);
            if (commentedPref != null) {
                this.fDispatcher.addPropertyChangeListener(commentedPref.getColorPreferenceKey(), new IPropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent event) {
                        ColoringLineBackgroundListener.this.updateCommentedColor(commentedPref, store);
                    }
                });
            }
        }

        private void updateCommentedColor(AnnotationPreference pref, IPreferenceStore store) {
            if (pref != null) {
                RGB rgb = CommentAnnotationRulerColumn.getColorFromAnnotationPreference(store, pref);
                this.colorCommented = EditorsUI.getSharedTextColors().getColor(rgb);
            }
        }
    }
}

