/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.ui.spi.editor;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mylyn.reviews.core.model.IComment;
import org.eclipse.mylyn.reviews.core.model.IFileItem;
import org.eclipse.mylyn.reviews.core.model.ILocation;
import org.eclipse.mylyn.reviews.core.model.IReviewItemSet;

final class ReviewSetContentProvider
implements ITreeContentProvider {
    private final Multimap<ILocation, IComment> threads = LinkedHashMultimap.create();
    private final Multimap<String, ILocation> threadLocationsByFile = LinkedHashMultimap.create();

    ReviewSetContentProvider() {
    }

    public Object[] getElements(Object inputElement) {
        return this.getReviewItems(inputElement).toArray();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void dispose() {
        this.threads.clear();
        this.threadLocationsByFile.clear();
    }

    public boolean hasChildren(Object element) {
        return !this.getFileComments(element).isEmpty() || element instanceof ILocation;
    }

    public Object getParent(Object element) {
        return null;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IFileItem) {
            IFileItem file = (IFileItem)parentElement;
            ImmutableListMultimap commentsByLocation = Multimaps.index(this.getFileComments(file), this.commentLineNumber());
            for (ILocation location : this.threadLocationsByFile.get((Object)file.getId())) {
                this.threads.removeAll((Object)location);
            }
            this.threadLocationsByFile.removeAll((Object)file.getId());
            for (Long line : commentsByLocation.keySet()) {
                ILocation location = null;
                for (IComment comment : commentsByLocation.get((Object)line)) {
                    if (location == null) {
                        location = (ILocation)comment.getLocations().iterator().next();
                        this.threadLocationsByFile.put((Object)file.getId(), (Object)location);
                    }
                    if (this.threads.containsValue((Object)comment)) continue;
                    this.threads.put((Object)location, (Object)comment);
                }
            }
            Collection relevantThreads = this.threadLocationsByFile.get((Object)file.getId());
            Object[] locations = relevantThreads.toArray(new ILocation[relevantThreads.size()]);
            Arrays.sort(locations, this.lineNumberComparator());
            return locations;
        }
        if (parentElement instanceof ILocation) {
            return this.threads.get((Object)((ILocation)parentElement)).toArray();
        }
        return new Object[0];
    }

    private Comparator<ILocation> lineNumberComparator() {
        return new Comparator<ILocation>(){

            @Override
            public int compare(ILocation o1, ILocation o2) {
                return (int)(o1.getIndex() - o2.getIndex());
            }
        };
    }

    private Function<? super IComment, Long> commentLineNumber() {
        return new Function<IComment, Long>(){

            public Long apply(IComment comment) {
                return ((ILocation)comment.getLocations().iterator().next()).getIndex();
            }
        };
    }

    private Predicate<IComment> hasLocation() {
        return new Predicate<IComment>(){

            public boolean apply(IComment input) {
                return input.getLocations().iterator().hasNext();
            }
        };
    }

    private List<IFileItem> getReviewItems(Object inputElement) {
        if (inputElement instanceof IReviewItemSet) {
            return ((IReviewItemSet)inputElement).getItems();
        }
        return ImmutableList.of();
    }

    private List<IComment> getFileComments(Object inputElement) {
        if (inputElement instanceof IFileItem) {
            return FluentIterable.from((Iterable)((IFileItem)inputElement).getAllComments()).filter(this.hasLocation()).toList();
        }
        return ImmutableList.of();
    }
}

