/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.LocalTask;
import org.eclipse.mylyn.internal.tasks.core.ScheduledTaskContainer;
import org.eclipse.mylyn.internal.tasks.ui.AbstractTaskListFilter;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskContainer;
import org.eclipse.ui.IWorkingSet;

public class TaskWorkingSetFilter
extends AbstractTaskListFilter {
    private IAdaptable[] elements;

    @Override
    public boolean select(Object parent, Object element) {
        Iterator iterator;
        if (parent instanceof ITask) {
            return true;
        }
        if (parent == null && element instanceof ScheduledTaskContainer) {
            return true;
        }
        if (parent == null && element instanceof IRepositoryElement) {
            return this.isContainedInWorkingSet((IRepositoryElement)element);
        }
        if (parent instanceof ITaskContainer && !(parent instanceof ScheduledTaskContainer)) {
            return this.isContainedInWorkingSet((IRepositoryElement)parent);
        }
        if (element instanceof LocalTask && (iterator = ((LocalTask)element).getParentContainers().iterator()).hasNext()) {
            IRepositoryElement container = (IRepositoryElement)iterator.next();
            return this.isContainedInWorkingSet(container);
        }
        if (parent instanceof ScheduledTaskContainer && element instanceof ITask) {
            for (IRepositoryElement query : ((AbstractTask)element).getParentContainers()) {
                if (!this.isContainedInWorkingSet(query)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean select(ITask task) {
        for (IRepositoryElement query : ((AbstractTask)task).getParentContainers()) {
            if (!this.isContainedInWorkingSet(query)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean applyToFilteredText() {
        return true;
    }

    private boolean isContainedInWorkingSet(IRepositoryElement element) {
        return this.isContainedInWorkingSet(element, new HashSet<IRepositoryElement>());
    }

    private boolean isContainedInWorkingSet(IRepositoryElement container, Set<IRepositoryElement> visited) {
        if (this.elements == null) {
            return true;
        }
        if (visited.contains(container)) {
            return false;
        }
        visited.add(container);
        boolean seenTaskWorkingSets = false;
        String handleIdentifier = container.getHandleIdentifier();
        IAdaptable[] iAdaptableArray = this.elements;
        int n = this.elements.length;
        int n2 = 0;
        while (n2 < n) {
            IAdaptable adaptable = iAdaptableArray[n2];
            if (adaptable instanceof IRepositoryElement) {
                seenTaskWorkingSets = true;
                if (handleIdentifier.equals(((IRepositoryElement)adaptable).getHandleIdentifier())) {
                    return true;
                }
                if (container instanceof AbstractTask) {
                    for (AbstractTaskContainer parent : ((AbstractTask)container).getParentContainers()) {
                        if (visited.contains(parent) || !this.isContainedInWorkingSet((IRepositoryElement)parent, visited)) continue;
                        return true;
                    }
                }
            }
            ++n2;
        }
        return !seenTaskWorkingSets;
    }

    public boolean updateWorkingSet(IWorkingSet currentWorkingSet) {
        Object[] newElements = currentWorkingSet.getElements();
        if (!Arrays.equals(this.elements, newElements)) {
            this.elements = newElements;
            return true;
        }
        return false;
    }

    public IAdaptable[] getElements() {
        return this.elements;
    }
}

