/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.commons.workbench.CommonImageManger;
import org.eclipse.mylyn.internal.tasks.ui.editors.AttachmentSizeFormatter;
import org.eclipse.mylyn.internal.tasks.ui.editors.EditorUtil;
import org.eclipse.mylyn.internal.tasks.ui.editors.Messages;
import org.eclipse.mylyn.internal.tasks.ui.util.AttachmentUtil;
import org.eclipse.mylyn.tasks.core.IRepositoryPerson;
import org.eclipse.mylyn.tasks.core.ITaskAttachment;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskDataModel;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.tasks.ui.editors.AttributeEditorToolkit;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.themes.IThemeManager;

public class AttachmentTableLabelProvider
extends ColumnLabelProvider {
    private final AttachmentSizeFormatter sizeFormatter = AttachmentSizeFormatter.getInstance();
    private final TaskDataModel model;
    private final AttributeEditorToolkit attributeEditorToolkit;
    private final CommonImageManger imageManager;

    public AttachmentTableLabelProvider(TaskDataModel model, AttributeEditorToolkit attributeEditorToolkit) {
        this.model = model;
        this.attributeEditorToolkit = attributeEditorToolkit;
        this.imageManager = new CommonImageManger();
    }

    public Image getColumnImage(Object element, int columnIndex) {
        ITaskAttachment attachment = (ITaskAttachment)element;
        if (columnIndex == 0) {
            if (AttachmentUtil.isContext(attachment)) {
                return this.imageManager.getImage(TasksUiImages.CONTEXT_TRANSFER);
            }
            if (attachment.isPatch()) {
                return this.imageManager.getImage(TasksUiImages.TASK_ATTACHMENT_PATCH);
            }
            return this.imageManager.getFileImage(attachment.getFileName());
        }
        if (columnIndex == 3 && attachment.getAuthor() != null) {
            return this.getAuthorImage(attachment.getAuthor(), attachment.getTaskRepository());
        }
        return null;
    }

    protected Image getAuthorImage(IRepositoryPerson person, TaskRepository repository) {
        if (repository != null && person != null && person.matchesUsername(repository.getUserName())) {
            return this.imageManager.getImage(CommonImages.PERSON_ME);
        }
        return this.imageManager.getImage(CommonImages.PERSON);
    }

    public String getColumnText(Object element, int columnIndex) {
        ITaskAttachment attachment = (ITaskAttachment)element;
        switch (columnIndex) {
            case 0: {
                if (AttachmentUtil.isContext(attachment)) {
                    return Messages.AttachmentTableLabelProvider_Task_Context;
                }
                if (attachment.isPatch()) {
                    return Messages.AttachmentTableLabelProvider_Patch;
                }
                return " " + attachment.getFileName();
            }
            case 1: {
                return attachment.getDescription();
            }
            case 2: {
                Long length = attachment.getLength();
                if (length < 0L) {
                    return "-";
                }
                return this.sizeFormatter.format(length);
            }
            case 3: {
                return attachment.getAuthor() != null ? attachment.getAuthor().toString() : "";
            }
            case 4: {
                return attachment.getCreationDate() != null ? EditorUtil.formatDateTime(attachment.getCreationDate()) : "";
            }
            case 5: {
                return AttachmentTableLabelProvider.getAttachmentId(attachment);
            }
        }
        return "unrecognized column";
    }

    static String getAttachmentId(ITaskAttachment attachment) {
        int i;
        String a = attachment.getUrl();
        if (a != null && (i = a.indexOf("?id=")) != -1) {
            return a.substring(i + 4);
        }
        return "";
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
        this.imageManager.dispose();
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Color getForeground(Object element) {
        ITaskAttachment att = (ITaskAttachment)element;
        if (att.isDeprecated()) {
            IThemeManager themeManager = PlatformUI.getWorkbench().getThemeManager();
            return themeManager.getCurrentTheme().getColorRegistry().get("org.eclipse.mylyn.tasks.ui.colors.foreground.completed");
        }
        return super.getForeground(element);
    }

    public String getToolTipText(Object element) {
        ITaskAttachment attachment = (ITaskAttachment)element;
        StringBuilder sb = new StringBuilder();
        sb.append(Messages.AttachmentTableLabelProvider_File_);
        sb.append(attachment.getFileName());
        if (attachment.getContentType() != null) {
            sb.append("\n");
            sb.append(Messages.AttachmentTableLabelProvider_Type_);
            sb.append(attachment.getContentType());
        }
        return sb.toString();
    }

    public Point getToolTipShift(Object object) {
        return new Point(5, 5);
    }

    public int getToolTipDisplayDelayTime(Object object) {
        return 200;
    }

    public int getToolTipTimeDisplayed(Object object) {
        return 5000;
    }

    public void update(ViewerCell cell) {
        Object element = cell.getElement();
        cell.setText(this.getColumnText(element, cell.getColumnIndex()));
        Image image = this.getColumnImage(element, cell.getColumnIndex());
        cell.setImage(image);
        cell.setBackground(this.getBackground(element));
        cell.setForeground(this.getForeground(element));
        cell.setFont(this.getFont(element));
    }

    public Color getBackground(Object element) {
        ITaskAttachment attachment;
        if (this.model != null && this.attributeEditorToolkit != null && this.model.hasIncomingChanges((attachment = (ITaskAttachment)element).getTaskAttribute())) {
            return this.attributeEditorToolkit.getColorIncoming();
        }
        return null;
    }
}

