/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.trac.core;

import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.internal.trac.core.Messages;
import org.eclipse.mylyn.internal.trac.core.TracCorePlugin;
import org.eclipse.mylyn.internal.trac.core.TracRepositoryConnector;
import org.eclipse.mylyn.internal.trac.core.client.AbstractWikiHandler;
import org.eclipse.mylyn.internal.trac.core.client.ITracClient;
import org.eclipse.mylyn.internal.trac.core.client.ITracWikiClient;
import org.eclipse.mylyn.internal.trac.core.client.TracException;
import org.eclipse.mylyn.internal.trac.core.model.TracWikiPage;
import org.eclipse.mylyn.internal.trac.core.model.TracWikiPageInfo;
import org.eclipse.mylyn.tasks.core.TaskRepository;

public class TracWikiHandler
extends AbstractWikiHandler {
    private final TracRepositoryConnector connector;

    public TracWikiHandler(TracRepositoryConnector connector) {
        this.connector = connector;
    }

    @Override
    public String[] downloadAllPageNames(TaskRepository repository, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(Messages.TracWikiHandler_Download_Wiki_Page_Names, -1);
        try {
            String[] names;
            String[] stringArray = names = this.getTracWikiClient(repository).getAllWikiPageNames(monitor);
            return stringArray;
        }
        catch (TracException e) {
            throw new CoreException(TracCorePlugin.toStatus(e, repository));
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public TracWikiPage getWikiPage(TaskRepository repository, String pageName, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(Messages.TracWikiHandler_Download_Wiki_Page, -1);
        try {
            TracWikiPage page;
            TracWikiPage tracWikiPage = page = this.getTracWikiClient(repository).getWikiPage(pageName, monitor);
            return tracWikiPage;
        }
        catch (TracException e) {
            throw new CoreException(TracCorePlugin.toStatus(e, repository));
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void postWikiPage(TaskRepository repository, TracWikiPage newPage, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(Messages.TracWikiHandler_Upload_Wiki_Page, -1);
        try {
            String pageName = newPage.getPageInfo().getPageName();
            String content = newPage.getContent();
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("comment", newPage.getPageInfo().getComment());
            attributes.put("author", newPage.getPageInfo().getAuthor());
            boolean success = this.getTracWikiClient(repository).putWikipage(pageName, content, attributes, monitor);
            if (success) {
                return;
            }
            try {
                throw new CoreException(TracCorePlugin.toStatus(new TracException("Failed to upload wiki page. No further information available."), repository));
            }
            catch (TracException e) {
                throw new CoreException(TracCorePlugin.toStatus(e, repository));
            }
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public TracWikiPageInfo[] getPageHistory(TaskRepository repository, String pageName, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(Messages.TracWikiHandler_Retrieve_Wiki_Page_History, -1);
        try {
            TracWikiPageInfo[] versions;
            TracWikiPageInfo[] tracWikiPageInfoArray = versions = this.getTracWikiClient(repository).getWikiPageInfoAllVersions(pageName, monitor);
            return tracWikiPageInfoArray;
        }
        catch (TracException e) {
            throw new CoreException(TracCorePlugin.toStatus(e, repository));
        }
        finally {
            monitor.done();
        }
    }

    private ITracWikiClient getTracWikiClient(TaskRepository repository) throws TracException {
        ITracClient client = this.connector.getClientManager().getTracClient(repository);
        if (client instanceof ITracWikiClient) {
            return (ITracWikiClient)((Object)client);
        }
        throw new TracException("The access mode of " + repository.toString() + " does not support Wiki page editting.");
    }

    @Override
    public String getWikiUrl(TaskRepository repository) {
        return String.valueOf(repository.getRepositoryUrl()) + "/wiki/";
    }
}

