/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.textile.core;

import java.io.StringWriter;
import java.io.Writer;
import org.eclipse.mylyn.internal.wikitext.textile.core.TextileDocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.ListAttributes;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TextileDocumentBuilderDefinitionListTest {
    private TextileDocumentBuilder builder;
    private StringWriter out;

    @Before
    public void initBuilder() {
        this.out = new StringWriter();
        this.builder = new TextileDocumentBuilder((Writer)this.out);
    }

    @Test
    public void simple() {
        this.builder.beginDocument();
        this.beginDl();
        this.dtDd("a term", "a definition");
        this.endDl();
        this.builder.endDocument();
        Assert.assertEquals((Object)"- a term := a definition\n", (Object)this.out.toString());
    }

    @Test
    public void twoEntries() {
        this.builder.beginDocument();
        this.beginDl();
        this.dtDd("a term", "a definition");
        this.dtDd("term2", "definition2");
        this.endDl();
        this.builder.endDocument();
        Assert.assertEquals((Object)"- a term := a definition\n- term2 := definition2\n", (Object)this.out.toString());
    }

    @Test
    public void multiLineEntry() {
        this.builder.beginDocument();
        this.beginDl();
        this.dt("a multi line entry");
        this.beginDd();
        this.builder.characters("line one");
        this.builder.lineBreak();
        this.builder.characters("line two");
        this.endDd();
        this.endDl();
        this.builder.endDocument();
        Assert.assertEquals((Object)"- a multi line entry := line one\nline two =:\n", (Object)this.out.toString());
    }

    protected void dtDd(String term, String definition) {
        this.dt(term);
        this.beginDd();
        this.builder.characters(definition);
        this.endDd();
    }

    protected void dt(String term) {
        this.beginDt();
        this.builder.characters(term);
        this.endDt();
    }

    private void endDd() {
        this.builder.endBlock();
    }

    private void beginDd() {
        this.builder.beginBlock(DocumentBuilder.BlockType.DEFINITION_ITEM, new Attributes());
    }

    private void endDt() {
        this.builder.endBlock();
    }

    private void beginDt() {
        this.builder.beginBlock(DocumentBuilder.BlockType.DEFINITION_TERM, new Attributes());
    }

    protected void endDl() {
        this.builder.endBlock();
    }

    protected void beginDl() {
        this.builder.beginBlock(DocumentBuilder.BlockType.DEFINITION_LIST, (Attributes)new ListAttributes());
    }
}

