/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.textile.core.phrase;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.internal.wikitext.textile.core.phrase.TagEscapeTextilePhraseModifier;
import org.junit.Assert;
import org.junit.Test;

public class TagEscapeTextilePhraseModifierTest {
    @Test
    public void matches() {
        this.assertMatch(0, "a", "<notextile>a</notextile>");
        this.assertMatch(1, "a", " <notextile>a</notextile>");
        this.assertMatch(0, "", "<notextile></notextile>");
        this.assertMatch(5, "*MyType==[1]==*", "asdf <notextile>*MyType==[1]==*</notextile>");
    }

    private void assertMatch(int offset, String content, String markup) {
        String regex = new TagEscapeTextilePhraseModifier().getPattern(0);
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(markup);
        Assert.assertTrue((boolean)matcher.find());
        Assert.assertEquals((long)offset, (long)matcher.start());
        Assert.assertEquals((Object)content, (Object)matcher.group(1));
    }
}

