/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.twiki.core.validation;

import junit.framework.TestCase;
import org.eclipse.mylyn.internal.wikitext.twiki.core.validation.ListWhitespaceValidationRule;
import org.eclipse.mylyn.wikitext.core.validation.ValidationProblem;

public class ListWhitespaceValidationRuleTest
extends TestCase {
    private ListWhitespaceValidationRule rule;

    protected void setUp() throws Exception {
        super.setUp();
        this.rule = new ListWhitespaceValidationRule();
    }

    public void testNegativeMatch() {
        String markup = "some text\n\n   * a valid list item\n      * another valid list item\n\nmore text";
        ValidationProblem problem = this.rule.findProblem(markup, 0, markup.length());
        ListWhitespaceValidationRuleTest.assertNull((Object)problem);
    }

    public void testPositiveMatchSecondItemNotMultipleOf3() {
        String markup = "some text\n\n   * a valid list item\n     * not a list item\n\nmore text";
        ValidationProblem problem = this.rule.findProblem(markup, 0, markup.length());
        ListWhitespaceValidationRuleTest.assertNotNull((Object)problem);
        ListWhitespaceValidationRuleTest.assertEquals((int)34, (int)problem.getOffset());
    }

    public void testPositiveMatchSecondItemTab() {
        String markup = "some text\n\n   * a valid list item\n \t    * not a list item\n\nmore text";
        ValidationProblem problem = this.rule.findProblem(markup, 0, markup.length());
        ListWhitespaceValidationRuleTest.assertNotNull((Object)problem);
        ListWhitespaceValidationRuleTest.assertEquals((int)34, (int)problem.getOffset());
    }

    public void testPositiveMatchFirstItemNotMultipleOf3() {
        String markup = "some text\n\n  * a bad list item\n      * not a list item\n\nmore text";
        ValidationProblem problem = this.rule.findProblem(markup, 0, markup.length());
        ListWhitespaceValidationRuleTest.assertNotNull((Object)problem);
        ListWhitespaceValidationRuleTest.assertEquals((int)11, (int)problem.getOffset());
    }

    public void testPositiveMatchStartOfLine() {
        String markup = "some text\n\n* a bad list item";
        ValidationProblem problem = this.rule.findProblem(markup, 0, markup.length());
        ListWhitespaceValidationRuleTest.assertNotNull((Object)problem);
        ListWhitespaceValidationRuleTest.assertEquals((int)11, (int)problem.getOffset());
    }

    public void testPositiveMatchStartOfInput() {
        String markup = "* a bad list item";
        ValidationProblem problem = this.rule.findProblem(markup, 0, markup.length());
        ListWhitespaceValidationRuleTest.assertNotNull((Object)problem);
        ListWhitespaceValidationRuleTest.assertEquals((int)0, (int)problem.getOffset());
    }

    public void testPositiveMatchNoFollowingWhitespace() {
        String markup = "   *a bad list item";
        ValidationProblem problem = this.rule.findProblem(markup, 0, markup.length());
        ListWhitespaceValidationRuleTest.assertNotNull((Object)problem);
        ListWhitespaceValidationRuleTest.assertEquals((int)0, (int)problem.getOffset());
    }

    public void testNegativeMatchNumeric() {
        String markup = "some text\n\n   1. a valid list item\n      1. another valid list item\n\nmore text";
        ValidationProblem problem = this.rule.findProblem(markup, 0, markup.length());
        ListWhitespaceValidationRuleTest.assertNull((Object)problem);
    }

    public void testPositiveMatchNumeric() {
        String markup = "some text\n\n  1. a bad list item\n      1. another valid list item\n\nmore text";
        ValidationProblem problem = this.rule.findProblem(markup, 0, markup.length());
        ListWhitespaceValidationRuleTest.assertNotNull((Object)problem);
        ListWhitespaceValidationRuleTest.assertEquals((int)11, (int)problem.getOffset());
    }
}

