/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.ui.registry;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.eclipse.core.runtime.Platform;
import org.eclipse.mylyn.internal.wikitext.ui.WikiTextUiPlugin;
import org.eclipse.mylyn.internal.wikitext.ui.registry.EclipseServiceLocator;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.core.util.ServiceLocator;
import org.eclipse.mylyn.wikitext.tests.EclipseRuntimeRequired;
import org.eclipse.mylyn.wikitext.ui.WikiText;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@EclipseRuntimeRequired
public class EclipseServiceLocatorTest {
    @Before
    public void before() {
        Assert.assertTrue((String)"platform must be running for this test", (boolean)Platform.isRunning());
        Assert.assertNotNull((Object)WikiTextUiPlugin.getDefault());
    }

    @Test
    public void instance() {
        ServiceLocator instance = ServiceLocator.getInstance();
        Assert.assertTrue((String)instance.getClass().getName(), (boolean)(instance instanceof EclipseServiceLocator));
    }

    @Test
    public void getAllMarkupLanguages() {
        Set allMarkupLanguages = ServiceLocator.getInstance().getAllMarkupLanguages();
        ImmutableSet names = ImmutableSet.copyOf((Iterable)FluentIterable.from((Iterable)allMarkupLanguages).transform((Function)new Function<MarkupLanguage, String>(){

            public String apply(MarkupLanguage language) {
                return language.getName();
            }
        }));
        Assert.assertEquals((Object)WikiText.getMarkupLanguageNames(), (Object)names);
    }
}

