/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.ui.viewer;

import org.eclipse.swt.graphics.RGB;

public class FontState {
    public static final int STATE_BOLD = 1;
    public static final int STATE_ITALIC = 2;
    public static final int STATE_STRIKETHROUGH = 4;
    public static final int STATE_UNDERLINE = 8;
    public static final int STATE_SUPERSCRIPT = 16;
    public static final int STATE_SUBSCRIPT = 32;
    public static final int STATE_FIXED_WIDTH = 64;
    public RGB foreground;
    public RGB background;
    public int state;
    public float sizeFactor = 1.0f;

    public FontState() {
    }

    public FontState(FontState copy) {
        this.foreground = copy.foreground;
        this.background = copy.background;
        this.state = copy.state;
        this.sizeFactor = copy.sizeFactor;
    }

    public boolean isBold() {
        return this.isSet(1);
    }

    public boolean isItalic() {
        return this.isSet(2);
    }

    public boolean isStrikethrough() {
        return this.isSet(4);
    }

    public boolean isUnderline() {
        return this.isSet(8);
    }

    public boolean isSuperscript() {
        return this.isSet(16);
    }

    public boolean isSubscript() {
        return this.isSet(32);
    }

    public boolean isFixedWidth() {
        return this.isSet(64);
    }

    public void setBold(boolean bold) {
        this.set(bold, 1);
    }

    public void setItalic(boolean value) {
        this.set(value, 2);
    }

    public void setStrikethrough(boolean value) {
        this.set(value, 4);
    }

    public void setUnderline(boolean value) {
        this.set(value, 8);
    }

    public void setSuperscript(boolean value) {
        this.set(value, 16);
    }

    public void setSubscript(boolean value) {
        this.set(value, 32);
    }

    public void setFixedWidth(boolean value) {
        this.set(value, 64);
    }

    private boolean isSet(int bits) {
        return (this.state & bits) == bits;
    }

    private void set(boolean value, int bits) {
        this.state = value ? (this.state |= bits) : (this.state &= ~bits);
    }

    public RGB getForeground() {
        return this.foreground;
    }

    public void setForeground(RGB foreground) {
        this.foreground = foreground;
    }

    public RGB getBackground() {
        return this.background;
    }

    public void setBackground(RGB background) {
        this.background = background;
    }

    public float getSizeFactor() {
        return this.sizeFactor;
    }

    public void setSizeFactor(float sizeFactor) {
        this.sizeFactor = sizeFactor;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.background == null ? 0 : this.background.hashCode());
        result = 31 * result + (this.foreground == null ? 0 : this.foreground.hashCode());
        result = 31 * result + Float.floatToIntBits(this.sizeFactor);
        result = 31 * result + this.state;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FontState other = (FontState)obj;
        if (this.background == null ? other.background != null : !this.background.equals((Object)other.background)) {
            return false;
        }
        if (this.foreground == null ? other.foreground != null : !this.foreground.equals((Object)other.foreground)) {
            return false;
        }
        if (Float.floatToIntBits(this.sizeFactor) != Float.floatToIntBits(other.sizeFactor)) {
            return false;
        }
        return this.state == other.state;
    }
}

