/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests;

import junit.framework.TestCase;
import org.eclipse.mylyn.internal.tasks.core.CommentQuoter;

public class CommentQuoterTest
extends TestCase {
    public void testNoWrapping() {
        CommentQuoter quoter = new CommentQuoter(10);
        String quotedText = quoter.quote("bababa");
        CommentQuoterTest.assertEquals((String)"> bababa\n", (String)quotedText);
    }

    public void testSimpleWrapping() {
        CommentQuoter quoter = new CommentQuoter(10);
        String quotedText = quoter.quote("bababa bobobo");
        CommentQuoterTest.assertEquals((String)"> bababa\n> bobobo\n", (String)quotedText);
    }

    public void testNoWayToWrap() {
        CommentQuoter quoter = new CommentQuoter(10);
        String quotedText = quoter.quote("babababababa");
        CommentQuoterTest.assertEquals((String)"> babababababa\n", (String)quotedText);
    }

    public void testExactWrap() {
        CommentQuoter quoter = new CommentQuoter(10);
        String quotedText = quoter.quote("bababababa");
        CommentQuoterTest.assertEquals((String)"> bababababa\n", (String)quotedText);
    }

    public void testMultiLineNoWrapping() {
        CommentQuoter quoter = new CommentQuoter(10);
        String quotedText = quoter.quote("bababa\nbobobo");
        CommentQuoterTest.assertEquals((String)"> bababa\n> bobobo\n", (String)quotedText);
    }

    public void testMultiLineWithWrapping() {
        CommentQuoter quoter = new CommentQuoter(10);
        String quotedText = quoter.quote("bababa bebebe\nbibibibibibi bibi\nbobobo bububu");
        CommentQuoterTest.assertEquals((String)"> bababa\n> bebebe\n> bibibibibibi\n> bibi\n> bobobo\n> bububu\n", (String)quotedText);
    }

    public void testExcessiveSpacingWrapping() {
        CommentQuoter quoter = new CommentQuoter(10);
        String quotedText = quoter.quote("bababa        bobobo");
        CommentQuoterTest.assertEquals((String)"> bababa\n> bobobo\n", (String)quotedText);
    }

    public void testBlankLineQuoting() {
        CommentQuoter quoter = new CommentQuoter(10);
        String quotedText = quoter.quote("bababa\n\nbobobo");
        CommentQuoterTest.assertEquals((String)"> bababa\n> \n> bobobo\n", (String)quotedText);
    }
}

