/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests.ui;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.internal.tasks.core.ITaskJobFactory;
import org.eclipse.mylyn.internal.tasks.ui.TaskListSynchronizationScheduler;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.sync.ISynchronizationSession;
import org.eclipse.mylyn.tasks.tests.TaskTestUtil;
import org.eclipse.mylyn.tasks.tests.connector.MockRepositoryConnector;

public class TaskListSynchronizationSchedulerTest
extends TestCase {
    private TaskRepository repository;
    private TestConnector connector;
    private AbstractRepositoryConnector oldConnector;
    private final CountDownLatch mainLatch = new CountDownLatch(1);

    protected void setUp() throws Exception {
        TasksUiPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.mylyn.tasks.ui.repositories.synch.schedule", false);
        TaskTestUtil.resetTaskListAndRepositories();
        this.repository = TaskTestUtil.createMockRepository();
        TasksUiPlugin.getRepositoryManager().addRepository(this.repository);
        this.oldConnector = TasksUiPlugin.getRepositoryManager().removeRepositoryConnector(this.repository.getConnectorKind());
        this.connector = new TestConnector();
        TasksUiPlugin.getRepositoryManager().addRepositoryConnector((AbstractRepositoryConnector)this.connector);
    }

    protected void tearDown() throws Exception {
        this.release();
        TasksUiPlugin.getRepositoryManager().removeRepositoryConnector(this.repository.getConnectorKind());
        TasksUiPlugin.getRepositoryManager().addRepositoryConnector(this.oldConnector);
    }

    public void testSynchronization() throws Exception {
        TaskListSynchronizationScheduler scheduler = new TaskListSynchronizationScheduler((ITaskJobFactory)TasksUiPlugin.getTaskJobFactory());
        try {
            scheduler.setInterval(1L);
            TaskListSynchronizationSchedulerTest.assertTrue((boolean)this.connector.latch.await(10L, TimeUnit.SECONDS));
            scheduler.userAttentionLost();
            scheduler.userAttentionGained();
            this.release();
            TaskListSynchronizationSchedulerTest.assertTrue((String)"Expected synchronization to run again", (boolean)this.connector.latch.await(5L, TimeUnit.SECONDS));
        }
        finally {
            scheduler.dispose();
        }
    }

    private void release() throws Exception {
        if (this.connector.e instanceof Error) {
            throw (Error)this.connector.e;
        }
        if (this.connector.e instanceof Exception) {
            throw (Exception)this.connector.e;
        }
        this.connector.reset();
        this.mainLatch.countDown();
    }

    private class TestConnector
    extends MockRepositoryConnector {
        CountDownLatch latch = new CountDownLatch(1);
        Throwable e;

        private TestConnector() {
        }

        public void preSynchronization(ISynchronizationSession event, IProgressMonitor monitor) throws CoreException {
            this.latch.countDown();
            try {
                if (!TaskListSynchronizationSchedulerTest.this.mainLatch.await(10L, TimeUnit.SECONDS)) {
                    this.e = new AssertionFailedError("Timed out waiting for main latch");
                }
            }
            catch (InterruptedException e) {
                this.e = e;
            }
        }

        public void reset() {
            this.latch = new CountDownLatch(1);
        }
    }
}

