/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests.ui.editor;

import junit.framework.TestCase;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorExtensions;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.tests.ui.editor.MockTextileEditorExtension;
import org.eclipse.mylyn.tasks.tests.ui.editor.MockWikiEditorExtension;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorExtension;

public class TaskEditorExtensionsTest
extends TestCase {
    private static final String ID_TEXTILE_EXTENSION = "org.eclipse.mylyn.tasks.tests.editor.mock.textile";
    private TaskRepository repository;
    private TaskData taskData;

    protected void setUp() throws Exception {
        this.repository = new TaskRepository("mock", "http://mockrepository.test");
        TasksUiPlugin.getRepositoryManager().addRepository(this.repository);
        this.taskData = new TaskData(new TaskAttributeMapper(this.repository), "mock", "http://mockrepository.test", "taskId");
    }

    protected void tearDown() throws Exception {
        TasksUiPlugin.getRepositoryManager().removeRepository(this.repository);
    }

    public void testMarkupAssociationFromRepository() {
        TaskEditorExtensions.setTaskEditorExtensionId((TaskRepository)this.repository, (String)ID_TEXTILE_EXTENSION);
        TaskAttribute attribute = this.taskData.getRoot().createMappedAttribute("task.common.description");
        AbstractTaskEditorExtension extension = TaskEditorExtensions.getTaskEditorExtension((TaskRepository)this.repository, (TaskAttribute)attribute);
        TaskEditorExtensionsTest.assertTrue((boolean)(extension instanceof MockTextileEditorExtension));
    }

    public void testMarkupAssociationFromAttribute() {
        TaskEditorExtensions.setTaskEditorExtensionId((TaskRepository)this.repository, (String)"none");
        TaskAttribute attribute = this.taskData.getRoot().createMappedAttribute("task.common.description");
        attribute.getMetaData().setMediaType("text/plain; markup=MockWiki");
        AbstractTaskEditorExtension extension = TaskEditorExtensions.getTaskEditorExtension((TaskRepository)this.repository, (TaskAttribute)attribute);
        TaskEditorExtensionsTest.assertTrue((boolean)(extension instanceof MockWikiEditorExtension));
    }

    public void testMarkupAssociationFromBoth() {
        TaskEditorExtensions.setTaskEditorExtensionId((TaskRepository)this.repository, (String)ID_TEXTILE_EXTENSION);
        TaskAttribute attribute = this.taskData.getRoot().createMappedAttribute("task.common.description");
        attribute.getMetaData().setMediaType("text/plain; markup=MockWiki");
        AbstractTaskEditorExtension extension = TaskEditorExtensions.getTaskEditorExtension((TaskRepository)this.repository, (TaskAttribute)attribute);
        TaskEditorExtensionsTest.assertTrue((boolean)(extension instanceof MockWikiEditorExtension));
    }

    public void testMarkupAssociationComplexMediaType() {
        TaskEditorExtensions.setTaskEditorExtensionId((TaskRepository)this.repository, (String)ID_TEXTILE_EXTENSION);
        TaskAttribute attribute = this.taskData.getRoot().createMappedAttribute("task.common.description");
        attribute.getMetaData().setMediaType("text/plain; markup=MockWiki; charset=iso-8859-1");
        AbstractTaskEditorExtension extension = TaskEditorExtensions.getTaskEditorExtension((TaskRepository)this.repository, (TaskAttribute)attribute);
        TaskEditorExtensionsTest.assertTrue((boolean)(extension instanceof MockWikiEditorExtension));
    }

    public void testMarkupAssociationNotMarkupMediaType() {
        TaskEditorExtensions.setTaskEditorExtensionId((TaskRepository)this.repository, (String)ID_TEXTILE_EXTENSION);
        TaskAttribute attribute = this.taskData.getRoot().createMappedAttribute("task.common.description");
        attribute.getMetaData().setMediaType("text/plain; notreallyamarkup=MockWiki");
        AbstractTaskEditorExtension extension = TaskEditorExtensions.getTaskEditorExtension((TaskRepository)this.repository, (TaskAttribute)attribute);
        TaskEditorExtensionsTest.assertTrue((boolean)(extension instanceof MockTextileEditorExtension));
    }

    public void testMarkupAssociationNoAssociation() {
        TaskEditorExtensions.setTaskEditorExtensionId((TaskRepository)this.repository, (String)"none");
        TaskAttribute attribute = this.taskData.getRoot().createMappedAttribute("task.common.description");
        AbstractTaskEditorExtension extension = TaskEditorExtensions.getTaskEditorExtension((TaskRepository)this.repository, (TaskAttribute)attribute);
        TaskEditorExtensionsTest.assertNull((Object)extension);
    }

    public void testBaseMarkupAssociation() {
        TaskEditorExtensions.setTaskEditorExtensionId((TaskRepository)this.repository, (String)ID_TEXTILE_EXTENSION);
        TaskAttribute attribute = this.taskData.getRoot().createMappedAttribute("task.common.description");
        attribute.getMetaData().setMediaType("text/plain; markup=SpecialMockWiki; base-markup=MockWiki");
        AbstractTaskEditorExtension extension = TaskEditorExtensions.getTaskEditorExtension((TaskRepository)this.repository, (TaskAttribute)attribute);
        TaskEditorExtensionsTest.assertTrue((boolean)(extension instanceof MockWikiEditorExtension));
    }

    public void testBaseMarkupAssociationNoMarkup() {
        TaskEditorExtensions.setTaskEditorExtensionId((TaskRepository)this.repository, (String)ID_TEXTILE_EXTENSION);
        TaskAttribute attribute = this.taskData.getRoot().createMappedAttribute("task.common.description");
        attribute.getMetaData().setMediaType("text/plain; base-markup=MockWiki");
        AbstractTaskEditorExtension extension = TaskEditorExtensions.getTaskEditorExtension((TaskRepository)this.repository, (TaskAttribute)attribute);
        TaskEditorExtensionsTest.assertTrue((boolean)(extension instanceof MockTextileEditorExtension));
    }
}

