/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.workbench;

import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchImages;

public class CommonImageManger {
    private static final String[] IMAGE_EXTENSIONS = new String[]{"jpg", "gif", "png", "tiff", "tif", "bmp"};
    private final LocalResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());

    public void dispose() {
        this.resourceManager.dispose();
    }

    public Image getFolderImage() {
        return WorkbenchImages.getImage((String)"IMG_OBJ_FOLDER");
    }

    public Image getFileImage(String filename) {
        if (filename != null) {
            String file;
            int dotIndex = filename.lastIndexOf(46);
            if (dotIndex != -1) {
                String fileType = filename.substring(dotIndex + 1);
                String[] stringArray = IMAGE_EXTENSIONS;
                int n = IMAGE_EXTENSIONS.length;
                int n2 = 0;
                while (n2 < n) {
                    String element2 = stringArray[n2];
                    if (element2.equalsIgnoreCase(fileType)) {
                        return CommonImages.getImage((ImageDescriptor)CommonImages.IMAGE_FILE);
                    }
                    ++n2;
                }
            }
            if ((file = new Path(filename).lastSegment()) != null) {
                return this.getImage(PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(filename));
            }
        }
        return WorkbenchImages.getImage((String)"IMG_OBJ_FILE");
    }

    public Image getImage(ImageDescriptor imageDescriptor) {
        return (Image)this.resourceManager.get((DeviceResourceDescriptor)imageDescriptor);
    }

    public LocalResourceManager getResourceManager() {
        return this.resourceManager;
    }
}

