/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core;

import com.google.common.collect.ImmutableSet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.mylyn.internal.commons.core.XmlStringConverter;
import org.eclipse.mylyn.internal.tasks.core.SaxRepositoriesWriter;
import org.eclipse.mylyn.internal.tasks.core.XmlReaderUtil;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class LegacySaxRepositoriesTest {
    private static final String kind = "connector.kind";
    private static final String firstUrl = "http://first.url";
    private static final String secondUrl = "http://second.url";
    private static final String labelPropertyValue = "test repository";
    private static final String labelPropertyValueAlternate = "test repository alternate";
    private static final String labelPropertyKey = "label";
    private final String repositoryXmlVersion2 = String.format("<?xml version=\"1.0\" encoding=\"UTF-8\"?><TaskRepositories OutputVersion=\"2\"><TaskRepository url=\"%s\" kind=\"%s\" %s=\"%s\"><Property key=\"%s\" value=\"%s\"/></TaskRepository><TaskRepository url=\"%s\" kind=\"%s\" %s=\"%s\"><Property key=\"%s\" value=\"%s\"/></TaskRepository></TaskRepositories>", "http://first.url", "connector.kind", "label", "test repository", "label", "test repository alternate", "http://second.url", "connector.kind", "label", "test repository", "label", "test repository alternate");

    @Test
    public void version1ReaderCanReadVersion2Xml() throws Exception {
        ImmutableSet expectedRepositories = ImmutableSet.of((Object)this.createTestRepository(kind, firstUrl, labelPropertyKey, labelPropertyValue), (Object)this.createTestRepository(kind, secondUrl, labelPropertyKey, labelPropertyValue));
        Set<TaskRepository> repositories = this.parseRepositoriesWithVersion1Parser(this.repositoryXmlVersion2);
        Assert.assertEquals((Object)expectedRepositories, repositories);
        for (TaskRepository repository : repositories) {
            Assert.assertEquals((Object)labelPropertyValue, (Object)repository.getProperty(labelPropertyKey));
        }
    }

    @Test
    public void version1CanReadLatestOutput() throws Exception {
        TaskRepository initialRepository = this.createTestRepository(kind, firstUrl, labelPropertyKey, labelPropertyValue);
        String xml = this.writeToXmlWithCurrentVersion((Set<TaskRepository>)ImmutableSet.of((Object)initialRepository));
        Set<TaskRepository> parsed = this.parseRepositoriesWithVersion1Parser(xml);
        Assert.assertEquals((long)1L, (long)parsed.size());
        TaskRepository parsedRepository = parsed.iterator().next();
        Assert.assertEquals((Object)initialRepository, (Object)parsedRepository);
        Assert.assertEquals((Object)labelPropertyValue, (Object)parsedRepository.getProperty(labelPropertyKey));
    }

    private String writeToXmlWithCurrentVersion(Set<TaskRepository> repositories) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream(1000 * repositories.size());
        SaxRepositoriesWriter writer = new SaxRepositoriesWriter();
        writer.setOutputStream((OutputStream)output);
        writer.writeRepositoriesToStream(repositories);
        return output.toString("UTF-8");
    }

    private Set<TaskRepository> parseRepositoriesWithVersion1Parser(String xml) throws Exception {
        SaxRepositoriesContentHandlerVersion1 handler = new SaxRepositoriesContentHandlerVersion1();
        XMLReader reader = XmlReaderUtil.createXmlReader();
        reader.setContentHandler(handler);
        reader.parse(new InputSource(new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8))));
        return handler.getRepositories();
    }

    private TaskRepository createTestRepository(String kind, String url, String labelPropertyKey, String labelProperty) {
        TaskRepository repository = new TaskRepository(kind, url);
        repository.setProperty(labelPropertyKey, labelProperty);
        return repository;
    }

    private class SaxRepositoriesContentHandlerVersion1
    extends DefaultHandler {
        private final Set<TaskRepository> taskRepositories = new HashSet<TaskRepository>();

        private SaxRepositoriesContentHandlerVersion1() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            try {
                if (localName.equals("TaskRepository") && attributes != null) {
                    String kind = XmlStringConverter.convertXmlToString((String)attributes.getValue("kind"));
                    String url = XmlStringConverter.convertXmlToString((String)attributes.getValue("url"));
                    if (kind != null && kind.length() > 0 && url != null && url.length() > 0) {
                        TaskRepository repository = new TaskRepository(kind, url);
                        int index = 0;
                        while (index < attributes.getLength()) {
                            String key = XmlStringConverter.convertXmlToString((String)attributes.getLocalName(index));
                            String value = XmlStringConverter.convertXmlToString((String)attributes.getValue(index));
                            repository.setProperty(key, value);
                            ++index;
                        }
                        this.taskRepositories.add(repository);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public Set<TaskRepository> getRepositories() {
            return this.taskRepositories;
        }
    }
}

