/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core;

import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.TaskCategory;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.internal.tasks.core.TaskTask;
import org.eclipse.mylyn.internal.tasks.core.UnmatchedTaskContainer;
import org.eclipse.mylyn.tasks.core.ITask;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TaskListTest {
    private TaskList taskList;

    @Before
    public void setUp() throws Exception {
        this.taskList = new TaskList();
    }

    @Test
    public void removeMatchedTaskFromUnmatched() {
        UnmatchedTaskContainer unmatched = (UnmatchedTaskContainer)Mockito.spy((Object)new UnmatchedTaskContainer("kind", "repoUrl"));
        TaskCategory category1 = new TaskCategory("cat1");
        TaskCategory category2 = new TaskCategory("cat2");
        AbstractTask task = (AbstractTask)Mockito.spy((Object)new TaskTask("kind", "repoUrl", "id"));
        this.taskList.addCategory(category1);
        this.taskList.addCategory(category2);
        this.taskList.addUnmatchedContainer(unmatched);
        this.taskList.addTask((ITask)task);
        this.taskList.addTask((ITask)task, (AbstractTaskContainer)category1);
        ((UnmatchedTaskContainer)Mockito.verify((Object)unmatched, (VerificationMode)Mockito.times((int)1))).internalRemoveChild((ITask)task);
        this.taskList.addTask((ITask)task, (AbstractTaskContainer)category2);
        ((UnmatchedTaskContainer)Mockito.verify((Object)unmatched, (VerificationMode)Mockito.times((int)1))).internalRemoveChild((ITask)task);
    }
}

