/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core.externalization;

import org.eclipse.mylyn.internal.tasks.core.externalization.SaxOrphanBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class SaxOrphanBuilderTest {
    private SaxOrphanBuilder builder;

    @Before
    public void setUp() throws Exception {
        this.builder = new SaxOrphanBuilder();
    }

    @Test
    public void parseWithNoCommit() {
        this.prepareTask("123");
        this.builder.endElement();
        this.prepareTask("456");
        this.builder.endElement();
        this.assertOrphans(0, new String[0]);
    }

    @Test
    public void parseWithCommit() {
        this.prepareTask("123");
        this.builder.endElement();
        this.prepareTask("456");
        this.builder.commitOrphan();
        this.builder.endElement();
        this.assertOrphans(1, "456");
    }

    @Test
    public void parseWithMiddleCommit() {
        this.prepareTask("123");
        this.builder.endElement();
        this.prepareTask("345");
        this.builder.commitOrphan();
        this.builder.endElement();
        this.prepareTask("567");
        this.builder.endElement();
        this.assertOrphans(1, "345");
    }

    @Test
    public void parseWithMultipleCommit() {
        this.prepareTask("123");
        this.builder.endElement();
        this.prepareTask("o1");
        this.builder.commitOrphan();
        this.builder.endElement();
        this.prepareTask("o2");
        this.builder.commitOrphan();
        this.builder.endElement();
        this.prepareTask("o3");
        this.builder.commitOrphan();
        this.builder.endElement();
        this.prepareTask("567");
        this.builder.endElement();
        this.prepareTask("o4");
        this.builder.commitOrphan();
        this.builder.endElement();
        this.prepareTask("o5");
        this.builder.commitOrphan();
        this.builder.endElement();
        this.assertOrphans(5, "o1", "o2", "o3", "o4", "o5");
    }

    private void prepareTask(String attributeValue) {
        this.start("task");
        this.start("attribute");
        this.text(attributeValue);
        this.builder.endElement();
    }

    private void start(String name) {
        this.builder.startElement(name, (Attributes)new AttributesImpl());
    }

    private void text(String text) {
        this.builder.acceptCharacters(text.toCharArray(), 0, text.length());
    }

    private void assertOrphans(int numOrphans, String ... attributeValue) {
        Document document = this.builder.getOrphans();
        Assert.assertEquals((long)1L, (long)document.getChildNodes().getLength());
        NodeList orphans = document.getDocumentElement().getChildNodes();
        Assert.assertEquals((long)numOrphans, (long)orphans.getLength());
        int i = 0;
        while (i < attributeValue.length) {
            Node text = orphans.item(i).getFirstChild().getFirstChild();
            Assert.assertTrue((boolean)(text instanceof Text));
            Assert.assertEquals((Object)attributeValue[i], (Object)((Text)text).getTextContent());
            ++i;
        }
    }
}

