/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core.externalization;

import com.google.common.base.Strings;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskCategory;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.ITransferList;
import org.eclipse.mylyn.internal.tasks.core.RepositoryModel;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.core.externalization.SaxCategoryBuilder;
import org.eclipse.mylyn.internal.tasks.core.externalization.SaxOrphanBuilder;
import org.eclipse.mylyn.internal.tasks.core.externalization.SaxQueryBuilder;
import org.eclipse.mylyn.internal.tasks.core.externalization.SaxTaskBuilder;
import org.eclipse.mylyn.internal.tasks.core.externalization.SaxTaskListElementBuilder;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.IRepositoryManager;
import org.w3c.dom.Document;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SaxTaskListHandler
extends DefaultHandler {
    private final ITransferList taskList;
    private final RepositoryModel repositoryModel;
    private final IRepositoryManager repositoryManager;
    private final Multimap<AbstractTask, String> subTasks;
    private final Multimap<RepositoryQuery, String> queryResults;
    private final Multimap<AbstractTaskCategory, String> categorizedTasks;
    private SaxTaskListElementBuilder<? extends IRepositoryElement> currentBuilder;
    private final SaxOrphanBuilder orphanBuilder;

    public SaxTaskListHandler(ITransferList taskList, RepositoryModel repositoryModel, IRepositoryManager repositoryManager) throws CoreException {
        this.taskList = taskList;
        this.repositoryModel = repositoryModel;
        this.repositoryManager = repositoryManager;
        this.subTasks = HashMultimap.create();
        this.queryResults = HashMultimap.create();
        this.categorizedTasks = HashMultimap.create();
        this.orphanBuilder = new SaxOrphanBuilder();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        switch (localName) {
            case "Task": {
                this.checkState(this.currentBuilder == null, "Cannot begin reading a task while reading another task list element.");
                this.currentBuilder = new SaxTaskBuilder(this.repositoryModel, this.repositoryManager);
                this.currentBuilder.beginItem(attributes);
                break;
            }
            case "Query": {
                this.checkState(this.currentBuilder == null, "Cannot begin reading a query while reading another task list element.");
                this.currentBuilder = new SaxQueryBuilder(this.repositoryModel, this.repositoryManager);
                this.currentBuilder.beginItem(attributes);
                break;
            }
            case "TaskCategory": {
                this.checkState(this.currentBuilder == null, "Cannot begin reading a category while reading another task list element.");
                this.currentBuilder = new SaxCategoryBuilder(this.taskList);
                this.currentBuilder.beginItem(attributes);
                break;
            }
            case "Attribute": {
                if (!this.isOK(this.currentBuilder) || this.currentBuilder.isAcceptingAttributeValues()) break;
                this.currentBuilder.startAttribute(attributes);
                break;
            }
            case "SubTask": {
                this.checkState(this.currentBuilder instanceof SaxTaskBuilder, "Cannot read a sub task hit unless reading a task");
                this.recordHit(attributes, this.subTasks, (SaxTaskBuilder)this.currentBuilder);
                break;
            }
            case "QueryHit": {
                this.checkState(this.currentBuilder instanceof SaxQueryBuilder, "Cannot read a query hit unless reading a query");
                this.recordHit(attributes, this.queryResults, (SaxQueryBuilder)this.currentBuilder);
                break;
            }
            case "TaskReference": {
                this.checkState(this.currentBuilder instanceof SaxCategoryBuilder, "Cannot read a category hit unless reading a category");
                this.recordHit(attributes, this.categorizedTasks, (SaxCategoryBuilder)this.currentBuilder);
                break;
            }
        }
        if (!"TaskList".equals(localName)) {
            this.orphanBuilder.startElement(localName, attributes);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.isOK(this.currentBuilder) && this.currentBuilder.isAcceptingAttributeValues()) {
            this.currentBuilder.acceptAttributeValueContent(ch, start, length);
        }
        this.orphanBuilder.acceptCharacters(ch, start, length);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        switch (localName) {
            case "TaskCategory": 
            case "Task": 
            case "Query": {
                this.commitCurrentTopLevelElement();
                this.currentBuilder = null;
                break;
            }
            case "Attribute": {
                if (!this.isOK(this.currentBuilder) || !this.currentBuilder.isAcceptingAttributeValues()) break;
                this.currentBuilder.endAttribute();
                break;
            }
            case "TaskList": {
                this.applyContainmentToTaskList(this.subTasks);
                this.applyContainmentToTaskList(this.queryResults);
                this.applyContainmentToTaskList(this.categorizedTasks);
                break;
            }
        }
        this.orphanBuilder.endElement();
    }

    private <T extends IRepositoryElement> void recordHit(Attributes attributes, Multimap<T, String> hitMap, SaxTaskListElementBuilder<T> builder) {
        String handle = attributes.getValue("Handle");
        if (!Strings.isNullOrEmpty((String)handle) && this.isOK(builder)) {
            hitMap.put(builder.getItem(), (Object)handle);
        }
    }

    private void commitCurrentTopLevelElement() throws SAXException {
        this.checkState(this.currentBuilder != null, "Cannot finish reading a task list element without a corresponding builder.");
        if (this.isOK(this.currentBuilder)) {
            this.currentBuilder.addToTaskList(this.taskList);
        } else {
            if (!this.currentBuilder.getErrors().isOK()) {
                StatusHandler.log((IStatus)this.currentBuilder.getErrors());
            }
            this.orphanBuilder.commitOrphan();
        }
    }

    private <T extends AbstractTaskContainer> void applyContainmentToTaskList(Multimap<T, String> containment) {
        for (AbstractTaskContainer container : containment.keySet()) {
            Collection handles = containment.get((Object)container);
            for (String handle : handles) {
                AbstractTask subTask = this.taskList.getTask(handle);
                if (subTask == null) continue;
                this.taskList.addTask(subTask, container);
            }
        }
    }

    private boolean isOK(SaxTaskListElementBuilder<?> builder) {
        return builder != null && builder.getErrors().isOK() && builder.getItem() != null;
    }

    public Document getOrphans() {
        return this.orphanBuilder.getOrphans();
    }

    private void checkState(boolean condition, String message) throws SAXException {
        if (!condition) {
            throw new SAXException(message);
        }
    }
}

