/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.core;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaAttribute;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaOperation;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaRepositoryConnector;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaVersion;
import org.eclipse.mylyn.internal.bugzilla.core.RepositoryConfiguration;
import org.eclipse.mylyn.tasks.core.IRepositoryPerson;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttachmentMapper;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BugzillaAttributeMapper
extends TaskAttributeMapper {
    private final String dateFormat_1 = "yyyy-MM-dd HH:mm:ss";
    private final String dateFormat_2 = "yyyy-MM-dd HH:mm";
    private final String dateFormat_3 = "yyyy-MM-dd";
    private final String dateFormat_1_TimeZone = "yyyy-MM-dd HH:mm:ss Z";
    private final String dateFormat_2_TimeZone = "yyyy-MM-dd HH:mm zzz";
    private final String dateFormat_3_TimeZone = "yyyy-MM-dd zzz";
    private final BugzillaRepositoryConnector connector;

    public BugzillaAttributeMapper(TaskRepository taskRepository, BugzillaRepositoryConnector connector) {
        super(taskRepository);
        this.connector = connector;
    }

    public Date getDateValue(TaskAttribute attribute) {
        if (attribute == null) {
            return null;
        }
        String dateString = attribute.getValue();
        String id = attribute.getId();
        Date parsedDate = this.getDate(id, dateString);
        if (parsedDate == null) {
            parsedDate = super.getDateValue(attribute);
        }
        return parsedDate;
    }

    public boolean getBooleanValue(TaskAttribute attribute) {
        return attribute.getValue().equals("1");
    }

    public void setBooleanValue(TaskAttribute attribute, Boolean value) {
        if (value == null) {
            attribute.setValue("0");
        } else if (value.booleanValue()) {
            attribute.setValue("1");
        } else {
            attribute.setValue("0");
        }
    }

    protected Date getDate(String attributeId, String dateString) {
        Date parsedDate = null;
        BugzillaVersion bugzillaVersion = null;
        RepositoryConfiguration repositoryConfiguration = this.connector.getRepositoryConfiguration(this.getTaskRepository().getUrl());
        bugzillaVersion = repositoryConfiguration != null ? repositoryConfiguration.getInstallVersion() : BugzillaVersion.MIN_VERSION;
        try {
            if (attributeId.equals(BugzillaAttribute.DELTA_TS.getKey())) {
                parsedDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z").parse(dateString);
            } else if (attributeId.equals(BugzillaAttribute.CREATION_TS.getKey())) {
                parsedDate = bugzillaVersion.compareMajorMinorOnly(BugzillaVersion.BUGZILLA_2_22) < 0 ? new SimpleDateFormat("yyyy-MM-dd HH:mm zzz").parse(dateString) : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z").parse(dateString);
            } else if (attributeId.equals(BugzillaAttribute.BUG_WHEN.getKey())) {
                SimpleDateFormat comment_creation_ts_Format_Timezone = bugzillaVersion.compareMajorMinorOnly(BugzillaVersion.BUGZILLA_2_22) < 0 ? new SimpleDateFormat("yyyy-MM-dd HH:mm zzz") : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
                parsedDate = comment_creation_ts_Format_Timezone.parse(dateString);
            } else if (attributeId.equals(BugzillaAttribute.DATE.getKey())) {
                SimpleDateFormat attachment_creation_ts_Format_Timezone = bugzillaVersion.compareMajorMinorOnly(BugzillaVersion.BUGZILLA_2_22) < 0 ? new SimpleDateFormat("yyyy-MM-dd HH:mm zzz") : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
                parsedDate = attachment_creation_ts_Format_Timezone.parse(dateString);
            } else if (attributeId.equals(BugzillaAttribute.DEADLINE.getKey())) {
                parsedDate = new SimpleDateFormat("yyyy-MM-dd zzz").parse(dateString);
            } else if (attributeId.startsWith("cf_")) {
                parsedDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z").parse(dateString);
            }
        }
        catch (ParseException parseException) {
            try {
                if (attributeId.equals(BugzillaAttribute.DELTA_TS.getKey())) {
                    parsedDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(dateString);
                } else if (attributeId.equals(BugzillaAttribute.CREATION_TS.getKey())) {
                    parsedDate = new SimpleDateFormat("yyyy-MM-dd HH:mm").parse(dateString);
                } else if (attributeId.equals(BugzillaAttribute.BUG_WHEN.getKey())) {
                    SimpleDateFormat comment_creation_ts_Format = bugzillaVersion.compareMajorMinorOnly(BugzillaVersion.BUGZILLA_2_22) < 0 ? new SimpleDateFormat("yyyy-MM-dd HH:mm") : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    parsedDate = comment_creation_ts_Format.parse(dateString);
                } else if (attributeId.equals(BugzillaAttribute.DATE.getKey())) {
                    SimpleDateFormat attachment_creation_ts_Format = bugzillaVersion.compareMajorMinorOnly(BugzillaVersion.BUGZILLA_2_22) < 0 ? new SimpleDateFormat("yyyy-MM-dd HH:mm") : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    parsedDate = attachment_creation_ts_Format.parse(dateString);
                } else if (attributeId.equals(BugzillaAttribute.DEADLINE.getKey())) {
                    parsedDate = new SimpleDateFormat("yyyy-MM-dd").parse(dateString);
                } else if (attributeId.startsWith("cf_")) {
                    parsedDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(dateString);
                }
            }
            catch (ParseException parseException2) {
                try {
                    String delta_ts_format = "yyyy-MM-dd HH:mm:ss";
                    String creation_ts_format = "yyyy-MM-dd HH:mm";
                    String deadline_format = "yyyy-MM-dd";
                    String customAttribute_format = "yyyy-MM-dd HH:mm:ss";
                    String comment_creation_ts_format = "yyyy-MM-dd HH:mm";
                    String attachment_creation_ts_format = "yyyy-MM-dd HH:mm";
                    if (attributeId.equals(BugzillaAttribute.DELTA_TS.getKey())) {
                        parsedDate = new SimpleDateFormat(delta_ts_format).parse(dateString);
                    } else if (attributeId.equals(BugzillaAttribute.CREATION_TS.getKey())) {
                        parsedDate = new SimpleDateFormat(creation_ts_format).parse(dateString);
                    } else if (attributeId.equals(BugzillaAttribute.BUG_WHEN.getKey())) {
                        parsedDate = new SimpleDateFormat(comment_creation_ts_format).parse(dateString);
                    } else if (attributeId.equals(BugzillaAttribute.DATE.getKey())) {
                        parsedDate = new SimpleDateFormat(attachment_creation_ts_format).parse(dateString);
                    } else if (attributeId.equals(BugzillaAttribute.DEADLINE.getKey())) {
                        parsedDate = new SimpleDateFormat(deadline_format).parse(dateString);
                    } else if (attributeId.startsWith("cf_")) {
                        parsedDate = new SimpleDateFormat(customAttribute_format).parse(dateString);
                    }
                }
                catch (ParseException parseException3) {}
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return parsedDate;
    }

    public void setDateValue(TaskAttribute attribute, Date date) {
        if (date != null) {
            BugzillaVersion bugzillaVersion = null;
            RepositoryConfiguration repositoryConfiguration = this.connector.getRepositoryConfiguration(this.getTaskRepository().getUrl());
            bugzillaVersion = repositoryConfiguration != null ? repositoryConfiguration.getInstallVersion() : BugzillaVersion.MIN_VERSION;
            String dateString = null;
            String attributeId = attribute.getId();
            if (attributeId.equals(BugzillaAttribute.DELTA_TS.getKey())) {
                dateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(date);
            } else if (attributeId.equals(BugzillaAttribute.CREATION_TS.getKey())) {
                dateString = new SimpleDateFormat("yyyy-MM-dd HH:mm").format(date);
            } else if (attributeId.equals(BugzillaAttribute.BUG_WHEN.getKey())) {
                SimpleDateFormat comment_creation_ts_Format = bugzillaVersion.compareMajorMinorOnly(BugzillaVersion.BUGZILLA_2_22) < 0 ? new SimpleDateFormat("yyyy-MM-dd HH:mm") : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                dateString = comment_creation_ts_Format.format(date);
            } else if (attributeId.equals(BugzillaAttribute.DATE.getKey())) {
                SimpleDateFormat attachment_creation_ts_Format = bugzillaVersion.compareMajorMinorOnly(BugzillaVersion.BUGZILLA_2_22) < 0 ? new SimpleDateFormat("yyyy-MM-dd HH:mm") : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                dateString = attachment_creation_ts_Format.format(date);
            } else if (attributeId.equals(BugzillaAttribute.DEADLINE.getKey())) {
                dateString = new SimpleDateFormat("yyyy-MM-dd").format(date);
            } else if (attributeId.startsWith("cf_")) {
                dateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(date);
            }
            if (dateString == null) {
                super.setDateValue(attribute, date);
            } else {
                attribute.setValue(dateString);
            }
        } else {
            attribute.clearValues();
        }
    }

    public String mapToRepositoryKey(TaskAttribute parent, String key) {
        if (key.equals("task.common.comment.date")) {
            return BugzillaAttribute.BUG_WHEN.getKey();
        }
        if (key.equals("task.common.comment.author")) {
            return BugzillaAttribute.WHO.getKey();
        }
        if (key.equals("task.common.comment.author.name")) {
            return BugzillaAttribute.WHO_NAME.getKey();
        }
        if (key.equals("task.common.user.cc")) {
            return BugzillaAttribute.CC.getKey();
        }
        if (key.equals("task.common.comment.text")) {
            return BugzillaAttribute.THETEXT.getKey();
        }
        if (key.equals("task.common.date.created")) {
            return BugzillaAttribute.CREATION_TS.getKey();
        }
        if (key.equals("task.common.description")) {
            return BugzillaAttribute.LONG_DESC.getKey();
        }
        if (key.equals("task.common.attachment.id")) {
            return BugzillaAttribute.ATTACHID.getKey();
        }
        if (key.equals("task.common.attachment.description")) {
            return BugzillaAttribute.DESC.getKey();
        }
        if (key.equals("task.common.attachment.ctype")) {
            return BugzillaAttribute.CTYPE.getKey();
        }
        if (key.equals("task.common.user.assigned")) {
            return BugzillaAttribute.ASSIGNED_TO.getKey();
        }
        if (key.equals("task.common.user.assigned.name")) {
            return BugzillaAttribute.ASSIGNED_TO_NAME.getKey();
        }
        if (key.equals("task.common.resolution")) {
            return BugzillaAttribute.RESOLUTION.getKey();
        }
        if (key.equals("task.common.status")) {
            return BugzillaAttribute.BUG_STATUS.getKey();
        }
        if (key.equals("task.common.date.modified")) {
            return BugzillaAttribute.DELTA_TS.getKey();
        }
        if (key.equals("task.common.user.reporter")) {
            return BugzillaAttribute.REPORTER.getKey();
        }
        if (key.equals("task.common.user.reporter.name")) {
            return BugzillaAttribute.REPORTER_NAME.getKey();
        }
        if (key.equals("task.common.summary")) {
            return BugzillaAttribute.SHORT_DESC.getKey();
        }
        if (key.equals("task.common.product")) {
            return BugzillaAttribute.PRODUCT.getKey();
        }
        if (key.equals("task.common.keywords")) {
            return BugzillaAttribute.KEYWORDS.getKey();
        }
        if (key.equals("task.common.attachment.date")) {
            return BugzillaAttribute.DATE.getKey();
        }
        if (key.equals("task.common.attachment.size")) {
            return BugzillaAttribute.SIZE.getKey();
        }
        if (key.equals("task.common.addselfcc")) {
            return BugzillaAttribute.ADDSELFCC.getKey();
        }
        if (key.equals("task.common.priority")) {
            return BugzillaAttribute.PRIORITY.getKey();
        }
        if (key.equals("task.common.comment.new")) {
            return BugzillaAttribute.NEW_COMMENT.getKey();
        }
        if (key.equals("task.common.component")) {
            return BugzillaAttribute.COMPONENT.getKey();
        }
        if (key.equals("task.common.key")) {
            return BugzillaAttribute.BUG_ID.getKey();
        }
        if (key.equals("task.common.date.due")) {
            return BugzillaAttribute.DEADLINE.getKey();
        }
        if (key.equals("task.common.severity")) {
            return BugzillaAttribute.BUG_SEVERITY.getKey();
        }
        if (key.equals("task.common.version")) {
            return BugzillaAttribute.VERSION.getKey();
        }
        return super.mapToRepositoryKey(parent, key);
    }

    public TaskAttribute getAssoctiatedAttribute(TaskAttribute taskAttribute) {
        String id = taskAttribute.getMetaData().getValue("task.meta.associated.attribute");
        if (id != null) {
            if ("operation".equals(taskAttribute.getMetaData().getType())) {
                return taskAttribute.getTaskData().getRoot().getMappedAttribute(id);
            }
            return taskAttribute.getMappedAttribute(id);
        }
        return null;
    }

    public IRepositoryPerson getRepositoryPerson(TaskAttribute taskAttribute) {
        IRepositoryPerson person = super.getRepositoryPerson(taskAttribute);
        if (person.getName() == null) {
            TaskAttribute attrReporter;
            if (taskAttribute.getId().equals(BugzillaAttribute.ASSIGNED_TO.getKey())) {
                TaskAttribute attrAssigned = taskAttribute.getTaskData().getRoot().getAttribute(BugzillaAttribute.ASSIGNED_TO_NAME.getKey());
                if (attrAssigned != null) {
                    person.setName(attrAssigned.getValue());
                }
            } else if (taskAttribute.getId().equals(BugzillaAttribute.REPORTER.getKey())) {
                TaskAttribute attrReporter2 = taskAttribute.getTaskData().getRoot().getAttribute(BugzillaAttribute.REPORTER_NAME.getKey());
                if (attrReporter2 != null) {
                    person.setName(attrReporter2.getValue());
                }
            } else if (taskAttribute.getId().equals(BugzillaAttribute.QA_CONTACT.getKey()) && (attrReporter = taskAttribute.getTaskData().getRoot().getAttribute(BugzillaAttribute.QA_CONTACT_NAME.getKey())) != null) {
                person.setName(attrReporter.getValue());
            }
        }
        return person;
    }

    public Map<String, String> getOptions(TaskAttribute attribute) {
        TaskAttribute attributeProduct;
        RepositoryConfiguration configuration = this.connector.getRepositoryConfiguration(this.getTaskRepository().getRepositoryUrl());
        if (configuration != null && (attributeProduct = attribute.getTaskData().getRoot().getMappedAttribute(BugzillaAttribute.PRODUCT.getKey())) != null && attributeProduct.getValue().length() > 0) {
            List<String> options = configuration.getAttributeOptions(attributeProduct.getValue(), attribute);
            if (options.size() == 0 && attribute.getId().equals(BugzillaOperation.resolve.getInputId())) {
                options = configuration.getOptionValues(BugzillaAttribute.RESOLUTION, attributeProduct.getValue());
                options.remove("DUPLICATE");
                options.remove("MOVED");
            }
            LinkedHashMap<String, String> newOptions = new LinkedHashMap<String, String>();
            for (String option : options) {
                newOptions.put(option, option);
            }
            return newOptions;
        }
        return super.getOptions(attribute);
    }

    public boolean equals(TaskAttribute newAttribute, TaskAttribute oldAttribute) {
        if (oldAttribute.getId().startsWith("task.common.attachment-")) {
            TaskAttachmentMapper oldAttachment = TaskAttachmentMapper.createFrom((TaskAttribute)oldAttribute);
            TaskAttachmentMapper newAttachment = TaskAttachmentMapper.createFrom((TaskAttribute)newAttribute);
            return newAttachment.equals((Object)oldAttachment);
        }
        return super.equals(newAttribute, oldAttribute);
    }

    public String getLabel(TaskAttribute taskAttribute) {
        if (taskAttribute.getId().startsWith("cf_")) {
            return String.valueOf(super.getLabel(taskAttribute)) + ":";
        }
        return super.getLabel(taskAttribute);
    }
}

