/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.provisional.commons.ui;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.mylyn.internal.commons.ui.CommonsUiPlugin;
import org.eclipse.mylyn.internal.provisional.commons.ui.ICoreRunnable;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.PlatformUI;

public class CommonUiUtil {
    private static final String KEY_ENABLED = "org.eclipse.mylyn.commons.ui.enabled";

    public static void busyCursorWhile(final ICoreRunnable runnable) throws OperationCanceledException, CoreException {
        try {
            IRunnableWithProgress runner = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            runnable.run(monitor);
                        }
                        catch (CoreException e) {
                            throw new InvocationTargetException(e);
                        }
                        catch (OperationCanceledException operationCanceledException) {
                            throw new InterruptedException();
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(runner);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CoreException) {
                throw (CoreException)e.getCause();
            }
            CommonsUiPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.mylyn.commons.ui", "Unexpected exception", (Throwable)e));
        }
        catch (InterruptedException interruptedException) {
            throw new OperationCanceledException();
        }
    }

    public static void run(IRunnableContext context, final ICoreRunnable runnable) throws CoreException {
        try {
            IRunnableWithProgress runner = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            runnable.run(monitor);
                        }
                        catch (CoreException e) {
                            throw new InvocationTargetException(e);
                        }
                        catch (OperationCanceledException operationCanceledException) {
                            throw new InterruptedException();
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            context.run(true, true, runner);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CoreException) {
                throw (CoreException)e.getCause();
            }
            CommonsUiPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.mylyn.commons.ui", "Unexpected exception", (Throwable)e));
        }
        catch (InterruptedException interruptedException) {
            throw new OperationCanceledException();
        }
    }

    public static void runInUi(ICoreRunnable runnable, ISchedulingRule rule) throws CoreException {
        CommonUiUtil.runInUi((IRunnableContext)PlatformUI.getWorkbench().getProgressService(), runnable, rule);
    }

    public static void runInUi(IRunnableContext context, final ICoreRunnable runnable, ISchedulingRule rule) throws CoreException {
        try {
            IRunnableWithProgress runner = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            runnable.run(monitor);
                        }
                        catch (CoreException e) {
                            throw new InvocationTargetException(e);
                        }
                        catch (OperationCanceledException operationCanceledException) {
                            throw new InterruptedException();
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            PlatformUI.getWorkbench().getProgressService().runInUI(context, runner, rule);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CoreException) {
                throw (CoreException)e.getCause();
            }
            CommonsUiPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.mylyn.commons.ui", "Unexpected exception", (Throwable)e));
        }
        catch (InterruptedException interruptedException) {
            throw new OperationCanceledException();
        }
    }

    public static void setMessage(DialogPage page, IStatus status) {
        String message = status.getMessage();
        switch (status.getSeverity()) {
            case 0: {
                page.setMessage(null, 0);
                break;
            }
            case 1: {
                page.setMessage(message, 1);
                break;
            }
            case 2: {
                page.setMessage(message, 2);
                break;
            }
            default: {
                page.setMessage(message, 3);
            }
        }
    }

    public static void setMenu(Composite composite, Menu menu) {
        if (!composite.isDisposed()) {
            composite.setMenu(menu);
            Control[] controlArray = composite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                child.setMenu(menu);
                if (child instanceof Composite) {
                    CommonUiUtil.setMenu((Composite)child, menu);
                }
                ++n2;
            }
        }
    }

    public static void setEnabled(Composite composite, boolean restore) {
        if (restore) {
            CommonUiUtil.restoreState(composite);
        } else {
            CommonUiUtil.saveStateAndDisable(composite);
        }
    }

    private static void saveStateAndDisable(Composite composite) {
        if (!composite.isDisposed()) {
            Object data = composite.getData(KEY_ENABLED);
            if (data == null) {
                if (!composite.getEnabled()) {
                    composite.setData(KEY_ENABLED, (Object)Boolean.FALSE);
                } else {
                    composite.setData(KEY_ENABLED, (Object)Boolean.TRUE);
                    composite.setEnabled(false);
                }
            }
            Control[] controlArray = composite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                if (control instanceof Composite) {
                    CommonUiUtil.saveStateAndDisable((Composite)control);
                } else {
                    data = control.getData(KEY_ENABLED);
                    if (data == null) {
                        if (!control.getEnabled()) {
                            control.setData(KEY_ENABLED, (Object)Boolean.FALSE);
                        } else {
                            control.setData(KEY_ENABLED, (Object)Boolean.TRUE);
                            control.setEnabled(false);
                        }
                    }
                }
                ++n2;
            }
        }
    }

    private static void restoreState(Composite composite) {
        if (!composite.isDisposed()) {
            Object data = composite.getData(KEY_ENABLED);
            if (data != null) {
                if (data == Boolean.TRUE) {
                    composite.setEnabled(data == Boolean.TRUE);
                }
                composite.setData(KEY_ENABLED, null);
            }
            Control[] controlArray = composite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                if (control instanceof Composite) {
                    CommonUiUtil.restoreState((Composite)control);
                } else {
                    data = control.getData(KEY_ENABLED);
                    if (data != null) {
                        if (data == Boolean.TRUE) {
                            control.setEnabled(true);
                        }
                        control.setData(KEY_ENABLED, null);
                    }
                }
                ++n2;
            }
        }
    }

    public static String toLabel(String text) {
        return text != null ? text.replaceAll("&", "&&") : null;
    }

    public static String getProductName() {
        return CommonUiUtil.getProductName(null);
    }

    public static String getProductName(String defaultName) {
        String productName;
        IProduct product = Platform.getProduct();
        if (product != null && (productName = product.getName()) != null) {
            String LABEL_SDK = "SDK";
            if (productName.endsWith(LABEL_SDK)) {
                productName = productName.substring(0, productName.length() - LABEL_SDK.length()).trim();
            }
            return productName;
        }
        return defaultName;
    }
}

