/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProgressContainer
implements IRunnableContext {
    private static final String FOCUS_CONTROL = "focusControl";
    private long activeRunningOperations = 0L;
    private Cursor arrowCursor;
    private Button cancelButton;
    private boolean lockedUI = false;
    private boolean needsProgressMonitor;
    private final ProgressMonitorPart progressMonitorPart;
    private final Shell shell;
    private Cursor waitCursor;

    public ProgressContainer(Shell shell, ProgressMonitorPart progressMonitorPart) {
        this.shell = shell;
        this.progressMonitorPart = progressMonitorPart;
    }

    private Object aboutToStart(boolean enableCancelButton) {
        HashMap<Object, Object> savedState = null;
        if (this.getShell() != null) {
            Control focusControl = this.getShell().getDisplay().getFocusControl();
            if (focusControl != null && focusControl.getShell() != this.getShell()) {
                focusControl = null;
            }
            Display d = this.getShell().getDisplay();
            this.waitCursor = new Cursor((Device)d, 1);
            this.setDisplayCursor(this.waitCursor);
            this.arrowCursor = new Cursor((Device)d, 0);
            this.cancelButton.setCursor(this.arrowCursor);
            savedState = new HashMap<Object, Object>(10);
            this.saveUiState(savedState);
            if (focusControl != null) {
                savedState.put(FOCUS_CONTROL, focusControl);
            }
            this.progressMonitorPart.attachToCancelComponent((Control)this.cancelButton);
            this.progressMonitorPart.setVisible(true);
        }
        return savedState;
    }

    public Button getCancelButton() {
        return this.cancelButton;
    }

    private IProgressMonitor getProgressMonitor() {
        return this.progressMonitorPart;
    }

    public Shell getShell() {
        return this.shell;
    }

    public boolean isActive() {
        return this.activeRunningOperations > 0L;
    }

    public boolean isLockedUI() {
        return this.lockedUI;
    }

    protected void restoreUiState(Map<Object, Object> state) {
    }

    public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        Object state = null;
        if (this.activeRunningOperations == 0L) {
            state = this.aboutToStart(fork && cancelable);
        }
        ++this.activeRunningOperations;
        try {
            if (!fork) {
                this.lockedUI = true;
            }
            ModalContext.run((IRunnableWithProgress)runnable, (boolean)fork, (IProgressMonitor)this.getProgressMonitor(), (Display)this.getShell().getDisplay());
            this.lockedUI = false;
        }
        finally {
            --this.activeRunningOperations;
            if (state != null) {
                this.stopped(state);
            }
        }
    }

    protected void saveUiState(Map<Object, Object> savedState) {
    }

    public void setCancelButton(Button cancelButton) {
        this.cancelButton = cancelButton;
    }

    private void setDisplayCursor(Cursor c) {
        Shell[] shells;
        Shell[] shellArray = shells = this.getShell().getDisplay().getShells();
        int n = shells.length;
        int n2 = 0;
        while (n2 < n) {
            Shell shell2 = shellArray[n2];
            shell2.setCursor(c);
            ++n2;
        }
    }

    private void stopped(Object savedState) {
        if (this.getShell() != null && !this.getShell().isDisposed()) {
            if (this.needsProgressMonitor) {
                this.progressMonitorPart.setVisible(false);
                this.progressMonitorPart.removeFromCancelComponent((Control)this.cancelButton);
            }
            Map state = (Map)savedState;
            this.restoreUiState(state);
            this.setDisplayCursor(null);
            this.cancelButton.setCursor(null);
            this.waitCursor.dispose();
            this.waitCursor = null;
            this.arrowCursor.dispose();
            this.arrowCursor = null;
            Control focusControl = (Control)state.get(FOCUS_CONTROL);
            if (focusControl != null && !focusControl.isDisposed()) {
                focusControl.setFocus();
            }
        }
    }
}

