/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.DefaultTaskMapping;
import org.eclipse.mylyn.internal.tasks.core.LocalTask;
import org.eclipse.mylyn.internal.tasks.ui.actions.CopyTaskDetailsAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.Messages;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public class CloneTaskAction
extends BaseSelectionListenerAction
implements IViewActionDelegate {
    private static final String ID = "org.eclipse.mylyn.tasklist.actions.clone";
    protected ISelection selection;

    public CloneTaskAction() {
        super(Messages.CloneTaskAction_Clone_This_Task);
        this.setId(ID);
        this.setImageDescriptor(TasksUiImages.TASK_NEW);
        this.setAccelerator(SWT.MOD1 + 100);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            super.selectionChanged((IStructuredSelection)selection);
        }
    }

    public void run(IAction action) {
        this.run();
    }

    public void run() {
        for (Object selectedObject : this.getStructuredSelection().toList()) {
            Shell shell;
            TaskData taskData;
            String notes;
            if (!(selectedObject instanceof AbstractTask)) continue;
            AbstractTask task = (AbstractTask)selectedObject;
            String description = String.valueOf(Messages.CloneTaskAction_Cloned_from_) + CopyTaskDetailsAction.getTextForTask(task);
            if (task instanceof LocalTask && !"".equals(notes = task.getNotes())) {
                description = String.valueOf(description) + "\n\n" + notes;
            }
            DefaultTaskMapping taskSelection = new DefaultTaskMapping();
            taskSelection.setDescription(description);
            try {
                taskData = TasksUi.getTaskDataManager().getTaskData((ITask)task);
            }
            catch (CoreException e) {
                TasksUiInternal.displayStatus(Messages.CloneTaskAction_Clone_Task_Failed, e.getStatus());
                continue;
            }
            if (taskData != null) {
                AbstractRepositoryConnector connector = TasksUi.getRepositoryConnector(taskData.getConnectorKind());
                ITaskMapping mapping = connector.getTaskMapping(taskData);
                if (mapping.getDescription() != null) {
                    taskSelection.setDescription(String.valueOf(description) + "\n\n" + mapping.getDescription());
                    TaskAttribute attrDescription = mapping.getTaskData().getRoot().getMappedAttribute("task.common.description");
                    if (attrDescription != null) {
                        attrDescription.getMetaData().setReadOnly(false);
                    }
                }
                mapping.merge((ITaskMapping)taskSelection);
                taskSelection = mapping;
            }
            if (TasksUiUtil.openNewTaskEditor(shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (ITaskMapping)taskSelection, null)) continue;
            return;
        }
    }

    public void init(IViewPart view) {
    }
}

