/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.ui.actions.Messages;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public class OpenTaskListElementAction
extends BaseSelectionListenerAction {
    public static final String ID = "org.eclipse.mylyn.tasklist.actions.open";
    private AbstractTreeViewer viewer;

    public OpenTaskListElementAction() {
        super(Messages.OpenTaskListElementAction_Open);
        this.setToolTipText(Messages.OpenTaskListElementAction_Open_Task_List_Element);
        this.setId(ID);
    }

    public AbstractTreeViewer getViewer() {
        return this.viewer;
    }

    public void setViewer(AbstractTreeViewer viewer) {
        this.viewer = viewer;
    }

    public void run() {
        this.runWithEvent(null);
    }

    public void runWithEvent(Event event) {
        for (Object element : this.getStructuredSelection().toList()) {
            if (element instanceof ITask && event != null && (event.keyCode & SWT.MOD1) != 0) {
                TasksUiInternal.openTaskInBackground((ITask)((AbstractTask)element), true);
                continue;
            }
            if (element instanceof ITask) {
                TasksUiInternal.refreshAndOpenTaskListElement((IRepositoryElement)((ITask)element));
                continue;
            }
            if (this.viewer == null) continue;
            if (this.viewer.getExpandedState(element)) {
                this.viewer.collapseToLevel(element, 1);
                continue;
            }
            this.viewer.expandToLevel(element, 1);
        }
    }
}

