/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.tasks.ui.editors.DateAttributeEditor;
import org.eclipse.mylyn.internal.tasks.ui.editors.EditorUtil;
import org.eclipse.mylyn.internal.tasks.ui.editors.Messages;
import org.eclipse.mylyn.internal.tasks.ui.editors.PriorityAttributeEditor;
import org.eclipse.mylyn.internal.tasks.ui.editors.RichTextAttributeEditor;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPart;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class TaskEditorSummaryPart
extends AbstractTaskEditorPart {
    private AbstractAttributeEditor summaryEditor;

    public TaskEditorSummaryPart() {
        this.setPartName(Messages.TaskEditorSummaryPart_Summary);
    }

    private void addAttribute(Composite composite, FormToolkit toolkit, TaskAttribute attribute) {
        this.addAttribute(composite, toolkit, attribute, 6);
    }

    private void addAttribute(Composite composite, FormToolkit toolkit, TaskAttribute attribute, int indent) {
        this.addAttribute(composite, toolkit, attribute, indent, true);
    }

    private void addAttribute(Composite composite, FormToolkit toolkit, TaskAttribute attribute, int indent, boolean showLabel) {
        AbstractAttributeEditor editor = this.createAttributeEditor(attribute);
        if (editor != null) {
            Image image;
            ITask.PriorityLevel priorityLevel;
            ITaskMapping mapping;
            editor.setReadOnly(true);
            editor.setDecorationEnabled(false);
            boolean isPriority = this.isAttribute(attribute, "task.common.priority");
            if (showLabel && !isPriority) {
                editor.createLabelControl(composite, toolkit);
                GridDataFactory.defaultsFor((Control)editor.getLabelControl()).indent(indent, 0).applyTo((Control)editor.getLabelControl());
            }
            if (isPriority && (mapping = this.getTaskEditorPage().getConnector().getTaskMapping(this.getTaskData())) != null && (priorityLevel = mapping.getPriorityLevel()) != null && (image = CommonImages.getImage((ImageDescriptor)TasksUiInternal.getPriorityImage(this.getTaskEditorPage().getTask()))) != null) {
                Label label = toolkit.createLabel(composite, null);
                label.setImage(image);
                GridDataFactory.defaultsFor((Control)label).indent(5, -3).applyTo((Control)label);
            }
            if (this.isAttribute(attribute, "task.common.date.modified") && editor instanceof DateAttributeEditor) {
                ((DateAttributeEditor)editor).setShowTime(true);
            }
            editor.createControl(composite, toolkit);
            this.getTaskEditorPage().getAttributeEditorToolkit().adapt(editor);
        }
    }

    protected Control addAttributeWithIcon(Composite composite, FormToolkit toolkit, TaskAttribute attribute, boolean forceReadOnly) {
        if (attribute != null) {
            PriorityAttributeEditor editor = new PriorityAttributeEditor(this.getModel(), attribute);
            if (editor != null) {
                editor.setDecorationEnabled(false);
                if (forceReadOnly) {
                    editor.setReadOnly(true);
                }
                ((AbstractAttributeEditor)editor).createControl(composite, toolkit);
                this.getTaskEditorPage().getAttributeEditorToolkit().adapt(editor);
            }
            return editor.getControl();
        }
        Label imageOnly = toolkit.createLabel(composite, "");
        imageOnly.setImage(CommonImages.getImage((ImageDescriptor)CommonImages.PRIORITY_3_LARGE));
        return imageOnly;
    }

    private boolean isAttribute(TaskAttribute attribute, String id) {
        return attribute.getId().equals(attribute.getTaskData().getAttributeMapper().mapToRepositoryKey(attribute.getParentAttribute(), id));
    }

    private void addSummaryText(Composite composite, FormToolkit toolkit) {
        this.summaryEditor = this.createAttributeEditor(this.getTaskData().getRoot().getMappedAttribute("task.common.summary"));
        if (this.summaryEditor != null) {
            if (this.summaryEditor instanceof RichTextAttributeEditor) {
                Composite roundedBorder = EditorUtil.createBorder(composite, toolkit, !this.summaryEditor.isReadOnly());
                this.summaryEditor.createControl(roundedBorder, toolkit);
                EditorUtil.setHeaderFontSizeAndStyle(this.summaryEditor.getControl());
            } else {
                Composite border = toolkit.createComposite(composite);
                GridDataFactory.fillDefaults().align(4, 1).hint(300, -1).grab(true, false).applyTo((Control)border);
                border.setLayout((Layout)GridLayoutFactory.fillDefaults().margins(1, 4).create());
                this.summaryEditor.createControl(border, toolkit);
                GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo(this.summaryEditor.getControl());
                toolkit.paintBordersFor(border);
            }
            this.getTaskEditorPage().getAttributeEditorToolkit().adapt(this.summaryEditor);
        }
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        Composite composite = toolkit.createComposite(parent);
        GridLayout layout = EditorUtil.createSectionClientLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginTop = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 3;
        composite.setLayout((Layout)layout);
        TaskAttribute priorityAttribute = this.getTaskData().getRoot().getMappedAttribute("task.common.priority");
        final Control priorityEditor = this.addAttributeWithIcon(composite, toolkit, priorityAttribute, false);
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).span(1, 2).applyTo(priorityEditor);
        priorityEditor.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                if (TaskEditorSummaryPart.this.summaryEditor != null && TaskEditorSummaryPart.this.summaryEditor.getControl() != null) {
                    TaskEditorSummaryPart.this.summaryEditor.getControl().setFocus();
                    priorityEditor.removeFocusListener((FocusListener)this);
                }
            }
        });
        this.addSummaryText(composite, toolkit);
        if (this.needsHeader()) {
            this.createHeaderLayout(composite, toolkit);
        }
        toolkit.paintBordersFor(composite);
        this.setControl((Control)composite);
    }

    protected Composite createHeaderLayout(Composite composite, FormToolkit toolkit) {
        Composite headerComposite = toolkit.createComposite(composite);
        GridLayout layout = new GridLayout(1, false);
        layout.verticalSpacing = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        headerComposite.setLayout((Layout)layout);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)headerComposite);
        TaskAttribute statusAtribute = this.getTaskData().getRoot().getMappedAttribute("task.common.status");
        this.addAttribute(headerComposite, toolkit, statusAtribute, 0);
        ITaskMapping mapping = this.getTaskEditorPage().getConnector().getTaskMapping(this.getTaskData());
        if (mapping != null && mapping.getResolution() != null && mapping.getResolution().length() > 0) {
            TaskAttribute resolutionAtribute = this.getTaskData().getRoot().getMappedAttribute("task.common.resolution");
            this.addAttribute(headerComposite, toolkit, resolutionAtribute, 0, false);
        }
        TaskAttribute dateCreation = this.getTaskData().getRoot().getMappedAttribute("task.common.date.created");
        this.addAttribute(headerComposite, toolkit, dateCreation);
        TaskAttribute dateModified = this.getTaskData().getRoot().getMappedAttribute("task.common.date.modified");
        this.addAttribute(headerComposite, toolkit, dateModified);
        layout.numColumns = headerComposite.getChildren().length;
        if (layout.numColumns == 0) {
            layout.numColumns = 1;
            toolkit.createLabel(headerComposite, " ");
        }
        return headerComposite;
    }

    public boolean needsHeader() {
        return !this.getTaskData().isNew();
    }

    public void setFocus() {
        if (this.summaryEditor != null) {
            this.summaryEditor.getControl().setFocus();
        }
    }
}

