/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskCategory;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.LocalTask;
import org.eclipse.mylyn.internal.tasks.core.ScheduledTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.TaskCategory;
import org.eclipse.mylyn.internal.tasks.core.UncategorizedTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.UnmatchedTaskContainer;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.util.AbstractRetrieveTitleFromUrlJob;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.internal.tasks.ui.views.Messages;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskScheduleContentProvider;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskContainer;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.dnd.URLTransfer;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskListDropAdapter
extends ViewerDropAdapter {
    private boolean fileTransfer;
    private boolean localTransfer;

    public TaskListDropAdapter(Viewer viewer) {
        super(viewer);
        this.setFeedbackEnabled(true);
    }

    public void dragOver(DropTargetEvent event) {
        if (event.detail == 0 && (event.operations & 4) == 4) {
            event.detail = 4;
        }
        super.dragOver(event);
    }

    /*
     * WARNING - void declaration
     */
    public boolean performDrop(Object data) {
        Object currentTarget;
        ArrayList<ITask> tasksToMove = new ArrayList<ITask>();
        if (this.localTransfer) {
            ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
            if (selection instanceof IStructuredSelection) {
                for (Object item : (IStructuredSelection)selection) {
                    if (!(item instanceof ITask)) continue;
                    tasksToMove.add((ITask)item);
                }
            }
        } else if (!this.fileTransfer && data instanceof String) {
            void var4_7;
            String text = (String)data;
            AbstractTask abstractTask = this.createTaskFromUrl(text);
            if (abstractTask == null) {
                LocalTask localTask = TasksUiInternal.createNewLocalTask(text);
            }
            if (var4_7 != null) {
                tasksToMove.add((ITask)var4_7);
                void newTask = var4_7;
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable((ITask)newTask){
                    private final /* synthetic */ ITask val$newTask;
                    {
                        this.val$newTask = iTask;
                    }

                    public void run() {
                        TasksUiUtil.openTask(this.val$newTask);
                    }
                });
            }
        }
        if ((currentTarget = this.getCurrentTarget()) instanceof LocalTask && this.areAllLocalTasks(tasksToMove) && this.getCurrentLocation() == 3) {
            for (ITask iTask : tasksToMove) {
                if (((AbstractTask)iTask).contains(((LocalTask)currentTarget).getHandleIdentifier())) continue;
                TasksUiInternal.getTaskList().addTask(iTask, (AbstractTaskContainer)((LocalTask)currentTarget));
            }
        } else {
            for (ITask iTask : tasksToMove) {
                if (currentTarget instanceof UncategorizedTaskContainer) {
                    TasksUiInternal.getTaskList().addTask(iTask, (AbstractTaskContainer)((UncategorizedTaskContainer)currentTarget));
                    continue;
                }
                if (currentTarget instanceof TaskCategory) {
                    TasksUiInternal.getTaskList().addTask(iTask, (AbstractTaskContainer)((TaskCategory)currentTarget));
                    continue;
                }
                if (currentTarget instanceof UnmatchedTaskContainer) {
                    if (!((UnmatchedTaskContainer)currentTarget).getRepositoryUrl().equals(iTask.getRepositoryUrl())) continue;
                    TasksUiInternal.getTaskList().addTask(iTask, (AbstractTaskContainer)((AbstractTaskCategory)currentTarget));
                    continue;
                }
                if (currentTarget instanceof ITask) {
                    ITask targetTask = (ITask)currentTarget;
                    AbstractTaskCategory targetCategory = null;
                    AbstractTaskCategory container = TaskCategory.getParentTaskCategory((ITask)targetTask);
                    if (container instanceof TaskCategory || container instanceof UncategorizedTaskContainer) {
                        targetCategory = container;
                    } else if (container instanceof UnmatchedTaskContainer && ((UnmatchedTaskContainer)container).getRepositoryUrl().equals(iTask.getRepositoryUrl())) {
                        targetCategory = container;
                    }
                    if (targetCategory == null) continue;
                    TasksUiInternal.getTaskList().addTask(iTask, (AbstractTaskContainer)targetCategory);
                    continue;
                }
                if (currentTarget instanceof ScheduledTaskContainer) {
                    ScheduledTaskContainer container = (ScheduledTaskContainer)currentTarget;
                    if (container instanceof TaskScheduleContentProvider.Unscheduled) {
                        TasksUiPlugin.getTaskActivityManager().setScheduledFor((AbstractTask)iTask, null);
                        continue;
                    }
                    TasksUiPlugin.getTaskActivityManager().setScheduledFor((AbstractTask)iTask, container.getDateRange());
                    continue;
                }
                if (currentTarget != null) continue;
                TasksUiInternal.getTaskList().addTask(iTask, (AbstractTaskContainer)TasksUiPlugin.getTaskList().getDefaultCategory());
            }
        }
        if (tasksToMove.size() == 1) {
            this.getViewer().setSelection((ISelection)new StructuredSelection(tasksToMove.get(0)));
        }
        return true;
    }

    private boolean areAllLocalTasks(List<ITask> tasksToMove) {
        for (ITask task : tasksToMove) {
            if (task instanceof LocalTask) continue;
            return false;
        }
        return true;
    }

    private AbstractTask createTaskFromUrl(String data) {
        if (!data.startsWith("http://") && !data.startsWith("https://")) {
            return null;
        }
        String[] urlTransfer = data.split("\n");
        if (urlTransfer.length > 0) {
            String url = urlTransfer[0];
            AbstractRepositoryConnector connector = TasksUiPlugin.getRepositoryManager().getConnectorForRepositoryTaskUrl(url);
            if (connector != null) {
                String taskId;
                String repositoryUrl = connector.getRepositoryUrlFromTaskUrl(url);
                AbstractTask task = TasksUiInternal.getTask(repositoryUrl, taskId = connector.getTaskIdFromTaskUrl(url), url);
                if (task != null) {
                    return task;
                }
                if (repositoryUrl != null && taskId != null) {
                    TasksUiInternal.openRepositoryTask(connector.getConnectorKind(), repositoryUrl, taskId);
                }
            } else {
                final String summary = Messages.TaskListDropAdapter__retrieving_from_URL_;
                final LocalTask newTask = TasksUiInternal.createNewLocalTask(summary);
                newTask.setUrl(url);
                AbstractRetrieveTitleFromUrlJob job = new AbstractRetrieveTitleFromUrlJob(url){

                    protected void titleRetrieved(String pageTitle) {
                        if (newTask.getSummary().equals(summary)) {
                            newTask.setSummary(pageTitle);
                            TasksUiInternal.getTaskList().notifyElementChanged((IRepositoryElement)newTask);
                        }
                    }
                };
                job.schedule();
                return newTask;
            }
        }
        return null;
    }

    public boolean validateDrop(Object targetObject, int operation, TransferData transferType) {
        this.fileTransfer = false;
        this.localTransfer = false;
        if (FileTransfer.getInstance().isSupportedType(transferType)) {
            this.fileTransfer = true;
            return false;
        }
        if (LocalSelectionTransfer.getTransfer().isSupportedType(transferType)) {
            this.localTransfer = true;
            if (this.getCurrentTarget() instanceof UncategorizedTaskContainer || this.getCurrentTarget() instanceof TaskCategory || this.getCurrentTarget() instanceof UnmatchedTaskContainer || this.getCurrentTarget() instanceof ScheduledTaskContainer) {
                return true;
            }
            if (this.getCurrentTarget() instanceof ITaskContainer && (this.getCurrentLocation() == 2 || this.getCurrentLocation() == 1)) {
                return true;
            }
            return this.getCurrentTarget() instanceof LocalTask && this.getCurrentLocation() == 3;
        }
        if (URLTransfer.getInstance().isSupportedType(transferType)) {
            return true;
        }
        return TextTransfer.getInstance().isSupportedType(transferType);
    }
}

