/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.ui.viewer;

import java.util.Iterator;
import junit.framework.TestCase;
import org.eclipse.mylyn.internal.wikitext.core.util.css.CssParser;
import org.eclipse.mylyn.internal.wikitext.core.util.css.CssRule;
import org.eclipse.mylyn.internal.wikitext.ui.viewer.CssStyleManager;
import org.eclipse.mylyn.internal.wikitext.ui.viewer.FontState;
import org.eclipse.mylyn.wikitext.tests.HeadRequired;
import org.eclipse.swt.graphics.RGB;

@HeadRequired
public class CssStyleManagerTest
extends TestCase {
    private CssStyleManager cssStyleManager;

    public void setUp() {
        this.cssStyleManager = new CssStyleManager();
    }

    public void testColorToRgb() {
        Integer white = CssStyleManager.cssColorRgb((String)"white");
        CssStyleManagerTest.assertNotNull((Object)white);
        Integer white2 = CssStyleManager.cssColorRgb((String)"White");
        CssStyleManagerTest.assertNotNull((Object)white2);
        Integer white3 = CssStyleManager.cssColorRgb((String)"#FFFFFF");
        CssStyleManagerTest.assertNotNull((Object)white3);
        Integer white4 = CssStyleManager.cssColorRgb((String)"rgb(255,255,255)");
        CssStyleManagerTest.assertNotNull((Object)white4);
        CssStyleManagerTest.assertEquals((Object)white, (Object)white2);
        CssStyleManagerTest.assertEquals((Object)white, (Object)white3);
        CssStyleManagerTest.assertEquals((Object)white, (Object)white4);
    }

    public void processCssStyles(FontState state, FontState parentState, String cssStyles) {
        Iterator ruleIterator = new CssParser().createRuleIterator(cssStyles);
        while (ruleIterator.hasNext()) {
            this.cssStyleManager.processCssStyles(state, parentState, (CssRule)ruleIterator.next());
        }
    }

    public void testProcessCssStyles() {
        FontState defaultState = new FontState();
        defaultState.size = 12.0f;
        FontState state = new FontState();
        this.processCssStyles(state, defaultState, "font-size: 14px;color: rgb(3,3,3);font-style: italic bold;text-decoration: underline; background-color: blue;");
        CssStyleManagerTest.assertEquals((Object)Float.valueOf(14.0f), (Object)Float.valueOf(state.size));
        CssStyleManagerTest.assertEquals((Object)new RGB(0, 0, 255), (Object)state.background);
        CssStyleManagerTest.assertEquals((Object)new RGB(3, 3, 3), (Object)state.foreground);
        CssStyleManagerTest.assertTrue((boolean)state.isBold());
        CssStyleManagerTest.assertTrue((boolean)state.isItalic());
        CssStyleManagerTest.assertTrue((boolean)state.isUnderline());
    }

    public void testProcessCssStylesNoStyles() {
        FontState defaultState = new FontState();
        defaultState.size = 12.0f;
        FontState state = new FontState();
        CssStyleManagerTest.assertEquals((Object)Float.valueOf(0.0f), (Object)Float.valueOf(state.size));
        CssStyleManagerTest.assertEquals(null, (Object)state.background);
        CssStyleManagerTest.assertEquals(null, (Object)state.foreground);
        CssStyleManagerTest.assertFalse((boolean)state.isBold());
        CssStyleManagerTest.assertFalse((boolean)state.isItalic());
        CssStyleManagerTest.assertFalse((boolean)state.isUnderline());
        CssStyleManagerTest.assertFalse((boolean)state.isFixedWidth());
        CssStyleManagerTest.assertFalse((boolean)state.isStrikethrough());
        CssStyleManagerTest.assertFalse((boolean)state.isSubscript());
        CssStyleManagerTest.assertFalse((boolean)state.isSuperscript());
        CssStyleManagerTest.assertEquals((Object)new FontState(), (Object)state);
        this.processCssStyles(state, defaultState, "");
        CssStyleManagerTest.assertEquals((Object)Float.valueOf(0.0f), (Object)Float.valueOf(state.size));
        CssStyleManagerTest.assertEquals(null, (Object)state.background);
        CssStyleManagerTest.assertEquals(null, (Object)state.foreground);
        CssStyleManagerTest.assertFalse((boolean)state.isBold());
        CssStyleManagerTest.assertFalse((boolean)state.isItalic());
        CssStyleManagerTest.assertFalse((boolean)state.isUnderline());
        CssStyleManagerTest.assertFalse((boolean)state.isFixedWidth());
        CssStyleManagerTest.assertFalse((boolean)state.isStrikethrough());
        CssStyleManagerTest.assertFalse((boolean)state.isSubscript());
        CssStyleManagerTest.assertFalse((boolean)state.isSuperscript());
        CssStyleManagerTest.assertEquals((Object)new FontState(), (Object)state);
    }
}

