/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.monitor.usage;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.net.HtmlStreamTokenizer;
import org.eclipse.mylyn.internal.commons.core.XmlStringConverter;
import org.eclipse.mylyn.internal.monitor.usage.InteractionEventObfuscator;
import org.eclipse.mylyn.internal.monitor.usage.Messages;
import org.eclipse.mylyn.internal.monitor.usage.UiUsageMonitorPlugin;
import org.eclipse.mylyn.monitor.core.AbstractMonitorLog;
import org.eclipse.mylyn.monitor.core.IInteractionEventListener;
import org.eclipse.mylyn.monitor.core.InteractionEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InteractionEventLogger
extends AbstractMonitorLog
implements IInteractionEventListener {
    private int eventAccumulartor = 0;
    private final List<InteractionEvent> queue = new CopyOnWriteArrayList<InteractionEvent>();
    private final InteractionEventObfuscator handleObfuscator = new InteractionEventObfuscator();
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S z", Locale.ENGLISH);
    private static final String OPEN = "<";
    private static final String CLOSE = ">";
    private static final String SLASH = "/";
    private static final String ENDL = "\n";
    private static final String TAB = "\t";

    public InteractionEventLogger(File outputFile) {
        this.outputFile = outputFile;
    }

    public synchronized void interactionObserved(InteractionEvent event) {
        if (UiUsageMonitorPlugin.getDefault() == null) {
            StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.monitor.usage", "Attempted to log event before usage monitor start"));
        }
        if (UiUsageMonitorPlugin.getDefault().isObfuscationEnabled()) {
            String obfuscatedHandle = this.handleObfuscator.obfuscateHandle(event.getStructureKind(), event.getStructureHandle());
            event = new InteractionEvent(event.getKind(), event.getStructureKind(), obfuscatedHandle, event.getOriginId(), event.getNavigation(), event.getDelta(), event.getInterestContribution());
        }
        try {
            if (this.started) {
                String xml = this.getXmlForEvent(event);
                this.outputStream.write(xml.getBytes());
            } else if (event != null) {
                this.queue.add(event);
            }
            ++this.eventAccumulartor;
        }
        catch (Throwable t) {
            StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.monitor.usage", "Could not log interaction event", t));
        }
    }

    public void startMonitoring() {
        super.startMonitoring();
        for (InteractionEvent queuedEvent : this.queue) {
            this.interactionObserved(queuedEvent);
        }
        this.queue.clear();
    }

    public void stopMonitoring() {
        super.stopMonitoring();
        if (UiUsageMonitorPlugin.getDefault() != null) {
            UiUsageMonitorPlugin.getDefault().incrementObservedEvents(this.eventAccumulartor);
        }
        this.eventAccumulartor = 0;
    }

    private String getXmlForEvent(InteractionEvent event) {
        return this.writeLegacyEvent(event);
    }

    public synchronized void clearInteractionHistory() throws IOException {
        this.clearInteractionHistory(true);
    }

    public synchronized void clearInteractionHistory(boolean startMonitoring) throws IOException {
        this.stopMonitoring();
        this.outputStream = new FileOutputStream(this.outputFile, false);
        this.outputStream.flush();
        this.outputStream.close();
        this.outputFile.delete();
        this.outputFile.createNewFile();
        if (startMonitoring) {
            this.startMonitoring();
        }
    }

    public List<InteractionEvent> getHistoryFromFile(File file) {
        return this.getHistoryFromFile(file, (IProgressMonitor)new NullProgressMonitor());
    }

    public List<InteractionEvent> getHistoryFromFile(File file, IProgressMonitor monitor) {
        ArrayList<InteractionEvent> events;
        block17: {
            events = new ArrayList<InteractionEvent>();
            InputStream inputStream = null;
            long fileLength = 0L;
            try {
                try {
                    if (file.getName().endsWith(".zip")) {
                        ZipFile zip = new ZipFile(file);
                        if (zip.entries().hasMoreElements()) {
                            ZipEntry entry = zip.entries().nextElement();
                            inputStream = zip.getInputStream(entry);
                            fileLength = entry.getSize();
                        }
                    } else {
                        inputStream = new FileInputStream(file);
                        fileLength = file.length();
                    }
                    int numberOfEventsEstimate = (int)(fileLength / 450L);
                    monitor.beginTask(Messages.InteractionEventLogger_Reading_History_From_File, numberOfEventsEstimate);
                    this.getHistoryFromStream(inputStream, events, monitor);
                }
                catch (Exception e) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.monitor.usage", "Could not read interaction history", (Throwable)e));
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException e2) {
                            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.monitor.usage", "unable to close input stream", (Throwable)e2));
                        }
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.monitor.usage", "unable to close input stream", (Throwable)e));
                    }
                }
                throw throwable;
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.monitor.usage", "unable to close input stream", (Throwable)e));
                }
            }
        }
        monitor.done();
        return events;
    }

    private void getHistoryFromStream(InputStream reader, List<InteractionEvent> events, IProgressMonitor monitor) throws IOException {
        String buf = "";
        String tag = "</interactionEvent>";
        String endl = "\r\n";
        byte[] buffer = new byte[1000];
        int bytesRead = 0;
        while ((bytesRead = reader.read(buffer)) != -1) {
            int index;
            buf = String.valueOf(buf) + new String(buffer, 0, bytesRead);
            while ((index = buf.indexOf(tag)) != -1) {
                String xml = buf.substring(0, index += tag.length());
                InteractionEvent event = this.readLegacyEvent(xml);
                if (event != null) {
                    events.add(event);
                }
                buf = index + endl.length() > buf.length() ? "" : buf.substring(index + endl.length(), buf.length());
                monitor.worked(1);
            }
            buffer = new byte[1000];
        }
    }

    @Deprecated
    public String writeLegacyEvent(InteractionEvent e) {
        try {
            StringBuffer res = new StringBuffer();
            String tag = "interactionEvent";
            res.append(OPEN);
            res.append(tag);
            res.append(CLOSE);
            res.append(ENDL);
            this.openElement(res, "kind");
            this.formatContent(res, e.getKind());
            this.closeElement(res, "kind");
            this.openElement(res, "date");
            this.formatContent(res, e.getDate());
            this.closeElement(res, "date");
            this.openElement(res, "endDate");
            this.formatContent(res, e.getEndDate());
            this.closeElement(res, "endDate");
            this.openElement(res, "originId");
            this.formatContent(res, e.getOriginId());
            this.closeElement(res, "originId");
            this.openElement(res, "structureKind");
            this.formatContent(res, e.getStructureKind());
            this.closeElement(res, "structureKind");
            this.openElement(res, "structureHandle");
            this.formatContent(res, e.getStructureHandle());
            this.closeElement(res, "structureHandle");
            this.openElement(res, "navigation");
            this.formatContent(res, e.getNavigation());
            this.closeElement(res, "navigation");
            this.openElement(res, "delta");
            this.formatContent(res, e.getDelta());
            this.closeElement(res, "delta");
            this.openElement(res, "interestContribution");
            this.formatContent(res, e.getInterestContribution());
            this.closeElement(res, "interestContribution");
            res.append(OPEN);
            res.append(SLASH);
            res.append(tag);
            res.append(CLOSE);
            res.append(ENDL);
            return res.toString();
        }
        catch (Throwable t) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.monitor.usage", "Could not write event", t));
            return "";
        }
    }

    private void formatContent(StringBuffer buffer, float interestContribution) {
        buffer.append(interestContribution);
    }

    private void formatContent(StringBuffer buffer, String content) {
        if (content != null && content.length() > 0) {
            String xmlContent = XmlStringConverter.convertToXmlString((String)content);
            xmlContent = xmlContent.replace(ENDL, "\n\t\t");
            buffer.append(xmlContent);
        }
    }

    private void formatContent(StringBuffer buffer, InteractionEvent.Kind kind) {
        buffer.append(kind.toString());
    }

    private void formatContent(StringBuffer buffer, Date date) {
        buffer.append(dateFormat.format(date));
    }

    private void openElement(StringBuffer buffer, String tag) {
        buffer.append(TAB);
        buffer.append(OPEN);
        buffer.append(tag);
        buffer.append(CLOSE);
    }

    private void closeElement(StringBuffer buffer, String tag) {
        buffer.append(OPEN);
        buffer.append(SLASH);
        buffer.append(tag);
        buffer.append(CLOSE);
        buffer.append(ENDL);
    }

    public InteractionEvent readLegacyEvent(String xml) {
        StringReader reader = new StringReader(xml);
        HtmlStreamTokenizer tokenizer = new HtmlStreamTokenizer((Reader)reader, null);
        String kind = "";
        String startDate = "";
        String endDate = "";
        String originId = "";
        String structureKind = "";
        String structureHandle = "";
        String navigation = "";
        String delta = "";
        String interest = "";
        try {
            HtmlStreamTokenizer.Token token = tokenizer.nextToken();
            while (token.getType() != HtmlStreamTokenizer.Token.EOF) {
                if (token.getValue().toString().equals("<kind>")) {
                    kind = this.readStringContent(tokenizer, "</kind>");
                    kind = kind.toLowerCase(Locale.ENGLISH);
                } else if (token.getValue().toString().equals("<date>")) {
                    startDate = this.readStringContent(tokenizer, "</date>");
                } else if (token.getValue().toString().equals("<endDate>")) {
                    endDate = this.readStringContent(tokenizer, "</endDate>");
                } else if (token.getValue().toString().equals("<originId>")) {
                    originId = this.readStringContent(tokenizer, "</originId>");
                } else if (token.getValue().toString().equals("<structureKind>")) {
                    structureKind = this.readStringContent(tokenizer, "</structureKind>");
                } else if (token.getValue().toString().equals("<structureHandle>")) {
                    structureHandle = this.readStringContent(tokenizer, "</structureHandle>");
                } else if (token.getValue().toString().equals("<navigation>")) {
                    navigation = this.readStringContent(tokenizer, "</navigation>");
                } else if (token.getValue().toString().equals("<delta>")) {
                    delta = this.readStringContent(tokenizer, "</delta>");
                } else if (token.getValue().toString().equals("<interestContribution>")) {
                    interest = this.readStringContent(tokenizer, "</interestContribution>");
                }
                token = tokenizer.nextToken();
            }
            float interestFloatVal = 0.0f;
            try {
                interestFloatVal = Float.parseFloat(interest);
            }
            catch (NumberFormatException numberFormatException) {}
            InteractionEvent event = new InteractionEvent(InteractionEvent.Kind.fromString((String)kind), structureKind, structureHandle, originId, navigation, delta, interestFloatVal, dateFormat.parse(startDate), dateFormat.parse(endDate));
            return event;
        }
        catch (ParseException e) {
            System.err.println("readevent: " + xml);
            e.printStackTrace();
        }
        catch (IOException e) {
            System.err.println("readevent: " + xml);
            e.printStackTrace();
        }
        catch (Exception e) {
            System.err.println("readevent: " + xml);
            e.printStackTrace();
        }
        return null;
    }

    private String readStringContent(HtmlStreamTokenizer tokenizer, String endTag) throws IOException, ParseException {
        StringBuffer content = new StringBuffer();
        HtmlStreamTokenizer.Token token = tokenizer.nextToken();
        while (!token.getValue().toString().equals(endTag)) {
            if (content.length() > 0) {
                content.append(' ');
            }
            content.append(token.getValue().toString());
            token = tokenizer.nextToken();
        }
        return XmlStringConverter.convertXmlToString((String)content.toString()).trim();
    }

    public static DateFormat dateFormat() {
        return (DateFormat)dateFormat.clone();
    }
}

