/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.monitor.usage;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.monitor.usage.StudyParameters;
import org.eclipse.mylyn.monitor.usage.AbstractStudyBackgroundPage;
import org.eclipse.mylyn.monitor.usage.AbstractStudyQuestionnairePage;

class UiUsageMonitorExtensionPointReader {
    public static final String EXTENSION_ID_STUDY = "org.eclipse.mylyn.monitor.usage.study";
    public static final String ELEMENT_SCRIPTS = "scripts";
    public static final String ELEMENT_SCRIPTS_VERSION = "version";
    public static final String ELEMENT_SCRIPTS_SERVER_URL = "url";
    public static final String ELEMENT_SCRIPTS_UPLOAD_USAGE = "upload";
    public static final String ELEMENT_SCRIPTS_GET_USER_ID = "userId";
    public static final String ELEMENT_SCRIPTS_FORCE_OBFUSCATION = "forceObfuscation";
    public static final String ELEMENT_UI = "ui";
    public static final String ELEMENT_UI_TITLE = "title";
    public static final String ELEMENT_UI_STUDY_NAME = "studyName";
    public static final String ELEMENT_UI_DESCRIPTION = "description";
    public static final String ELEMENT_UI_UPLOAD_PROMPT = "daysBetweenUpload";
    public static final String ELEMENT_UI_QUESTIONNAIRE_PAGE = "questionnairePage";
    public static final String ELEMENT_UI_BACKGROUND_PAGE = "backgroundPage";
    public static final String ELEMENT_UI_CONSENT_FORM = "consentForm";
    public static final String ELEMENT_UI_CONTACT_CONSENT_FIELD = "useContactField";
    public static final String ELEMENT_UI_URL_USAGE_PAGE = "usagePageUrl";
    public static final String ELEMENT_UI_PROMPT_FOR_SUBMISSION = "promptForSubmission";
    public static final String ELEMENT_MONITORS = "monitors";
    public static final String ELEMENT_MONITORS_BROWSER_URL = "browserUrlFilter";
    public static final String ELEMENT_FILTER = "filter";
    public static final String ELEMENT_FILTER_ID_PREFIX = "idPrefix";
    private boolean extensionsRead = false;
    private StudyParameters studyParameters;

    UiUsageMonitorExtensionPointReader() {
    }

    public synchronized StudyParameters getStudyParameters() {
        if (!this.extensionsRead) {
            this.initExtensions();
        }
        return this.studyParameters;
    }

    private void initExtensions() {
        try {
            IExtensionRegistry registry;
            IExtensionPoint extensionPoint;
            if (!this.extensionsRead && (extensionPoint = (registry = Platform.getExtensionRegistry()).getExtensionPoint(EXTENSION_ID_STUDY)) != null) {
                IExtension[] extensions;
                IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
                if (extensions.length != 0) {
                    IConfigurationElement[] elements;
                    IExtension extension = iExtensionArray[0];
                    this.studyParameters = new StudyParameters();
                    IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
                    int n = elements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IConfigurationElement element = iConfigurationElementArray[n2];
                        if (element.getName().compareTo(ELEMENT_SCRIPTS) == 0) {
                            this.readScripts(element);
                        } else if (element.getName().compareTo(ELEMENT_UI) == 0) {
                            this.readForms(element);
                        } else if (element.getName().compareTo(ELEMENT_MONITORS) == 0) {
                            this.readMonitors(element);
                        } else if (element.getName().compareTo(ELEMENT_FILTER) == 0) {
                            this.readFilter(element);
                        }
                        ++n2;
                    }
                    this.studyParameters.setCustomizingPlugin(extension.getContributor().getName());
                }
                this.extensionsRead = true;
            }
        }
        catch (Throwable t) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.monitor.usage", "Could not read monitor extension", t));
        }
    }

    private void readFilter(IConfigurationElement element) {
        this.studyParameters.addFilteredIdPattern(element.getAttribute(ELEMENT_FILTER_ID_PREFIX));
    }

    private void readScripts(IConfigurationElement element) {
        this.studyParameters.setVersion(element.getAttribute(ELEMENT_SCRIPTS_VERSION));
        String serverUrl = element.getAttribute(ELEMENT_SCRIPTS_SERVER_URL);
        String userIdScript = element.getAttribute(ELEMENT_SCRIPTS_GET_USER_ID);
        String usageUploadScript = element.getAttribute(ELEMENT_SCRIPTS_UPLOAD_USAGE);
        String forceObfuscationString = element.getAttribute(ELEMENT_SCRIPTS_FORCE_OBFUSCATION);
        this.studyParameters.setUploadServletUrl(String.valueOf(serverUrl) + usageUploadScript);
        this.studyParameters.setUserIdServletUrl(String.valueOf(serverUrl) + userIdScript);
        this.studyParameters.setForceObfuscation(Boolean.parseBoolean(forceObfuscationString));
    }

    private void readForms(IConfigurationElement element) throws CoreException {
        Object page;
        this.studyParameters.setUsagePageUrl(element.getAttribute(ELEMENT_UI_URL_USAGE_PAGE));
        this.studyParameters.setStudyName(element.getAttribute(ELEMENT_UI_STUDY_NAME));
        this.studyParameters.setTitle(element.getAttribute(ELEMENT_UI_TITLE));
        this.studyParameters.setDescription(element.getAttribute(ELEMENT_UI_DESCRIPTION));
        this.studyParameters.setPromptForSubmission(Boolean.parseBoolean(element.getAttribute(ELEMENT_UI_PROMPT_FOR_SUBMISSION)));
        if (element.getAttribute(ELEMENT_UI_UPLOAD_PROMPT) != null) {
            Integer uploadInt = new Integer(element.getAttribute(ELEMENT_UI_UPLOAD_PROMPT));
            this.studyParameters.setTransmitPromptPeriod(86400000L * (long)uploadInt.intValue());
        }
        this.studyParameters.setUseContactField(element.getAttribute(ELEMENT_UI_CONTACT_CONSENT_FIELD));
        try {
            Object questionnaireObject;
            if (element.getAttribute(ELEMENT_UI_QUESTIONNAIRE_PAGE) != null && (questionnaireObject = element.createExecutableExtension(ELEMENT_UI_QUESTIONNAIRE_PAGE)) instanceof AbstractStudyQuestionnairePage) {
                page = (AbstractStudyQuestionnairePage)((Object)questionnaireObject);
                this.studyParameters.setQuestionnairePage((AbstractStudyQuestionnairePage)((Object)page));
            }
        }
        catch (Throwable e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.monitor.usage", "Could not load questionaire", e));
        }
        try {
            Object backgroundObject;
            if (element.getAttribute(ELEMENT_UI_BACKGROUND_PAGE) != null && (backgroundObject = element.createExecutableExtension(ELEMENT_UI_BACKGROUND_PAGE)) instanceof AbstractStudyBackgroundPage) {
                page = (AbstractStudyBackgroundPage)backgroundObject;
                this.studyParameters.setBackgroundPage((AbstractStudyBackgroundPage)page);
            }
        }
        catch (Throwable e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.monitor.usage", "Could not load background page", e));
        }
        this.studyParameters.setFormsConsent("/" + element.getAttribute(ELEMENT_UI_CONSENT_FORM));
    }

    private void readMonitors(IConfigurationElement element) throws CoreException {
        String urlList = element.getAttribute(ELEMENT_MONITORS_BROWSER_URL);
        this.studyParameters.setAcceptedUrlList(urlList);
    }
}

