/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.monitor.usage;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.net.AbstractWebLocation;
import org.eclipse.mylyn.commons.net.WebLocation;
import org.eclipse.mylyn.commons.net.WebUtil;
import org.eclipse.mylyn.internal.monitor.usage.Messages;
import org.eclipse.mylyn.internal.monitor.usage.StudyParameters;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PlatformUI;

public class UsageUploadManager {
    protected HttpClient httpClient = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
    private static final int SIZE_OF_INT = 8;

    public boolean uploadFile(String postUrl, File file, int uid, IProgressMonitor monitor) {
        String filename = file.getName();
        if (!filename.startsWith(String.valueOf(uid) + ".")) {
            filename = String.valueOf(uid) + "-" + filename;
        }
        return this.uploadFile(postUrl, "temp.txt", file, filename, uid, monitor);
    }

    public boolean uploadFile(String postUrl, String name, final File file, String filename, final int uid, IProgressMonitor monitor) {
        block12: {
            PostMethod filePost = new PostMethod(postUrl);
            try {
                Part[] parts = new Part[]{new FilePart(name, filename, file)};
                filePost.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, filePost.getParams()));
                WebLocation location = new WebLocation(postUrl);
                HostConfiguration hostConfiguration = WebUtil.createHostConfiguration((HttpClient)this.httpClient, (AbstractWebLocation)location, (IProgressMonitor)monitor);
                final int status = WebUtil.execute((HttpClient)this.httpClient, (HostConfiguration)hostConfiguration, (HttpMethod)filePost, (IProgressMonitor)monitor);
                if (status == 401) {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            MessageDialog.openError(null, (String)Messages.UsageUploadManager_Error_Uploading, (String)NLS.bind((String)Messages.UsageUploadManager_Error_Uploading_Uid_Incorrect, (Object)file.getName(), (Object)uid));
                        }
                    });
                    break block12;
                }
                if (status == 407) {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            MessageDialog.openError(null, (String)Messages.UsageUploadManager_Error_Uploading, (String)Messages.UsageUploadManager_Error_Uploading_Proxy_Authentication);
                        }
                    });
                    break block12;
                }
                if (status != 200) {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            MessageDialog.openError(null, (String)Messages.UsageUploadManager_Error_Uploading, (String)NLS.bind((String)Messages.UsageUploadManager_Error_Uploading_Http_Response, (Object)file.getName(), (Object)status));
                        }
                    });
                    break block12;
                }
                return true;
            }
            catch (FileNotFoundException e) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        MessageDialog.openError(null, (String)Messages.UsageUploadManager_Error_Uploading, (String)NLS.bind((String)Messages.UsageUploadManager_Error_Uploading_X_Y, (Object)file.getName(), (Object)e.getClass().getCanonicalName()));
                    }
                });
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.monitor.usage", Messages.UsageUploadManager_Error_Uploading, (Throwable)e));
            }
            catch (IOException e) {
                if (e instanceof NoRouteToHostException || e instanceof UnknownHostException) {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            MessageDialog.openError(null, (String)Messages.UsageUploadManager_Error_Uploading, (String)NLS.bind((String)Messages.UsageUploadManager_Error_Uploading_X_No_Network, (Object)file.getName()));
                        }
                    });
                } else {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            MessageDialog.openError(null, (String)Messages.UsageUploadManager_Error_Uploading, (String)NLS.bind((String)Messages.UsageUploadManager_Error_Uploading_X_Y, (Object)file.getName(), (Object)e.getClass().getCanonicalName()));
                        }
                    });
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.monitor.usage", "Error uploading", (Throwable)e));
                }
            }
            finally {
                filePost.releaseConnection();
            }
        }
        return false;
    }

    public int getExistingUid(StudyParameters studyParameters, String firstName, String lastName, String emailAddress, boolean anonymous, IProgressMonitor monitor) {
        String url = studyParameters.getUserIdServletUrl();
        GetMethod getUidMethod = new GetMethod(url);
        try {
            NameValuePair first = new NameValuePair("firstName", firstName);
            NameValuePair last = new NameValuePair("lastName", lastName);
            NameValuePair email = new NameValuePair("email", emailAddress);
            NameValuePair job = new NameValuePair("jobFunction", "");
            NameValuePair size = new NameValuePair("companySize", "");
            NameValuePair buisness = new NameValuePair("companyBuisness", "");
            NameValuePair contact = new NameValuePair("contact", "");
            NameValuePair anon = null;
            anon = anonymous ? new NameValuePair("anonymous", "true") : new NameValuePair("anonymous", "false");
            if (studyParameters.usingContactField()) {
                getUidMethod.setQueryString(new NameValuePair[]{first, last, email, job, size, buisness, anon, contact});
            } else {
                getUidMethod.setQueryString(new NameValuePair[]{first, last, email, job, size, buisness, anon});
            }
            WebLocation location = new WebLocation(url);
            HostConfiguration hostConfiguration = WebUtil.createHostConfiguration((HttpClient)this.httpClient, (AbstractWebLocation)location, (IProgressMonitor)monitor);
            final int status = WebUtil.execute((HttpClient)this.httpClient, (HostConfiguration)hostConfiguration, (HttpMethod)getUidMethod, (IProgressMonitor)monitor);
            if (status == 200) {
                int uid;
                String response = this.getStringFromStream(WebUtil.getResponseBodyAsStream((HttpMethodBase)getUidMethod, (IProgressMonitor)monitor));
                response = response.substring(response.indexOf(":") + 1).trim();
                int n = uid = Integer.parseInt(response);
                return n;
            }
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    MessageDialog.openError(null, (String)Messages.UsageUploadManager_Error_Getting_Uid, (String)NLS.bind((String)Messages.UsageUploadManager_Error_Getting_Uid_Http_Response, (Object)status));
                }
            });
            return -1;
        }
        catch (IOException e) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    MessageDialog.openError(null, (String)Messages.UsageUploadManager_Error_Uploading, (String)NLS.bind((String)Messages.UsageUploadManager_Error_Getting_UidX_Y, (Object)e.getClass().getCanonicalName(), (Object)e.getMessage()));
                }
            });
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.monitor.usage", Messages.UsageUploadManager_Error_Uploading, (Throwable)e));
        }
        catch (Exception e) {
            if (e instanceof NoRouteToHostException || e instanceof UnknownHostException) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        MessageDialog.openError(null, (String)Messages.UsageUploadManager_Error_Uploading, (String)Messages.UsageUploadManager_Error_Getting_Uid_No_Network);
                    }
                });
            } else {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        MessageDialog.openError(null, (String)Messages.UsageUploadManager_Error_Uploading, (String)NLS.bind((String)Messages.UsageUploadManager_Error_Getting_Uid_X_Y, (Object)e.getClass().getCanonicalName(), (Object)e.getMessage()));
                    }
                });
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.monitor.usage", Messages.UsageUploadManager_Error_Uploading, (Throwable)e));
            }
        }
        finally {
            getUidMethod.releaseConnection();
        }
        return -1;
    }

    private String getStringFromStream(InputStream i) throws IOException {
        String s = "";
        String data = "";
        BufferedReader br = new BufferedReader(new InputStreamReader(i));
        while ((s = br.readLine()) != null) {
            data = String.valueOf(data) + s;
        }
        return data;
    }

    public int getNewUid(StudyParameters studyParameters, IProgressMonitor monitor) {
        String url = studyParameters.getUserIdServletUrl();
        PostMethod getUserIdMethod = new PostMethod(url);
        try {
            getUserIdMethod.addParameter(new NameValuePair("MylarUserID", ""));
            WebLocation location = new WebLocation(url);
            HostConfiguration hostConfiguration = WebUtil.createHostConfiguration((HttpClient)this.httpClient, (AbstractWebLocation)location, (IProgressMonitor)monitor);
            int status = WebUtil.execute((HttpClient)this.httpClient, (HostConfiguration)hostConfiguration, (HttpMethod)getUserIdMethod, (IProgressMonitor)monitor);
            if (status == 200) {
                InputStream inputStream = WebUtil.getResponseBodyAsStream((HttpMethodBase)getUserIdMethod, (IProgressMonitor)monitor);
                byte[] buffer = new byte[8];
                int numBytesRead = inputStream.read(buffer);
                int uid = new Integer(new String(buffer, 0, numBytesRead));
                inputStream.close();
                int n = uid;
                return n;
            }
            StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.monitor.usage", "Unable to get new user id.  Server retured: " + status));
            return -1;
        }
        catch (IOException e) {
            if (e instanceof NoRouteToHostException || e instanceof UnknownHostException) {
                MessageDialog.openError(null, (String)Messages.UsageUploadManager_Error_Uploading, (String)Messages.UsageUploadManager_Error_Getting_Uid_No_Network);
            } else {
                MessageDialog.openError(null, (String)Messages.UsageUploadManager_Error_Uploading, (String)NLS.bind((String)Messages.UsageUploadManager_Error_Getting_Uid_X, (Object)e.getClass().getCanonicalName()));
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.monitor.usage", Messages.UsageUploadManager_Error_Uploading, (Throwable)e));
            }
        }
        finally {
            getUserIdMethod.releaseConnection();
        }
        return -1;
    }

    public int getNewUid(StudyParameters studyParameters, String firstName, String lastName, String emailAddress, boolean anonymous, String jobFunction, String companySize, String companyFunction, boolean contactEmail, IProgressMonitor monitor) {
        return this.getNewUid(studyParameters, monitor);
    }
}

