/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.monitor.usage.editors;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.monitor.usage.InteractionEventSummarySorter;
import org.eclipse.mylyn.internal.monitor.usage.UiUsageMonitorPlugin;
import org.eclipse.mylyn.internal.monitor.usage.common.UsageCountContentProvider;
import org.eclipse.mylyn.internal.monitor.usage.common.UsageCountLabelProvider;
import org.eclipse.mylyn.internal.monitor.usage.editors.Messages;
import org.eclipse.mylyn.internal.monitor.usage.editors.UsageEditorPart;
import org.eclipse.mylyn.internal.monitor.usage.wizards.UsageSubmissionWizard;
import org.eclipse.mylyn.internal.monitor.usage.wizards.UsageSubmissionWizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.browser.WebBrowserPreference;
import org.eclipse.ui.internal.browser.WorkbenchBrowserSupport;

public class UsageSummaryReportEditorPart
extends UsageEditorPart {
    public static final String ID = "org.eclipse.mylyn.monitor.usage.summary.editor";
    private static final long MAX_FILE_LENGTH = 0x100000L;
    private static final String DATE_FORMAT_STRING = "MMMMM d, h:mm a";
    private Table table;
    private TableViewer tableViewer;
    private final String[] columnNames = new String[]{Messages.UsageSummaryReportEditorPart_Kind, Messages.UsageSummaryReportEditorPart_Id, Messages.UsageSummaryReportEditorPart_Count};

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.sForm.setText(new SimpleDateFormat(DATE_FORMAT_STRING).format(new Date()));
    }

    protected void addSections(Composite composite, FormToolkit toolkit) {
        if (this.editorInput.getReportGenerator().getLastParsedSummary().getSingleSummaries().size() > 0) {
            this.createUsageSection(this.editorComposite, toolkit);
        }
    }

    private void createUsageSection(Composite parent, FormToolkit toolkit) {
        Section section = toolkit.createSection(parent, 256);
        section.setText(Messages.UsageSummaryReportEditorPart_Usage_Details);
        section.setLayout((Layout)new GridLayout());
        section.setLayoutData((Object)new GridData(768));
        Composite container = toolkit.createComposite((Composite)section);
        section.setClient((Control)container);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        this.createTable(container, toolkit);
        this.createTableViewer();
        toolkit.paintBordersFor(container);
    }

    protected void createActionSection(Composite parent, FormToolkit toolkit) {
        Section section = toolkit.createSection(parent, 256);
        section.setText(Messages.UsageSummaryReportEditorPart_Actions);
        section.setLayout((Layout)new GridLayout());
        section.setLayoutData((Object)new GridData(768));
        Composite topContainer = toolkit.createComposite((Composite)section);
        GridLayout topContainerLayout = new GridLayout();
        topContainerLayout.numColumns = 1;
        topContainer.setLayout((Layout)topContainerLayout);
        section.setClient((Control)topContainer);
        Composite buttonContainer = toolkit.createComposite(topContainer);
        GridLayout buttonContainerLayout = new GridLayout();
        buttonContainerLayout.numColumns = 3;
        buttonContainer.setLayout((Layout)buttonContainerLayout);
        Button submitData = toolkit.createButton(buttonContainer, String.valueOf(Messages.UsageSummaryReportEditorPart_Submit_To) + this.studyParameters.getStudyName(), 0x1000008);
        submitData.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UsageSummaryReportEditorPart.this.submitData();
            }
        });
        Button viewFile = toolkit.createButton(buttonContainer, Messages.UsageSummaryReportEditorPart_View_File, 0x1000008);
        viewFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UsageSummaryReportEditorPart.this.viewFile();
            }
        });
        Button viewStats = toolkit.createButton(buttonContainer, Messages.UsageSummaryReportEditorPart_View_Community_Statistics, 0x1000008);
        viewStats.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UsageSummaryReportEditorPart.this.viewStats();
            }
        });
        if (this.studyParameters.getUsagePageUrl() == null || this.studyParameters.getUsagePageUrl().length() == 0) {
            viewStats.setEnabled(false);
        }
        Composite labelContainer = toolkit.createComposite(topContainer);
        GridLayout labelContainerLayout = new GridLayout();
        labelContainerLayout.numColumns = 1;
        labelContainer.setLayout((Layout)labelContainerLayout);
        Label submissionLabel = new Label(labelContainer, 0);
        submissionLabel.setText(this.studyParameters.getFilteredIdSubmissionText());
    }

    private void viewStats() {
        try {
            if (WebBrowserPreference.getBrowserChoice() == 1) {
                try {
                    IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
                    support.getExternalBrowser().openURL(new URL(this.studyParameters.getUsagePageUrl()));
                }
                catch (Exception e) {
                    StatusHandler.fail((IStatus)new Status(4, "org.eclipse.mylyn.monitor.usage", "Could not open url", (Throwable)e));
                }
            } else {
                IWebBrowser browser = null;
                int flags = 0;
                flags = WorkbenchBrowserSupport.getInstance().isInternalWebBrowserAvailable() ? 38 : 134;
                String generatedId = "org.eclipse.mylyn.web.browser-" + Calendar.getInstance().getTimeInMillis();
                browser = WorkbenchBrowserSupport.getInstance().createBrowser(flags, generatedId, null, null);
                browser.openURL(new URL(this.studyParameters.getUsagePageUrl()));
            }
        }
        catch (PartInitException partInitException) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Browser init error", (String)"Browser could not be initiated");
        }
        catch (MalformedURLException malformedURLException) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.UsageSummaryReportEditorPart_Url_Not_Found, (String)Messages.UsageSummaryReportEditorPart_Url_Could_Not_Be_Opened);
        }
    }

    private void viewFile() {
        File monitorFile = UiUsageMonitorPlugin.getDefault().getMonitorLogFile();
        if (monitorFile.length() <= 0x100000L) {
            IFileStore fileStore = EFS.getLocalFileSystem().getStore((IPath)new Path(monitorFile.getAbsolutePath()));
            if (!fileStore.fetchInfo().isDirectory() && fileStore.fetchInfo().exists()) {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
                }
                catch (PartInitException partInitException) {}
            }
        } else {
            Program p;
            boolean failed = false;
            boolean bl = failed = !Program.launch((String)monitorFile.getAbsolutePath());
            if (failed && (p = Program.findProgram((String)".txt")) != null) {
                p.execute(monitorFile.getAbsolutePath());
            }
        }
    }

    private void submitData() {
        UsageSubmissionWizard submissionWizard = new UsageSubmissionWizard();
        UsageSubmissionWizardDialog dialog = new UsageSubmissionWizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)submissionWizard);
        dialog.open();
    }

    private void createTable(Composite parent, FormToolkit toolkit) {
        int style = 101124;
        this.table = toolkit.createTable(parent, style);
        TableLayout tlayout = new TableLayout();
        this.table.setLayout((Layout)tlayout);
        GridData wd = new GridData(768);
        wd.heightHint = 300;
        this.table.setLayoutData((Object)wd);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        TableColumn column = new TableColumn(this.table, 16384, 0);
        column.setText(this.columnNames[0]);
        column.setWidth(60);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UsageSummaryReportEditorPart.this.tableViewer.setSorter((ViewerSorter)new InteractionEventSummarySorter(1));
            }
        });
        column = new TableColumn(this.table, 16384, 1);
        column.setText(this.columnNames[1]);
        column.setWidth(370);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UsageSummaryReportEditorPart.this.tableViewer.setSorter((ViewerSorter)new InteractionEventSummarySorter(3));
            }
        });
        column = new TableColumn(this.table, 16384, 2);
        column.setText(this.columnNames[2]);
        column.setWidth(50);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UsageSummaryReportEditorPart.this.tableViewer.setSorter((ViewerSorter)new InteractionEventSummarySorter(4));
            }
        });
    }

    private void createTableViewer() {
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setUseHashlookup(true);
        this.tableViewer.setColumnProperties(this.columnNames);
        this.tableViewer.setContentProvider((IContentProvider)new UsageCountContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new UsageCountLabelProvider());
        this.tableViewer.setInput((Object)this.editorInput.getReportGenerator());
    }
}

