/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.monitor.usage.wizards;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.monitor.usage.StudyParameters;
import org.eclipse.mylyn.internal.monitor.usage.UiUsageMonitorPlugin;
import org.eclipse.mylyn.internal.monitor.usage.wizards.Messages;
import org.eclipse.mylyn.internal.monitor.usage.wizards.UsageSubmissionWizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class GetNewUserIdPage
extends WizardPage {
    private Text firstName;
    private Text lastName;
    private Text emailAddress;
    private Button contactAgreement;
    private Button getNewUid;
    private Button getExistingUid;
    private String first;
    private String last;
    private String email;
    private boolean contactEmail = false;
    private boolean anon;
    private boolean hasValidated = false;
    private String jobFunction = Messages.GetNewUserIdPage_Select_Below;
    private String companySize = Messages.GetNewUserIdPage_Select_Below;
    private String companyFunction = Messages.GetNewUserIdPage_Select_Below;
    private final UsageSubmissionWizard wizard;
    private final boolean performUpload;
    private boolean extendedMonitor = false;
    private final StudyParameters studyParameters;

    public GetNewUserIdPage(UsageSubmissionWizard wizard, StudyParameters studyParameters, boolean performUpload) {
        super(Messages.GetNewUserIdPage_Statistics_Wizard);
        this.studyParameters = studyParameters;
        this.performUpload = performUpload;
        this.setTitle(NLS.bind((String)Messages.GetNewUserIdPage_Get_X_Feedback_Id, (Object)studyParameters.getStudyName()));
        this.setDescription(Messages.GetNewUserIdPage_In_Order_To_Submit_User_Id);
        this.wizard = wizard;
        if (studyParameters.getCustomizingPlugin() != null) {
            this.extendedMonitor = true;
            String customizedTitle = studyParameters.getTitle();
            if (!customizedTitle.equals("")) {
                this.setTitle(NLS.bind((String)Messages.GetNewUserIdPage_X_Consent_Form_And_User_Id, (Object)customizedTitle));
            }
        }
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 1;
        if (this.extendedMonitor) {
            this.createBrowserSection(container);
            this.createInstructionSection(container);
            this.createNamesSection(container);
            this.createJobDetailSection(container);
            if (this.studyParameters.usingContactField()) {
                this.createContactSection(container);
            }
            this.createUserIdButtons(container);
        } else {
            this.createAnonymousParticipationButtons(container);
        }
        this.setControl((Control)container);
    }

    private void createBrowserSection(Composite parent) {
        if (this.extendedMonitor) {
            Label label = new Label(parent, 0);
            label.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
            label.setText(this.studyParameters.getCustomizedByMessage());
            Composite container = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            container.setLayout((Layout)layout);
            layout.numColumns = 1;
            Browser browser = new Browser(parent, 0);
            GridData gd = new GridData(768);
            gd.heightHint = 200;
            gd.widthHint = 600;
            browser.setLayoutData((Object)gd);
            URL url = Platform.getBundle((String)this.studyParameters.getCustomizingPlugin()).getEntry(this.studyParameters.getFormsConsent());
            try {
                URL localURL = Platform.asLocalURL((URL)url);
                browser.setUrl(localURL.toString());
            }
            catch (Exception exception) {
                browser.setText(Messages.GetNewUserIdPage_Feedback_Description_Not_Located);
            }
        } else {
            Label label = new Label(parent, 0);
            label.setText("");
        }
    }

    private void createNamesSection(Composite parent) {
        Composite names = new Composite(parent, 0);
        GridLayout layout = new GridLayout(6, true);
        layout.verticalSpacing = 9;
        layout.horizontalSpacing = 4;
        names.setLayout((Layout)layout);
        Label label = new Label(names, 0);
        label.setText(Messages.GetNewUserIdPage_First_Name);
        this.firstName = new Text(names, 2052);
        GridData gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = 2;
        this.firstName.setLayoutData((Object)gd);
        this.firstName.setEditable(true);
        this.firstName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GetNewUserIdPage.this.first = GetNewUserIdPage.this.firstName.getText();
                GetNewUserIdPage.this.updateEnablement();
                GetNewUserIdPage.this.setPageComplete(GetNewUserIdPage.this.isPageComplete());
            }
        });
        label = new Label(names, 0);
        label.setText(Messages.GetNewUserIdPage_Last_Name);
        this.lastName = new Text(names, 2052);
        gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = 2;
        this.lastName.setLayoutData((Object)gd);
        this.lastName.setEditable(true);
        this.lastName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GetNewUserIdPage.this.last = GetNewUserIdPage.this.lastName.getText();
                GetNewUserIdPage.this.updateEnablement();
                GetNewUserIdPage.this.setPageComplete(GetNewUserIdPage.this.isPageComplete());
            }
        });
        label = new Label(names, 0);
        label.setText(Messages.GetNewUserIdPage_Email_Address);
        this.emailAddress = new Text(names, 2052);
        gd = new GridData(1808);
        gd.horizontalSpan = 5;
        this.emailAddress.setLayoutData((Object)gd);
        this.emailAddress.setEditable(true);
        this.emailAddress.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GetNewUserIdPage.this.email = GetNewUserIdPage.this.emailAddress.getText();
                GetNewUserIdPage.this.updateEnablement();
                GetNewUserIdPage.this.setPageComplete(GetNewUserIdPage.this.isPageComplete());
            }
        });
    }

    private void createJobDetailSection(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 2;
        Label l = new Label(container, 0);
        l.setText(Messages.GetNewUserIdPage_Job_Function);
        final Combo jobFunctionCombo = new Combo(container, 4);
        jobFunctionCombo.setText(this.jobFunction);
        jobFunctionCombo.add(Messages.GetNewUserIdPage_Application_Developer);
        jobFunctionCombo.add(Messages.GetNewUserIdPage_QA);
        jobFunctionCombo.add(Messages.GetNewUserIdPage_Program_Director);
        jobFunctionCombo.add(Messages.GetNewUserIdPage_CIO);
        jobFunctionCombo.add(Messages.GetNewUserIdPage_VP_Development);
        jobFunctionCombo.add(Messages.GetNewUserIdPage_Application_Architect);
        jobFunctionCombo.add(Messages.GetNewUserIdPage_Project_Manager);
        jobFunctionCombo.add(Messages.GetNewUserIdPage_Student);
        jobFunctionCombo.add(Messages.GetNewUserIdPage_Faculty);
        jobFunctionCombo.add(Messages.GetNewUserIdPage_Business);
        jobFunctionCombo.add(Messages.GetNewUserIdPage_Analyst);
        jobFunctionCombo.add(Messages.GetNewUserIdPage_Database_Administrator);
        jobFunctionCombo.add(Messages.GetNewUserIdPage_Other);
        jobFunctionCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GetNewUserIdPage.this.jobFunction = jobFunctionCombo.getText();
                GetNewUserIdPage.this.updateEnablement();
            }
        });
        l = new Label(container, 0);
        l.setText(Messages.GetNewUserIdPage_Company_Size);
        final Combo companySizecombo = new Combo(container, 4);
        companySizecombo.setText(this.companySize);
        companySizecombo.add(Messages.GetNewUserIdPage_Individual);
        companySizecombo.add(Messages.GetNewUserIdPage_Gt_Fifty);
        companySizecombo.add(Messages.GetNewUserIdPage_Fifty_Hundred);
        companySizecombo.add(Messages.GetNewUserIdPage_Hundred_Five_Hundred);
        companySizecombo.add(Messages.GetNewUserIdPage_Five_Hundred_Thousand);
        companySizecombo.add(Messages.GetNewUserIdPage_Thousand_Twenty_Five_Hundred);
        companySizecombo.add(Messages.GetNewUserIdPage_Gt_Twenty_Five_Hundred);
        companySizecombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GetNewUserIdPage.this.companySize = companySizecombo.getText();
                GetNewUserIdPage.this.updateEnablement();
            }
        });
        l = new Label(container, 0);
        l.setText(Messages.GetNewUserIdPage_Company_Business);
        final Combo companyBuisnesscombo = new Combo(container, 4);
        companyBuisnesscombo.setText(this.companyFunction);
        companyBuisnesscombo.add(Messages.GetNewUserIdPage_Financial);
        companyBuisnesscombo.add(Messages.GetNewUserIdPage_Energy);
        companyBuisnesscombo.add(Messages.GetNewUserIdPage_Government);
        companyBuisnesscombo.add(Messages.GetNewUserIdPage_Hardware);
        companyBuisnesscombo.add(Messages.GetNewUserIdPage_Networking);
        companyBuisnesscombo.add(Messages.GetNewUserIdPage_Pharmaceutical);
        companyBuisnesscombo.add(Messages.GetNewUserIdPage_Automotive);
        companyBuisnesscombo.add(Messages.GetNewUserIdPage_Software);
        companyBuisnesscombo.add(Messages.GetNewUserIdPage_Communications);
        companyBuisnesscombo.add(Messages.GetNewUserIdPage_Transportation);
        companyBuisnesscombo.add(Messages.GetNewUserIdPage_Retail);
        companyBuisnesscombo.add(Messages.GetNewUserIdPage_Utilities);
        companyBuisnesscombo.add(Messages.GetNewUserIdPage_Other_Manufacturing);
        companyBuisnesscombo.add(Messages.GetNewUserIdPage_Academic);
        companyBuisnesscombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GetNewUserIdPage.this.companyFunction = companyBuisnesscombo.getText();
                GetNewUserIdPage.this.updateEnablement();
            }
        });
    }

    private void createInstructionSection(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        container.setLayout((Layout)layout);
        Label l = new Label(container, 0);
        l.setText(Messages.GetNewUserIdPage_To_Create_User_Id_Fill_In);
        GridData gd = new GridData(32);
        l.setLayoutData((Object)gd);
    }

    private void createContactSection(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        container.setLayout((Layout)layout);
        this.contactAgreement = new Button(container, 32);
        this.contactAgreement.setText(Messages.GetNewUserIdPage_Willing_To_Receive_Email);
        this.contactAgreement.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GetNewUserIdPage.this.contactEmail = GetNewUserIdPage.this.contactAgreement.getSelection();
            }
        });
    }

    private void createUserIdButtons(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        container.setLayout((Layout)layout);
        Label l = new Label(container, 0);
        l.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
        l.setText(Messages.GetNewUserIdPage_I_Consent_Acknowledge);
        GridData gd = new GridData(32);
        l.setLayoutData((Object)gd);
        container = new Composite(parent, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        this.getNewUid = new Button(container, 8);
        gd = new GridData(32);
        this.getNewUid.setLayoutData((Object)gd);
        this.getNewUid.setSelection(false);
        this.getNewUid.setText(Messages.GetNewUserIdPage_I_Consent);
        this.getNewUid.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (e.widget instanceof Button) {
                    if (GetNewUserIdPage.this.hasAllFields(false)) {
                        final int[] uid = new int[1];
                        try {
                            GetNewUserIdPage.this.getWizard().getContainer().run(false, true, new IRunnableWithProgress(){

                                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                    uid[0] = UiUsageMonitorPlugin.getDefault().getUploadManager().getNewUid(GetNewUserIdPage.this.studyParameters, GetNewUserIdPage.this.first, GetNewUserIdPage.this.last, GetNewUserIdPage.this.email, GetNewUserIdPage.this.anon, GetNewUserIdPage.this.jobFunction, GetNewUserIdPage.this.companySize, GetNewUserIdPage.this.companyFunction, GetNewUserIdPage.this.contactEmail, monitor);
                                }
                            });
                        }
                        catch (InvocationTargetException e1) {
                            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.monitor.usage", e1.getMessage(), (Throwable)e1));
                        }
                        catch (InterruptedException e1) {
                            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.monitor.usage", e1.getMessage(), (Throwable)e1));
                        }
                        if (uid[0] != -1) {
                            UiUsageMonitorPlugin.getDefault().getPreferenceStore().setValue(GetNewUserIdPage.this.studyParameters.getUserIdPreferenceId(), uid[0]);
                            if (GetNewUserIdPage.this.wizard.getUploadPage() != null) {
                                GetNewUserIdPage.this.wizard.getUploadPage().updateUid();
                            }
                            GetNewUserIdPage.this.hasValidated = true;
                            MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)NLS.bind((String)Messages.GetNewUserIdPage_X_User_Study_Id, (Object)GetNewUserIdPage.this.studyParameters.getStudyName()), (String)NLS.bind((String)Messages.GetNewUserIdPage_Your_X_User_Study_Id_Y, (Object)GetNewUserIdPage.this.studyParameters.getStudyName(), (Object)GetNewUserIdPage.this.wizard.getUid()));
                        }
                    } else {
                        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.GetNewUserIdPage_Incomplete_Form_Input, (String)Messages.GetNewUserIdPage_Please_Complete_All_Fields);
                    }
                    GetNewUserIdPage.this.setPageComplete(GetNewUserIdPage.this.isPageComplete());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.getExistingUid = new Button(container, 8);
        gd = new GridData(32);
        this.getExistingUid.setLayoutData((Object)gd);
        this.getExistingUid.setSelection(false);
        this.getExistingUid.setText(Messages.GetNewUserIdPage_Already_Consented);
        this.getExistingUid.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (e.widget instanceof Button) {
                    if (GetNewUserIdPage.this.hasAllFields(true)) {
                        final int[] uid = new int[1];
                        try {
                            GetNewUserIdPage.this.getWizard().getContainer().run(false, true, new IRunnableWithProgress(){

                                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                    uid[0] = UiUsageMonitorPlugin.getDefault().getUploadManager().getExistingUid(GetNewUserIdPage.this.studyParameters, GetNewUserIdPage.this.first, GetNewUserIdPage.this.last, GetNewUserIdPage.this.email, GetNewUserIdPage.this.anon, monitor);
                                }
                            });
                        }
                        catch (InvocationTargetException e1) {
                            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.monitor.usage", e1.getMessage(), (Throwable)e1));
                        }
                        catch (InterruptedException e1) {
                            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.monitor.usage", e1.getMessage(), (Throwable)e1));
                        }
                        if (uid[0] != -1) {
                            UiUsageMonitorPlugin.getDefault().getPreferenceStore().setValue(GetNewUserIdPage.this.studyParameters.getUserIdPreferenceId(), uid[0]);
                            if (GetNewUserIdPage.this.wizard.getUploadPage() != null) {
                                GetNewUserIdPage.this.wizard.getUploadPage().updateUid();
                            }
                            GetNewUserIdPage.this.hasValidated = true;
                            MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)NLS.bind((String)Messages.GetNewUserIdPage_X_User_Study_Id, (Object)GetNewUserIdPage.this.studyParameters.getStudyName()), (String)NLS.bind((String)Messages.GetNewUserIdPage_Your_X_User_Study_Id_Y_Retrieve_By_Repeating, (Object)GetNewUserIdPage.this.studyParameters.getStudyName(), (Object)GetNewUserIdPage.this.wizard.getUid()));
                        }
                    } else {
                        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.GetNewUserIdPage_Incomplete_Form_Input, (String)Messages.GetNewUserIdPage_Please_Complete_All_Fields);
                    }
                    GetNewUserIdPage.this.setPageComplete(GetNewUserIdPage.this.isPageComplete());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.updateEnablement();
    }

    private void createAnonymousParticipationButtons(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        container.setLayout((Layout)layout);
        Label label = new Label(container, 0);
        label.setText(Messages.GetNewUserIdPage_Your_Data_Not_Traceable);
        label = new Label(container, 0);
        label.setText(Messages.GetNewUserIdPage_Before_Switching_Retrieve_From_Preferences);
        container = new Composite(parent, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        this.getNewUid = new Button(container, 8);
        GridData gd = new GridData(32);
        this.getNewUid.setLayoutData((Object)gd);
        this.getNewUid.setSelection(false);
        this.getNewUid.setText(Messages.GetNewUserIdPage_Create_Or_Retrieve_Id);
        this.getNewUid.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (e.widget instanceof Button) {
                    final int[] uid = new int[1];
                    try {
                        GetNewUserIdPage.this.getWizard().getContainer().run(false, true, new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                uid[0] = UiUsageMonitorPlugin.getDefault().getUploadManager().getNewUid(GetNewUserIdPage.this.studyParameters, monitor);
                            }
                        });
                    }
                    catch (InvocationTargetException e1) {
                        StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.monitor.usage", e1.getMessage(), (Throwable)e1));
                    }
                    catch (InterruptedException e1) {
                        StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.monitor.usage", e1.getMessage(), (Throwable)e1));
                    }
                    if (uid[0] != -1) {
                        UiUsageMonitorPlugin.getDefault().getPreferenceStore().setValue(GetNewUserIdPage.this.studyParameters.getUserIdPreferenceId(), uid[0]);
                        if (GetNewUserIdPage.this.wizard.getUploadPage() != null) {
                            GetNewUserIdPage.this.wizard.getUploadPage().updateUid();
                        }
                        GetNewUserIdPage.this.hasValidated = true;
                        MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)NLS.bind((String)Messages.GetNewUserIdPage_X_User_Study_Id, (Object)GetNewUserIdPage.this.studyParameters.getStudyName()), (String)NLS.bind((String)Messages.GetNewUserIdPage_Your_X_User_Study_Id_Y_Record, (Object)GetNewUserIdPage.this.studyParameters.getStudyName(), (Object)GetNewUserIdPage.this.wizard.getUid()));
                    }
                    GetNewUserIdPage.this.setPageComplete(GetNewUserIdPage.this.isPageComplete());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.updateEnablement();
    }

    private void updateEnablement() {
        boolean jobFilled;
        if (!this.extendedMonitor) {
            return;
        }
        boolean nameFilled = !this.firstName.getText().equals("") && !this.lastName.getText().equals("") && !this.emailAddress.getText().equals("") || this.anon;
        boolean bl = jobFilled = !this.jobFunction.equals(Messages.GetNewUserIdPage_Select_Below) && !this.companyFunction.equals(Messages.GetNewUserIdPage_Select_Below) && !this.companySize.equals(Messages.GetNewUserIdPage_Select_Below);
        if (nameFilled && jobFilled) {
            this.getNewUid.setEnabled(true);
            this.getExistingUid.setEnabled(true);
        } else {
            this.getExistingUid.setEnabled(false);
            this.getNewUid.setEnabled(false);
        }
    }

    public boolean hasAllFields(boolean existing) {
        boolean nameFilled;
        if (!this.extendedMonitor) {
            return true;
        }
        boolean bl = nameFilled = !this.firstName.getText().equals("") && !this.lastName.getText().equals("") && !this.emailAddress.getText().equals("");
        if (!existing) {
            boolean jobFilled;
            boolean bl2 = jobFilled = !this.jobFunction.equals(Messages.GetNewUserIdPage_Select_Below) && !this.companyFunction.equals(Messages.GetNewUserIdPage_Select_Below) && !this.companySize.equals(Messages.GetNewUserIdPage_Select_Below);
            return jobFilled && nameFilled;
        }
        return nameFilled || this.anon;
    }

    public boolean isPageComplete() {
        return this.hasAllFields(true) && this.hasValidated;
    }

    public IWizardPage getNextPage() {
        if (this.isPageComplete() && this.performUpload) {
            this.wizard.addPage((IWizardPage)this.wizard.getUploadPage());
        }
        return super.getNextPage();
    }

    public boolean isAnonymous() {
        return this.anon;
    }

    public String getEmailAddress() {
        return this.email;
    }

    public String getFirstName() {
        return this.first;
    }

    public String getLastName() {
        return this.last;
    }
}

