/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.xplanner.ui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylyn.commons.core.CoreUtil;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.xplanner.ui.Messages;
import org.eclipse.mylyn.internal.xplanner.ui.XPlannerClientFacade;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class XPlannerUiPlugin
extends AbstractUIPlugin {
    private static XPlannerUiPlugin INSTANCE;
    public static final String ID_PLUGIN = "org.eclipse.mylyn.xplanner.ui";
    public static final String XPLANNER_CLIENT_LABEL;
    public static final String TITLE_MESSAGE_DIALOG;
    public static final String DELIM_URL_PREFIX = "/do/view/";
    public static final String DELIM_URL_SUFFIX = "?oid=";
    public static final String TASK_URL_PREFIX = "/do/view/task?oid=";
    public static final String USER_STORY_URL_PREFIX = "/do/view/userstory?oid=";
    public static final String ITERATION_URL_PREFIX = "/do/view/iteration?oid=";
    public static final String USE_AUTO_TIME_TRACKING_PREFERENCE_NAME = "UseAutoTimeTracking";
    public static final String ROUND_AUTO_TIME_TRACKING_TO_HALF_HOUR_PREFERENCE_NAME = "RoundAutoTimeTrackingToHalfHour";
    public static final String ADD_AUTO_TRACKED_TIME_TO_REPOSITORY_VALUE_PREFERENCE_NAME = "AddAutoTrackedTimeToRepositoryValue";
    @Deprecated
    public static final String REPOSITORY_KIND = "xplanner";

    static {
        XPLANNER_CLIENT_LABEL = Messages.XPlannerPlugin_CLIENT_LABEL;
        TITLE_MESSAGE_DIALOG = Messages.XPlannerPlugin_CLIENT_DIALOG_TITLE;
    }

    public XPlannerUiPlugin() {
        INSTANCE = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.setPreferenceDefaults();
    }

    private void setPreferenceDefaults() {
        this.getPreferenceStore().setDefault(USE_AUTO_TIME_TRACKING_PREFERENCE_NAME, false);
        this.getPreferenceStore().setDefault(ROUND_AUTO_TIME_TRACKING_TO_HALF_HOUR_PREFERENCE_NAME, true);
        this.getPreferenceStore().setDefault(ADD_AUTO_TRACKED_TIME_TO_REPOSITORY_VALUE_PREFERENCE_NAME, true);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        INSTANCE = null;
        if (XPlannerClientFacade.isInitialized()) {
            XPlannerClientFacade.getDefault().logOutFromAll();
        }
    }

    public static void log(final Throwable e, final String message, boolean informUser) {
        block5: {
            if (Platform.isRunning() && informUser) {
                try {
                    if (!CoreUtil.TEST_MODE) {
                        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                Shell shell = null;
                                if (PlatformUI.getWorkbench() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null) {
                                    shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                                }
                                String displayMessage = message == null ? e.getMessage() : String.valueOf(message) + "\n" + e.getMessage();
                                MessageDialog.openError((Shell)shell, (String)Messages.XPlannerPlugin_XPLANNER_ERROR_TITLE, (String)displayMessage);
                            }
                        });
                        break block5;
                    }
                    System.err.println("XPlanner error: " + message);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            } else {
                StatusHandler.log((IStatus)new Status(4, ID_PLUGIN, message == null || message.length() == 0 ? Messages.XPlannerPlugin_XPLANNER_ERROR_TITLE : message, e));
            }
        }
    }

    public static XPlannerUiPlugin getDefault() {
        return INSTANCE;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)ID_PLUGIN, (String)path);
    }

    public static void setBooleanPreference(String name, boolean value) {
        XPlannerUiPlugin.getDefault().getPreferenceStore().setValue(name, value);
    }

    public static boolean getBooleanPreference(String name) {
        return XPlannerUiPlugin.getDefault().getPreferenceStore().getBoolean(name);
    }
}

