/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.xplanner.ui.editor;

import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.mylyn.internal.tasks.ui.editors.AbstractReplyToCommentAction;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorActionPart;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorDescriptionPart;
import org.eclipse.mylyn.internal.xplanner.ui.XPlannerRepositoryUtils;
import org.eclipse.mylyn.internal.xplanner.ui.editor.Messages;
import org.eclipse.mylyn.internal.xplanner.ui.editor.XPlannerEditorAttributeProvider;
import org.eclipse.mylyn.internal.xplanner.ui.editor.XPlannerTaskEditorExtraControls;
import org.eclipse.mylyn.internal.xplanner.ui.editor.XPlannerTimeTrackingEditorPart;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPage;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPart;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditorPartDescriptor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPlannerTaskEditor
extends AbstractTaskEditorPage
implements XPlannerEditorAttributeProvider {
    private XPlannerTaskEditorExtraControls extraControls;
    private XPlannerTimeTrackingEditorPart timeTrackingControls;
    private static final String ID_PART_XPLANNER_TIME_TRACKING = "org.eclipse.mylyn.internal.xplanner.ui.editors.part.timetracking";
    private boolean newTask = false;

    public XPlannerTaskEditor(TaskEditor editor) {
        this(editor, false);
    }

    public XPlannerTaskEditor(TaskEditor editor, boolean newTask) {
        super(editor, "xplanner");
        this.newTask = newTask;
    }

    protected Set<TaskEditorPartDescriptor> createPartDescriptors() {
        Set descriptors = super.createPartDescriptors();
        Iterator iterator = descriptors.iterator();
        while (iterator.hasNext()) {
            TaskEditorPartDescriptor taskEditorPartDescriptor = (TaskEditorPartDescriptor)iterator.next();
            if (!taskEditorPartDescriptor.getId().equals("org.eclipse.mylyn.tasks.ui.editors.parts.people") && !taskEditorPartDescriptor.getId().equals("org.eclipse.mylyn.tasks.ui.editors.parts.attributes") && !taskEditorPartDescriptor.getId().equals("org.eclipse.mylyn.tasks.ui.editors.parts.descriptions") && !taskEditorPartDescriptor.getId().equals("org.eclipse.mylyn.tasks.ui.editors.parts.attachments") && !taskEditorPartDescriptor.getId().equals("org.eclipse.mylyn.tasks.ui.editors.parts.comments") && !taskEditorPartDescriptor.getId().equals("org.eclipse.mylyn.tasks.ui.editors.parts.newComment") && !taskEditorPartDescriptor.getId().equals("org.eclipse.mylyn.tasks.ui.editors.parts.actions")) continue;
            iterator.remove();
        }
        descriptors.add(new TaskEditorPartDescriptor("org.eclipse.mylyn.tasks.ui.editors.parts.attributes"){

            public AbstractTaskEditorPart createPart() {
                return XPlannerTaskEditor.this.getExtraControls();
            }
        }.setPath("attributes"));
        descriptors.add(new TaskEditorPartDescriptor("org.eclipse.mylyn.tasks.ui.editors.parts.descriptions"){

            public AbstractTaskEditorPart createPart() {
                TaskEditorDescriptionPart part = new TaskEditorDescriptionPart(){

                    protected void fillToolBar(ToolBarManager toolBar) {
                        super.fillToolBar(toolBar);
                        IContributionItem[] iContributionItemArray = toolBar.getItems();
                        int n = iContributionItemArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IContributionItem contributionItem = iContributionItemArray[n2];
                            if (contributionItem instanceof ActionContributionItem && ((ActionContributionItem)contributionItem).getAction() instanceof AbstractReplyToCommentAction) {
                                toolBar.remove(contributionItem);
                                break;
                            }
                            ++n2;
                        }
                    }
                };
                if (XPlannerTaskEditor.this.getModel().getTaskData().isNew()) {
                    part.setExpandVertically(true);
                    part.setSectionStyle(320);
                }
                return part;
            }
        }.setPath("attributes"));
        if (!this.newTask) {
            try {
                TaskData data = TasksUi.getTaskDataManager().getTaskData(this.getTask());
                if (data != null) {
                    descriptors.add(new TaskEditorPartDescriptor(ID_PART_XPLANNER_TIME_TRACKING){

                        public AbstractTaskEditorPart createPart() {
                            XPlannerTaskEditor.this.timeTrackingControls = new XPlannerTimeTrackingEditorPart(XPlannerTaskEditor.this.getTask(), XPlannerTaskEditor.this);
                            return XPlannerTaskEditor.this.timeTrackingControls;
                        }
                    }.setPath("attributes"));
                }
            }
            catch (CoreException coreException) {}
        }
        descriptors.add(new TaskEditorPartDescriptor("org.eclipse.mylyn.tasks.ui.editors.parts.actions"){

            public AbstractTaskEditorPart createPart() {
                return new TaskEditorActionPart(){

                    protected void addAttachContextButton(Composite buttonComposite, FormToolkit toolkit) {
                    }
                };
            }
        }.setPath("actions"));
        return descriptors;
    }

    protected XPlannerTaskEditorExtraControls getExtraControls() {
        if (this.extraControls == null) {
            this.extraControls = new XPlannerTaskEditorExtraControls(this, !this.newTask);
        }
        return this.extraControls;
    }

    public TaskData getRepositoryTaskData() {
        return this.getModel().getTaskData();
    }

    public String getFormTitle() {
        return MessageFormat.format(Messages.XPlannerTaskEditor_FORM_TASK_TITLE, XPlannerRepositoryUtils.getName(this.getRepositoryTaskData()), String.valueOf(this.getRepositoryTaskData().getTaskId()));
    }

    public void setFocus() {
    }

    public String getPluginId() {
        return "org.eclipse.mylyn.xplanner.ui";
    }

    @Override
    public void xplannerAttributeChanged(TaskAttribute attribute) {
        this.getModel().attributeChanged(attribute);
    }

    public void close() {
        if (this.timeTrackingControls != null) {
            this.timeTrackingControls.savePreferenceSettings();
        }
        super.close();
    }
}

