/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.xplanner.ui.wizard;

import java.rmi.RemoteException;
import java.util.HashMap;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mylyn.internal.xplanner.core.service.XPlannerClient;
import org.xplanner.soap.IterationData;
import org.xplanner.soap.ProjectData;
import org.xplanner.soap.UserStoryData;

public class ProjectsViewerContentProvider
implements ITreeContentProvider {
    private XPlannerClient client;
    private ProjectData[] projects;
    private final HashMap<ProjectData, IterationData[]> projectsToIterationsMap = new HashMap();
    private final HashMap<IterationData, UserStoryData[]> iterationsToUserStoriesMap = new HashMap();

    public ProjectsViewerContentProvider(XPlannerClient client) {
        this.client = client;
    }

    public Object[] getChildren(Object parentElement) {
        return this.getXPlannerChildren(parentElement);
    }

    public Object getParent(Object element) {
        ProjectData parent = null;
        try {
            if (element instanceof IterationData) {
                IterationData iteration = (IterationData)element;
                parent = this.client.getProject(iteration.getProjectId());
            } else if (element instanceof UserStoryData) {
                UserStoryData userStory = (UserStoryData)element;
                parent = this.client.getIteration(userStory.getIterationId());
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return parent;
    }

    public boolean hasChildren(Object element) {
        boolean hasChildren = true;
        if (element instanceof UserStoryData) {
            hasChildren = false;
        }
        return hasChildren;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
        this.client = null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.clear();
    }

    private ProjectData[] getProjects() {
        if (this.projects == null) {
            try {
                this.projects = this.client.getProjects();
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        return this.projects;
    }

    private IterationData[] getIterations(ProjectData project) {
        IterationData[] iterations = this.projectsToIterationsMap.get(project);
        if (iterations == null) {
            try {
                iterations = this.client.getIterations(project.getId());
                this.projectsToIterationsMap.put(project, iterations);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        return iterations;
    }

    private UserStoryData[] getUserStories(IterationData iteration) {
        UserStoryData[] userStories = null;
        userStories = this.iterationsToUserStoriesMap.get(iteration);
        if (userStories == null) {
            try {
                userStories = this.client.getUserStories(iteration.getId());
                this.iterationsToUserStoriesMap.put(iteration, userStories);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        return userStories;
    }

    private Object[] getXPlannerChildren(Object element) {
        Object[] children = new Object[]{};
        if (element == null || element instanceof XPlannerClient) {
            children = this.getProjects();
        } else if (element instanceof ProjectData) {
            children = this.getIterations((ProjectData)element);
        } else if (element instanceof IterationData) {
            children = this.getUserStories((IterationData)element);
        }
        return children;
    }

    public void clear() {
        this.projects = null;
        this.projectsToIterationsMap.clear();
        this.iterationsToUserStoriesMap.clear();
    }
}

