/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.xplanner.ui.wizard;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.mylyn.internal.xplanner.core.service.XPlannerClient;
import org.eclipse.mylyn.internal.xplanner.ui.XPlannerClientFacade;
import org.eclipse.mylyn.internal.xplanner.ui.XPlannerTaskListMigrator;
import org.eclipse.mylyn.internal.xplanner.ui.wizard.AbstractXPlannerQueryWizardPage;
import org.eclipse.mylyn.internal.xplanner.ui.wizard.Messages;
import org.eclipse.mylyn.internal.xplanner.ui.wizard.MultipleQueryPage;
import org.eclipse.mylyn.internal.xplanner.ui.wizard.ProjectsViewerContentProvider;
import org.eclipse.mylyn.internal.xplanner.ui.wizard.ProjectsViewerLabelProvider;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.xplanner.soap.IterationData;
import org.xplanner.soap.ProjectData;
import org.xplanner.soap.TaskData;
import org.xplanner.soap.UserStoryData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPlannerCustomQueryPage
extends AbstractXPlannerQueryWizardPage
implements MultipleQueryPage {
    private static final boolean DEFAULT_IS_USE_TASKS = true;
    private static final boolean DEFAULT_SELECT_MY_CURRENT_TASKS = true;
    private final XPlannerClient client;
    private Text nameText;
    private TreeViewer projectsViewer;
    private Button allTasksOrStoriesButton;
    private Button myTasksOrStoriesButton;
    private Button tasksButton;
    private Button storiesButton;
    private Button myTasksButton;
    private Button selectedTasksButton;
    private Label queryNameLabel;
    private Label projectTreeLabel;
    private Label typeLabel;
    private Label scopeLabel;

    public XPlannerCustomQueryPage(TaskRepository repository, IRepositoryQuery existingQuery) {
        super(repository, existingQuery);
        try {
            this.client = XPlannerClientFacade.getDefault().getXPlannerClient(repository);
            this.setPageComplete(false);
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    public void createControl(Composite parent) {
        Composite dataComposite = new Composite(parent, 0);
        GridData gd = new GridData(1808);
        dataComposite.setLayoutData((Object)gd);
        dataComposite.setLayout((Layout)new GridLayout());
        this.createNameControls(dataComposite);
        this.createMyTasksControls(dataComposite);
        Composite detailsComposite = new Composite(dataComposite, 0);
        detailsComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout detailsLayout = new GridLayout(2, false);
        detailsLayout.marginTop = 0;
        detailsLayout.marginLeft = 10;
        detailsLayout.marginHeight = 0;
        detailsComposite.setLayout((Layout)detailsLayout);
        this.createProjectsView(detailsComposite);
        this.createButtons(detailsComposite);
        if (this.getExistingQuery() == null) {
            this.loadFromDefaults();
        } else {
            this.loadFromExistingQuery();
        }
        this.updateSelectionControls();
        if (this.getSearchContainer() != null) {
            this.getSearchContainer().setPerformActionEnabled(this.isPageComplete());
        }
        this.setControl((Control)dataComposite);
    }

    protected XPlannerClient getClient() {
        return this.client;
    }

    protected boolean isContentTypeTask() {
        boolean isContentTypeTask = true;
        if (this.tasksButton == null) {
            if (this.getExistingQuery() != null) {
                isContentTypeTask = XPlannerTaskListMigrator.isUseTasks(this.getExistingQuery());
            }
        } else {
            isContentTypeTask = this.tasksButton.getSelection();
        }
        return isContentTypeTask;
    }

    private void createNameControls(Composite parent) {
        if (this.inSearchContainer()) {
            return;
        }
        Composite nameComposite = new Composite(parent, 0);
        nameComposite.setLayoutData((Object)new GridData(4, 1, true, false));
        GridLayout nameLayout = new GridLayout(2, false);
        nameLayout.marginWidth = 0;
        nameComposite.setLayout((Layout)nameLayout);
        this.queryNameLabel = new Label(nameComposite, 0);
        this.queryNameLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.queryNameLabel.setText(Messages.XPlannerCustomQueryPage_QUERY_NAME);
        this.nameText = new Text(nameComposite, 2048);
        this.nameText.setLayoutData((Object)new GridData(4, 1, true, false));
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                XPlannerCustomQueryPage.this.validatePage();
            }
        });
        this.nameText.setFocus();
    }

    private void createMyTasksControls(Composite parent) {
        Composite myTasksComposite = new Composite(parent, 0);
        myTasksComposite.setLayoutData((Object)new GridData(4, 1, true, false));
        GridLayout myTasksGridLayout = new GridLayout(1, false);
        myTasksGridLayout.marginWidth = 0;
        myTasksGridLayout.marginTop = 5;
        myTasksGridLayout.marginBottom = 0;
        myTasksGridLayout.marginHeight = 0;
        myTasksComposite.setLayout((Layout)myTasksGridLayout);
        this.myTasksButton = new Button(myTasksComposite, 16);
        this.myTasksButton.setLayoutData((Object)new GridData(1, 1, false, false));
        this.myTasksButton.setText(Messages.XPlannerCustomQueryPage_ALL_MY_CURRENT_TASKS);
        this.selectedTasksButton = new Button(myTasksComposite, 16);
        this.selectedTasksButton.setLayoutData((Object)new GridData(1, 1, false, false));
        this.selectedTasksButton.setText(Messages.XPlannerCustomQueryPage_SELECTED_TASKS);
        this.myTasksButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                XPlannerCustomQueryPage.this.updateSelectionControls();
                XPlannerCustomQueryPage.this.validatePage();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.selectedTasksButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                XPlannerCustomQueryPage.this.updateSelectionControls();
                XPlannerCustomQueryPage.this.validatePage();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    private void updateSelectionControls() {
        boolean getMyCurrentTasks = this.myTasksButton.getSelection();
        this.projectTreeLabel.setEnabled(!getMyCurrentTasks);
        this.projectsViewer.getTree().setEnabled(!getMyCurrentTasks);
        this.typeLabel.setEnabled(!getMyCurrentTasks);
        this.tasksButton.setEnabled(!getMyCurrentTasks);
        this.storiesButton.setEnabled(!getMyCurrentTasks);
        this.scopeLabel.setEnabled(!getMyCurrentTasks);
        this.allTasksOrStoriesButton.setEnabled(!getMyCurrentTasks);
        this.myTasksOrStoriesButton.setEnabled(!getMyCurrentTasks);
        if (!getMyCurrentTasks && this.projectsViewer.getExpandedElements().length == 0) {
            this.projectsViewer.expandToLevel(2);
        }
    }

    private void createProjectsView(Composite parent) {
        Composite projectsComposite = new Composite(parent, 0);
        projectsComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout projectsLayout = new GridLayout(1, false);
        projectsLayout.marginTop = 0;
        projectsLayout.marginHeight = 0;
        projectsComposite.setLayout((Layout)projectsLayout);
        this.projectTreeLabel = new Label(projectsComposite, 0);
        this.projectTreeLabel.setData((Object)new GridData(1, 1, false, false));
        this.projectTreeLabel.setText(Messages.XPlannerCustomQueryPage_PROJECTS_TREE_TITLE);
        this.projectsViewer = new TreeViewer(projectsComposite, 2818);
        this.projectsViewer.setContentProvider((IContentProvider)new ProjectsViewerContentProvider(this.client));
        this.projectsViewer.setLabelProvider((IBaseLabelProvider)new ProjectsViewerLabelProvider());
        GridData projectsViewerGridData = new GridData(4, 4, true, true);
        projectsViewerGridData.heightHint = 100;
        projectsViewerGridData.widthHint = 200;
        this.projectsViewer.getTree().setLayoutData((Object)projectsViewerGridData);
        this.projectsViewer.setInput((Object)this.client);
        this.projectsViewer.refresh();
        this.projectsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                XPlannerCustomQueryPage.this.ensureSingleTypeSelected(e);
                XPlannerCustomQueryPage.this.validatePage();
            }
        });
    }

    private void ensureSingleTypeSelected(SelectionChangedEvent e) {
        StructuredSelection selection = (StructuredSelection)e.getSelection();
        ArrayList selectedElements = new ArrayList(selection.toList());
        if (selectedElements.size() > 1) {
            Object firstElement = selection.getFirstElement();
            int originalSelectionSize = selection.size();
            Iterator iter = selectedElements.iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                if (element.getClass().equals(firstElement.getClass())) continue;
                iter.remove();
            }
            if (selectedElements.size() < originalSelectionSize) {
                e.getSelectionProvider().setSelection((ISelection)new StructuredSelection(selectedElements));
            }
        }
    }

    private void createButtons(Composite parent) {
        Composite buttonsComposite = new Composite(parent, 0);
        buttonsComposite.setLayoutData((Object)new GridData(4, 4, false, false));
        GridLayout buttonsLayout = new GridLayout();
        buttonsLayout.marginTop = 0;
        buttonsLayout.marginHeight = 0;
        buttonsComposite.setLayout((Layout)buttonsLayout);
        this.createTypeButtons(buttonsComposite);
        this.createScopeButtons(buttonsComposite);
    }

    private void createTypeButtons(Composite parent) {
        Composite typeComposite = new Composite(parent, 0);
        typeComposite.setLayoutData((Object)new GridData(4, 1, true, false));
        GridLayout typeLayout = new GridLayout();
        typeLayout.marginTop = 0;
        typeLayout.marginHeight = 0;
        typeComposite.setLayout((Layout)typeLayout);
        this.typeLabel = new Label(typeComposite, 0);
        this.typeLabel.setData((Object)new GridData(1, 1));
        this.typeLabel.setText(Messages.XPlannerCustomQueryPage_GROUPING_TITLE);
        this.tasksButton = new Button(typeComposite, 16);
        GridData tasksLayoutData = new GridData(1, 1, false, false);
        tasksLayoutData.horizontalIndent = 10;
        this.tasksButton.setLayoutData((Object)tasksLayoutData);
        this.tasksButton.setText(Messages.XPlannerCustomQueryPage_TASKS_BUTTON);
        this.tasksButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                XPlannerCustomQueryPage.this.refreshProjects();
                XPlannerCustomQueryPage.this.validatePage();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.tasksButton.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                XPlannerCustomQueryPage.this.validatePage();
            }
        });
        this.storiesButton = new Button(typeComposite, 16);
        this.storiesButton.setLayoutData((Object)new GridData(1, 1, false, false));
        this.storiesButton.setText(Messages.XPlannerCustomQueryPage_USER_STORIES_BUTTON);
        GridData storiesLayoutData = new GridData(1, 1, false, false);
        storiesLayoutData.horizontalIndent = 10;
        this.storiesButton.setLayoutData((Object)storiesLayoutData);
        this.storiesButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                XPlannerCustomQueryPage.this.refreshProjects();
                XPlannerCustomQueryPage.this.validatePage();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.storiesButton.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                XPlannerCustomQueryPage.this.validatePage();
            }
        });
    }

    protected void addContentTypeListener(SelectionListener listener) {
        this.tasksButton.addSelectionListener(listener);
    }

    protected void removeContentTypeListener(SelectionListener listener) {
        this.tasksButton.removeSelectionListener(listener);
    }

    private void createScopeButtons(Composite parent) {
        Composite scopeComposite = new Composite(parent, 0);
        scopeComposite.setLayout((Layout)new GridLayout());
        GridData scopeCompositeLayoutData = new GridData(4, 1, true, false);
        scopeCompositeLayoutData.verticalIndent = 10;
        scopeComposite.setLayoutData((Object)scopeCompositeLayoutData);
        this.scopeLabel = new Label(scopeComposite, 0);
        this.scopeLabel.setData((Object)new GridData(1, 1, false, false));
        this.scopeLabel.setText(Messages.XPlannerCustomQueryPage_SCOPE_LABEL);
        this.allTasksOrStoriesButton = new Button(scopeComposite, 16);
        GridData allTasksOrStoriesLayoutData = new GridData(1, 1, false, false);
        allTasksOrStoriesLayoutData.horizontalIndent = 10;
        this.allTasksOrStoriesButton.setLayoutData((Object)allTasksOrStoriesLayoutData);
        this.allTasksOrStoriesButton.setText(Messages.XPlannerCustomQueryPage_ALL_BUTTON);
        this.myTasksOrStoriesButton = new Button(scopeComposite, 16);
        GridData myTasksOrStoriesLayoutData = new GridData(1, 1, false, false);
        myTasksOrStoriesLayoutData.horizontalIndent = 10;
        this.myTasksOrStoriesButton.setLayoutData((Object)myTasksOrStoriesLayoutData);
        this.myTasksOrStoriesButton.setText(Messages.XPlannerCustomQueryPage_MY_BUTTON);
    }

    public boolean canFlipToNextPage() {
        return false;
    }

    public IWizardPage getNextPage() {
        return null;
    }

    public void validatePage() {
        StructuredSelection selection;
        String errorMessage = null;
        if (this.getQueryTitle().length() == 0) {
            errorMessage = Messages.XPlannerCustomQueryPage_QUERY_NAME_NEEDED;
        }
        if (errorMessage == null && this.selectedTasksButton.getSelection() && ((selection = (StructuredSelection)this.projectsViewer.getSelection()) == null || selection.isEmpty())) {
            errorMessage = Messages.XPlannerCustomQueryPage_PROJECT_ELEMENT_NEEDED;
        }
        this.setErrorMessage(errorMessage);
        this.setPageComplete(errorMessage == null);
        if (this.getSearchContainer() != null) {
            this.getSearchContainer().setPerformActionEnabled(this.isPageComplete());
        }
    }

    public boolean isPageComplete() {
        boolean complete;
        boolean bl = complete = this.getErrorMessage() == null;
        if (complete) {
            if (this.nameText != null && this.nameText.getText().length() > 0) {
                complete = true;
                this.setErrorMessage(null);
            } else if (!this.inSearchContainer()) {
                complete = false;
                this.setErrorMessage(Messages.XPlannerCustomQueryPage_QUERY_NAME_NEEDED);
            }
        }
        return complete;
    }

    private void refreshProjects() {
        this.projectsViewer.refresh();
    }

    private void loadFromDefaults() {
        this.myTasksButton.setSelection(true);
        this.tasksButton.setSelection(true);
        this.myTasksOrStoriesButton.setSelection(true);
        this.projectsViewer.expandToLevel(2);
    }

    private void loadFromExistingQuery() {
        if (this.getExistingQuery().getSummary() != null) {
            this.nameText.setText(this.getExistingQuery().getSummary());
        }
        boolean isMyCurrentTasks = XPlannerTaskListMigrator.isMyCurrentTasks(this.getExistingQuery());
        this.myTasksButton.setSelection(isMyCurrentTasks);
        this.selectedTasksButton.setSelection(!isMyCurrentTasks);
        int personId = XPlannerTaskListMigrator.getPersonId(this.getExistingQuery());
        if (personId != -1) {
            this.myTasksOrStoriesButton.setSelection(true);
        } else {
            this.allTasksOrStoriesButton.setSelection(true);
        }
        boolean isUseTasks = XPlannerTaskListMigrator.isUseTasks(this.getExistingQuery());
        if (isUseTasks) {
            this.tasksButton.setSelection(true);
        } else {
            this.storiesButton.setSelection(true);
        }
        List<Integer> contentIds = XPlannerTaskListMigrator.getContentIds(this.getExistingQuery());
        if (contentIds != XPlannerTaskListMigrator.INVALID_IDS) {
            List<Object> selection = this.getProjectElementsToSelect();
            this.projectsViewer.setSelection((ISelection)new StructuredSelection(selection));
        }
    }

    private List<Object> getProjectElementsToSelect() {
        ArrayList<Object> selection = new ArrayList<Object>();
        XPlannerTaskListMigrator.ContentIdType contentIdType = XPlannerTaskListMigrator.getContentIdType(this.getExistingQuery());
        List<Integer> contentIds = XPlannerTaskListMigrator.getContentIds(this.getExistingQuery());
        for (int contentId : contentIds) {
            try {
                if (contentIdType == XPlannerTaskListMigrator.ContentIdType.PROJECT) {
                    selection.add(this.client.getProject(contentId));
                    continue;
                }
                if (contentIdType == XPlannerTaskListMigrator.ContentIdType.ITERATION) {
                    selection.add(this.client.getIteration(contentId));
                    continue;
                }
                if (contentIdType != XPlannerTaskListMigrator.ContentIdType.USER_STORY) continue;
                selection.add(this.client.getUserStory(contentId));
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        return selection;
    }

    private boolean isUseAll() {
        return this.allTasksOrStoriesButton.getSelection();
    }

    void applyChanges(IRepositoryQuery query) {
        if (query == null) {
            return;
        }
        query.setSummary(this.getQueryTitle());
        if (this.myTasksButton.getSelection()) {
            XPlannerTaskListMigrator.setMyCurrentTasks(query, true);
        } else {
            XPlannerTaskListMigrator.setMyCurrentTasks(query, false);
            XPlannerTaskListMigrator.setUseTasks(query, this.tasksButton.getSelection());
            if (!this.isUseAll()) {
                XPlannerTaskListMigrator.setPersonId(query, this.client.getCurrentPersonId());
            } else {
                XPlannerTaskListMigrator.setPersonId(query, -1);
            }
            XPlannerTaskListMigrator.setContentIds(query, this.getSelectedContentIds());
            XPlannerTaskListMigrator.setContentIdType(query, this.getSelectedContentIdType());
        }
    }

    private XPlannerTaskListMigrator.ContentIdType getSelectedContentIdType() {
        XPlannerTaskListMigrator.ContentIdType contentIdType = XPlannerTaskListMigrator.ContentIdType.USER_STORY;
        StructuredSelection selection = (StructuredSelection)this.projectsViewer.getSelection();
        Object selectedElement = selection.getFirstElement();
        if (selectedElement instanceof ProjectData) {
            contentIdType = XPlannerTaskListMigrator.ContentIdType.PROJECT;
        } else if (selectedElement instanceof IterationData) {
            contentIdType = XPlannerTaskListMigrator.ContentIdType.ITERATION;
        } else if (selectedElement instanceof UserStoryData) {
            contentIdType = XPlannerTaskListMigrator.ContentIdType.USER_STORY;
        }
        return contentIdType;
    }

    private List<Integer> getSelectedContentIds() {
        ArrayList<Integer> selectedIds = new ArrayList<Integer>();
        StructuredSelection selection = (StructuredSelection)this.projectsViewer.getSelection();
        if (selection.size() == 0) {
            selectedIds.add(-1);
        } else {
            for (Object selectedElement : selection) {
                if (selectedElement instanceof ProjectData) {
                    selectedIds.add(((ProjectData)selectedElement).getId());
                    continue;
                }
                if (selectedElement instanceof IterationData) {
                    selectedIds.add(((IterationData)selectedElement).getId());
                    continue;
                }
                if (!(selectedElement instanceof UserStoryData)) continue;
                selectedIds.add(((UserStoryData)selectedElement).getId());
            }
        }
        return selectedIds;
    }

    public String getQueryTitle() {
        return this.nameText != null ? this.nameText.getText() : "<search>";
    }

    @Override
    public IRepositoryQuery getQuery() {
        if (this.getExistingQuery() == null) {
            this.setExistingQuery(TasksUi.getRepositoryModel().createRepositoryQuery(this.getRepository()));
        }
        this.applyChanges(this.getExistingQuery());
        return this.getExistingQuery();
    }

    @Override
    public List<IRepositoryQuery> getQueries() {
        ArrayList<IRepositoryQuery> queries = new ArrayList();
        if (this.isContentTypeTask()) {
            if (this.getExistingQuery() == null) {
                this.setExistingQuery(TasksUi.getRepositoryModel().createRepositoryQuery(this.getRepository()));
            }
            this.applyChanges(this.getExistingQuery());
            queries.add(this.getExistingQuery());
        } else {
            queries = this.createTaskQueriesForUserStories(this.getSelectedUserStories());
        }
        return queries;
    }

    private List<UserStoryData> getSelectedUserStories() {
        ArrayList<UserStoryData> userStories = new ArrayList<UserStoryData>();
        StructuredSelection selection = (StructuredSelection)this.projectsViewer.getSelection();
        Object selectedElement = selection.getFirstElement();
        try {
            if (selectedElement instanceof ProjectData) {
                IterationData[] iterations;
                IterationData[] iterationDataArray = iterations = this.client.getIterations(((ProjectData)selectedElement).getId());
                int n = iterations.length;
                int n2 = 0;
                while (n2 < n) {
                    IterationData iteration = iterationDataArray[n2];
                    userStories.addAll(Arrays.asList(this.client.getUserStories(iteration.getId())));
                    ++n2;
                }
            } else if (selectedElement instanceof IterationData) {
                userStories.addAll(Arrays.asList(this.client.getUserStories(((IterationData)selectedElement).getId())));
            } else if (selectedElement instanceof UserStoryData) {
                userStories.add((UserStoryData)selectedElement);
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return userStories;
    }

    public List<IRepositoryQuery> createTaskQueriesForUserStories(List<UserStoryData> userStories) {
        if (userStories == null || userStories.size() == 0) {
            return new ArrayList<IRepositoryQuery>();
        }
        ArrayList<IRepositoryQuery> queries = new ArrayList<IRepositoryQuery>();
        int personId = this.client.getCurrentPersonId();
        for (UserStoryData userStory : userStories) {
            TaskData[] personUserStoryTasks;
            boolean createQuery = true;
            if (!(this.isUseAll() || (personUserStoryTasks = this.client.getUserStoryTasksForPerson(personId, userStory.getId())) != null && personUserStoryTasks.length != 0)) {
                createQuery = false;
            }
            if (!createQuery) continue;
            String nameSuffix = String.valueOf(Messages.XPlannerCustomQueryPage_USER_STORY) + userStory.getName();
            String queryName = this.getQueryTitle();
            if (!queryName.contains(nameSuffix)) {
                queryName = String.valueOf(queryName) + nameSuffix;
            }
            IRepositoryQuery query = TasksUi.getRepositoryModel().createRepositoryQuery(this.getTaskRepository());
            this.applyChanges(query);
            query.setSummary(queryName);
            XPlannerTaskListMigrator.setContentIds(query, Arrays.asList(userStory.getId()));
            XPlannerTaskListMigrator.setContentIdType(query, XPlannerTaskListMigrator.ContentIdType.USER_STORY);
            XPlannerTaskListMigrator.setUseTasks(query, true);
            queries.add(query);
        }
        return queries;
    }

    public TreeViewer getProjectsViewer() {
        return this.projectsViewer;
    }

    public void setControlsEnabled(boolean enabled) {
        super.setControlsEnabled(enabled);
        this.updateSelectionControls();
        this.validatePage();
    }

    public void applyTo(IRepositoryQuery query) {
        this.applyChanges(query);
    }
}

