/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.oslc.core.client;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.net.AbstractWebLocation;
import org.eclipse.mylyn.commons.net.Policy;
import org.eclipse.mylyn.commons.net.WebUtil;
import org.eclipse.mylyn.internal.oslc.core.IOslcCoreConstants;
import org.eclipse.mylyn.internal.oslc.core.OslcCreationDialogDescriptor;
import org.eclipse.mylyn.internal.oslc.core.OslcSelectionDialogDescriptor;
import org.eclipse.mylyn.internal.oslc.core.OslcServiceDescriptor;
import org.eclipse.mylyn.internal.oslc.core.OslcServiceFactory;
import org.eclipse.mylyn.internal.oslc.core.OslcServiceProvider;
import org.eclipse.mylyn.internal.oslc.core.OslcServiceProviderCatalog;
import org.eclipse.mylyn.internal.oslc.core.ServiceHome;
import org.eclipse.mylyn.internal.oslc.core.cm.AbstractChangeRequest;
import org.eclipse.mylyn.tasks.core.RepositoryResponse;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;
import org.jdom.input.SAXBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOslcClient {
    protected final AbstractWebLocation location;
    protected final HttpClient httpClient;
    protected final OslcServiceDescriptor configuration;

    public AbstractOslcClient(AbstractWebLocation location, OslcServiceDescriptor data) {
        this.location = location;
        this.httpClient = this.createHttpClient();
        this.configuration = data;
    }

    protected HttpClient createHttpClient() {
        HttpClient httpClient = new HttpClient();
        httpClient.setHttpConnectionManager(WebUtil.getConnectionManager());
        httpClient.getParams().setCookiePolicy("rfc2109");
        httpClient.getParams().setParameter("http.protocol.single-cookie-header", (Object)true);
        WebUtil.configureHttpClient((HttpClient)httpClient, (String)this.getUserAgent());
        return httpClient;
    }

    public abstract String getUserAgent();

    public List<OslcServiceProvider> getAvailableServices(String url, IProgressMonitor monitor) throws CoreException {
        RequestHandler<List<OslcServiceProvider>> handler = new RequestHandler<List<OslcServiceProvider>>("Requesting Available Services"){

            @Override
            public List<OslcServiceProvider> run(HttpMethodBase method, IProgressMonitor monitor) throws CoreException {
                try {
                    ArrayList<OslcServiceProvider> result = new ArrayList<OslcServiceProvider>();
                    AbstractOslcClient.this.parseServices(method.getResponseBodyAsStream(), result, monitor);
                    return result;
                }
                catch (IOException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.oslc.core", "Network error occurred retrieving available services: " + e.getMessage(), (Throwable)e));
                }
            }
        };
        return this.executeMethod((HttpMethodBase)this.createGetMethod(url), handler, monitor);
    }

    protected Document getDocumentFromMethod(HttpMethodBase method) throws CoreException {
        try {
            return this.getDocumentFromStream(method.getResponseBodyAsStream());
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.oslc.core", "Network error obtaining response from server: " + e.getMessage(), (Throwable)e));
        }
    }

    protected Document getDocumentFromStream(InputStream inStream) throws CoreException {
        SAXBuilder builder = new SAXBuilder();
        builder.setExpandEntities(false);
        try {
            return builder.build(inStream);
        }
        catch (JDOMException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.oslc.core", "Error parsing response: " + e.getMessage(), (Throwable)e));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.oslc.core", "Network error parsing response: " + e.getMessage(), (Throwable)e));
        }
    }

    public void parseServices(InputStream inStream, Collection<OslcServiceProvider> providers, IProgressMonitor monitor) throws CoreException {
        Element element;
        Document doc = this.getDocumentFromStream(inStream);
        Iterator itr = doc.getDescendants((Filter)new ElementFilter("ServiceProviderCatalog"));
        while (itr.hasNext()) {
            element = (Element)itr.next();
            if (element.getParent() == doc.getRootElement()) continue;
            Attribute attrResource = element.getAttribute("resource", IOslcCoreConstants.NAMESPACE_RDF);
            String title = element.getChild("title", IOslcCoreConstants.NAMESPACE_DC).getText();
            if (attrResource == null || attrResource.getValue().length() <= 0) continue;
            providers.add(new OslcServiceProviderCatalog(title, attrResource.getValue()));
        }
        itr = doc.getDescendants((Filter)new ElementFilter("ServiceProvider"));
        while (itr.hasNext()) {
            element = (Element)itr.next();
            String title = element.getChild("title", IOslcCoreConstants.NAMESPACE_DC).getText();
            Element service = element.getChild("services", IOslcCoreConstants.NAMESPACE_OSLC_DISCOVERY_1_0);
            if (service == null) continue;
            String resource = service.getAttributeValue("resource", IOslcCoreConstants.NAMESPACE_RDF);
            providers.add(new OslcServiceProvider(title, resource));
        }
    }

    public OslcServiceDescriptor getServiceDescriptor(OslcServiceProvider provider, IProgressMonitor monitor) throws CoreException {
        OslcServiceDescriptor configuration = new OslcServiceDescriptor(provider.getUrl());
        this.downloadServiceDescriptor(configuration, monitor);
        return configuration;
    }

    protected void downloadServiceDescriptor(final OslcServiceDescriptor config, IProgressMonitor monitor) throws CoreException {
        RequestHandler<OslcServiceDescriptor> handler = new RequestHandler<OslcServiceDescriptor>("Retrieving Service Descriptor"){

            @Override
            public OslcServiceDescriptor run(HttpMethodBase method, IProgressMonitor monitor) throws CoreException, IOException {
                config.clear();
                AbstractOslcClient.this.parseServiceDescriptor(method.getResponseBodyAsStream(), config, monitor);
                return config;
            }
        };
        this.executeMethod((HttpMethodBase)this.createGetMethod(config.getAboutUrl()), handler, monitor);
    }

    public void parseServiceDescriptor(InputStream inStream, OslcServiceDescriptor config, IProgressMonitor monitor) throws CoreException {
        Element childUrl;
        Element childTitle;
        Element element;
        String url;
        String url2;
        Element element2;
        Element element3;
        Document doc = this.getDocumentFromStream(inStream);
        Iterator itr = doc.getDescendants((Filter)new ElementFilter("title", IOslcCoreConstants.NAMESPACE_DC));
        if (itr.hasNext()) {
            element3 = (Element)itr.next();
            config.setTitle(element3.getText());
        }
        if ((itr = doc.getDescendants((Filter)new ElementFilter("description", IOslcCoreConstants.NAMESPACE_DC))).hasNext()) {
            element3 = (Element)itr.next();
            config.setDescription(element3.getText());
        }
        itr = doc.getDescendants((Filter)new ElementFilter("creationDialog"));
        while (itr.hasNext()) {
            boolean isDefault = false;
            element2 = (Element)itr.next();
            String label = element2.getChild("title", IOslcCoreConstants.NAMESPACE_DC).getText();
            url2 = element2.getChild("url", IOslcCoreConstants.NAMESPACE_OSLC_CM_1_0).getText();
            Attribute attrDefault = element2.getAttribute("default", IOslcCoreConstants.NAMESPACE_OSLC_CM_1_0);
            if (attrDefault != null && attrDefault.getValue().equals("true")) {
                isDefault = true;
            }
            OslcCreationDialogDescriptor recordType = new OslcCreationDialogDescriptor(label, url2);
            config.addCreationDialog(recordType);
            if (!isDefault) continue;
            config.setDefaultCreationDialog(recordType);
        }
        itr = doc.getDescendants((Filter)new ElementFilter("simpleQuery"));
        if (itr.hasNext() && (url = (element = (Element)itr.next()).getChild("url", IOslcCoreConstants.NAMESPACE_OSLC_CM_1_0).getText()) != null) {
            config.setSimpleQueryUrl(url);
        }
        itr = doc.getDescendants((Filter)new ElementFilter("factory"));
        while (itr.hasNext()) {
            boolean isDefault = false;
            element2 = (Element)itr.next();
            String title = element2.getChild("title", IOslcCoreConstants.NAMESPACE_DC).getText();
            url2 = element2.getChild("url", IOslcCoreConstants.NAMESPACE_OSLC_CM_1_0).getText();
            if (element2.getAttribute("default") != null && element2.getAttribute("default").getValue().equals("true")) {
                isDefault = true;
            }
            OslcServiceFactory factory = new OslcServiceFactory(title, url2);
            if (isDefault) {
                config.setDefaultFactory(factory);
            }
            config.addServiceFactory(factory);
        }
        itr = doc.getDescendants((Filter)new ElementFilter("home"));
        if (itr.hasNext()) {
            element = (Element)itr.next();
            childTitle = element.getChild("title", IOslcCoreConstants.NAMESPACE_DC);
            childUrl = element.getChild("url", IOslcCoreConstants.NAMESPACE_OSLC_CM_1_0);
            if (childTitle != null && childTitle.getText().length() > 0 && childUrl != null && childUrl.getText().length() > 0) {
                ServiceHome home = new ServiceHome(childTitle.getText(), childUrl.getText());
                config.setHome(home);
            }
        }
        if ((itr = doc.getDescendants((Filter)new ElementFilter("selectionDialog"))).hasNext()) {
            element = (Element)itr.next();
            childTitle = element.getChild("title", IOslcCoreConstants.NAMESPACE_DC);
            childUrl = element.getChild("url", IOslcCoreConstants.NAMESPACE_OSLC_CM_1_0);
            if (childTitle != null && childTitle.getText().length() > 0 && childUrl != null && childUrl.getText().length() > 0) {
                String label;
                String hintWidth;
                String hintHeight;
                OslcSelectionDialogDescriptor selection = new OslcSelectionDialogDescriptor(childTitle.getText(), childUrl.getText());
                String isDefault = element.getAttributeValue("default", IOslcCoreConstants.NAMESPACE_OSLC_CM_1_0);
                if (isDefault != null) {
                    selection.setDefault(isDefault.equals("true"));
                }
                if ((hintHeight = element.getAttributeValue("hintHeight", IOslcCoreConstants.NAMESPACE_OSLC_CM_1_0)) != null) {
                    selection.setHintHeight(hintHeight);
                }
                if ((hintWidth = element.getAttributeValue("hintWidth", IOslcCoreConstants.NAMESPACE_OSLC_CM_1_0)) != null) {
                    selection.setHintWidth(hintWidth);
                }
                if ((label = element.getChildText("label", IOslcCoreConstants.NAMESPACE_OSLC_CM_1_0)) != null) {
                    selection.setLabel(label);
                }
                config.addSelectionDialog(selection);
            }
        }
    }

    public Collection<AbstractChangeRequest> performQuery(String queryUrl, IProgressMonitor monitor) throws CoreException {
        RequestHandler<Collection<AbstractChangeRequest>> handler = new RequestHandler<Collection<AbstractChangeRequest>>("Performing Query"){

            @Override
            public Collection<AbstractChangeRequest> run(HttpMethodBase method, IProgressMonitor monitor) throws CoreException, IOException {
                ArrayList<AbstractChangeRequest> result = new ArrayList<AbstractChangeRequest>();
                AbstractOslcClient.this.parseQueryResponse(method.getResponseBodyAsStream(), result, monitor);
                return result;
            }
        };
        return this.executeMethod((HttpMethodBase)this.createGetMethod(queryUrl), handler, monitor);
    }

    public void parseQueryResponse(InputStream inStream, Collection<AbstractChangeRequest> requests, IProgressMonitor monitor) throws CoreException {
        Document doc = this.getDocumentFromStream(inStream);
        Iterator itr = doc.getDescendants((Filter)new ElementFilter("ChangeRequest", IOslcCoreConstants.NAMESPACE_OSLC_CM_1_0));
        while (itr.hasNext()) {
            Element element = (Element)itr.next();
            String title = element.getChildText("title", IOslcCoreConstants.NAMESPACE_DC);
            String id = element.getChildText("identifier", IOslcCoreConstants.NAMESPACE_DC);
            if (title == null || id == null) continue;
            AbstractChangeRequest request = this.createChangeRequest(id, title);
            request.setType(element.getChildText("type", IOslcCoreConstants.NAMESPACE_DC));
            request.setDescription(element.getChildText("description", IOslcCoreConstants.NAMESPACE_DC));
            request.setSubject(element.getChildText("subject", IOslcCoreConstants.NAMESPACE_DC));
            request.setCreator(element.getChildText("creator", IOslcCoreConstants.NAMESPACE_DC));
            request.setModified(element.getChildText("modified", IOslcCoreConstants.NAMESPACE_DC));
            requests.add(request);
        }
    }

    protected abstract AbstractChangeRequest createChangeRequest(String var1, String var2);

    public void updateRepositoryConfiguration(IProgressMonitor monitor) throws CoreException {
        this.configuration.clear();
        this.downloadServiceDescriptor(this.configuration, monitor);
    }

    public abstract TaskData getTaskData(String var1, TaskAttributeMapper var2, IProgressMonitor var3) throws CoreException;

    public abstract RepositoryResponse putTaskData(TaskData var1, Set<TaskAttribute> var2, IProgressMonitor var3) throws CoreException;

    protected GetMethod createGetMethod(String requestPath) {
        GetMethod method = new GetMethod(this.getRequestPath(requestPath));
        method.setFollowRedirects(false);
        method.setDoAuthentication(true);
        return method;
    }

    protected PostMethod createPostMethod(String requestPath) {
        PostMethod method = new PostMethod(this.getRequestPath(requestPath));
        method.setFollowRedirects(false);
        method.setDoAuthentication(true);
        return method;
    }

    protected PutMethod createPutMethod(String requestPath) {
        PutMethod method = new PutMethod(this.getRequestPath(requestPath));
        method.setFollowRedirects(false);
        method.setDoAuthentication(true);
        return method;
    }

    protected <T> T executeMethod(HttpMethodBase method, RequestHandler<T> handler, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        try {
            monitor.beginTask(handler.getRequestName(), -1);
            HostConfiguration hostConfiguration = WebUtil.createHostConfiguration((HttpClient)this.httpClient, (AbstractWebLocation)this.location, (IProgressMonitor)monitor);
            int code = WebUtil.execute((HttpClient)this.httpClient, (HostConfiguration)hostConfiguration, (HttpMethod)method, (IProgressMonitor)monitor);
            handler.handleReturnCode(code, method);
            T t = handler.run(method, monitor);
            return t;
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(2, "org.eclipse.mylyn.oslc.core", "An unexpected network error has occurred: " + e.getMessage(), (Throwable)e));
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
            monitor.done();
        }
    }

    public String getRequestPath(String repositoryUrl) {
        if (repositoryUrl.startsWith("./")) {
            return String.valueOf(WebUtil.getRequestPath((String)this.location.getUrl())) + repositoryUrl.substring(1);
        }
        if (repositoryUrl.startsWith("/")) {
            return String.valueOf(WebUtil.getRequestPath((String)this.location.getUrl())) + repositoryUrl;
        }
        return WebUtil.getRequestPath((String)repositoryUrl);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class RequestHandler<T> {
        private final String requestName;

        public RequestHandler(String requestName) {
            this.requestName = requestName;
        }

        public abstract T run(HttpMethodBase var1, IProgressMonitor var2) throws CoreException, IOException;

        public String getRequestName() {
            return this.requestName;
        }

        protected void handleReturnCode(int code, HttpMethodBase method) throws CoreException {
            try {
                if (code == 200) {
                    return;
                }
                if (code == 302 || code == 201) {
                    return;
                }
                if (code == 401 || code == 403) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.oslc.core", "Unable to log into server, ensure repository credentials are correct."));
                }
                if (code == 412) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.oslc.core", "Mid-air collision occurred."));
                }
                if (code == 409) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.oslc.core", "A conflict occurred."));
                }
                throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.oslc.core", "Unknown error occurred. Http Code: " + code + " Request: " + method.getURI() + " Response: " + method.getResponseBodyAsString()));
            }
            catch (URIException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.oslc.core", "Network Error: " + e.getMessage()));
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.oslc.core", "Network Error: " + e.getMessage()));
            }
        }
    }
}

